/************************************************************************************************/
/* Stata User File for H129 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H129.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H129.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H129.DO                                               */
/* The program below will output the Stata dataset H129.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  byte   PANEL 17-18
  str    FAMID31 19-20
  str    FAMID42 21-22
  str    FAMID53 23-24
  str    FAMID09 25-26
  str    FAMIDYR 27-28
  str    CPSFAMID 29-30
  str    HIEUIDX 31-37
  byte   FCSZ1231 38-39
  byte   FCRP1231 40-41
  str    RULETR31 42-43
  str    RULETR42 44-45
  str    RULETR53 46-47
  str    RULETR09 48-49
  byte   RUSIZE31 50-51
  byte   RUSIZE42 52-53
  byte   RUSIZE53 54-55
  byte   RUSIZE09 56-57
  byte   RUCLAS31 58-59
  byte   RUCLAS42 60-61
  byte   RUCLAS53 62-63
  byte   RUCLAS09 64-64
  byte   FAMSZE31 65-66
  byte   FAMSZE42 67-68
  byte   FAMSZE53 69-70
  byte   FAMSZE09 71-72
  byte   FMRS1231 73-74
  byte   FAMS1231 75-76
  byte   FAMSZEYR 77-78
  byte   FAMRFPYR 79-79
  byte   REGION31 80-81
  byte   REGION42 82-83
  byte   REGION53 84-85
  byte   REGION09 86-87
  byte   MSA31 88-89
  byte   MSA42 90-91
  byte   MSA53 92-93
  byte   MSA09 94-95
  int    REFPRS31 96-98
  int    REFPRS42 99-101
  int    REFPRS53 102-104
  int    REFPRS09 105-107
  byte   RESP31 108-108
  byte   RESP42 109-109
  byte   RESP53 110-110
  byte   RESP09 111-111
  byte   PROXY31 112-113
  byte   PROXY42 114-115
  byte   PROXY53 116-117
  byte   PROXY09 118-118
  byte   INTVLANG 119-120
  byte   BEGRFD31 121-122
  byte   BEGRFM31 123-124
  int    BEGRFY31 125-128
  byte   ENDRFD31 129-130
  byte   ENDRFM31 131-132
  int    ENDRFY31 133-136
  byte   BEGRFD42 137-138
  byte   BEGRFM42 139-140
  int    BEGRFY42 141-144
  byte   ENDRFD42 145-146
  byte   ENDRFM42 147-148
  int    ENDRFY42 149-152
  byte   BEGRFD53 153-154
  byte   BEGRFM53 155-156
  int    BEGRFY53 157-160
  byte   ENDRFD53 161-162
  byte   ENDRFM53 163-164
  int    ENDRFY53 165-168
  byte   ENDRFD09 169-170
  byte   ENDRFM09 171-172
  int    ENDRFY09 173-176
  byte   KEYNESS 177-177
  byte   INSCOP31 178-178
  byte   INSCOP42 179-179
  byte   INSCOP53 180-180
  byte   INSCOP09 181-181
  byte   INSC1231 182-182
  byte   INSCOPE 183-183
  byte   ELGRND31 184-184
  byte   ELGRND42 185-185
  byte   ELGRND53 186-186
  byte   ELGRND09 187-187
  byte   PSTATS31 188-189
  byte   PSTATS42 190-191
  byte   PSTATS53 192-193
  str    RURSLT31 194-195
  str    RURSLT42 196-197
  str    RURSLT53 198-199
  byte   AGE31X 200-201
  byte   AGE42X 202-203
  byte   AGE53X 204-205
  byte   AGE09X 206-207
  byte   AGELAST 208-209
  byte   DOBMM 210-211
  int    DOBYY 212-215
  byte   SEX 216-216
  byte   RACEX 217-217
  byte   RACEAX 218-218
  byte   RACEBX 219-219
  byte   RACEWX 220-220
  byte   RACETHNX 221-221
  byte   HISPANX 222-222
  byte   HISPCAT 223-224
  byte   MARRY31X 225-226
  byte   MARRY42X 227-228
  byte   MARRY53X 229-230
  byte   MARRY09X 231-232
  int    SPOUID31 233-235
  int    SPOUID42 236-238
  int    SPOUID53 239-241
  int    SPOUID09 242-244
  byte   SPOUIN31 245-246
  byte   SPOUIN42 247-248
  byte   SPOUIN53 249-250
  byte   SPOUIN09 251-252
  byte   EDUCYR 253-254
  byte   HIDEG 255-256
  byte   FTSTU31X 257-258
  byte   FTSTU42X 259-260
  byte   FTSTU53X 261-262
  byte   FTSTU09X 263-264
  byte   ACTDTY31 265-266
  byte   ACTDTY42 267-268
  byte   ACTDTY53 269-270
  byte   HONRDC31 271-272
  byte   HONRDC42 273-274
  byte   HONRDC53 275-276
  byte   RFREL31X 277-278
  byte   RFREL42X 279-280
  byte   RFREL53X 281-282
  byte   RFREL09X 283-284
  int    MOPID31X 285-287
  int    MOPID42X 288-290
  int    MOPID53X 291-293
  int    DAPID31X 294-296
  int    DAPID42X 297-299
  int    DAPID53X 300-302
  byte   RTHLTH31 303-304
  byte   RTHLTH42 305-306
  byte   RTHLTH53 307-308
  byte   MNHLTH31 309-310
  byte   MNHLTH42 311-312
  byte   MNHLTH53 313-314
  byte   HIBPDX 315-316
  byte   HIBPAGED 317-318
  byte   BPMLDX 319-320
  byte   CHDDX 321-322
  byte   CHDAGED 323-324
  byte   ANGIDX 325-326
  byte   ANGIAGED 327-328
  byte   MIDX 329-330
  byte   MIAGED 331-332
  byte   OHRTDX 333-334
  byte   OHRTAGED 335-336
  byte   STRKDX 337-338
  byte   STRKAGED 339-340
  byte   EMPHDX 341-342
  byte   EMPHAGED 343-344
  byte   CHBRON31 345-346
  byte   CHBRON53 347-348
  byte   CHOLDX 349-350
  byte   CHOLAGED 351-352
  byte   CANCERDX 353-354
  byte   CABLADDR 355-356
  byte   BLDRAGED 357-358
  byte   BLDRREMS 359-360
  byte   CABONE 361-362
  byte   BONEAGED 363-364
  byte   BONEREMS 365-366
  byte   CABRAIN 367-368
  byte   BRAIAGED 369-370
  byte   BRAIREMS 371-372
  byte   CABREAST 373-374
  byte   BRSTAGED 375-376
  byte   BRSTREMS 377-378
  byte   CACERVIX 379-380
  byte   CERVAGED 381-382
  byte   CERVREMS 383-384
  byte   CACOLON 385-386
  byte   COLOAGED 387-388
  byte   COLOREMS 389-390
  byte   CAKIDNEY 391-392
  byte   KIDNAGED 393-394
  byte   KIDNREMS 395-396
  byte   CALARYNX 397-398
  byte   LRNXAGED 399-400
  byte   LRNXREMS 401-402
  byte   CALEUKEM 403-404
  byte   LEUKAGED 405-406
  byte   LEUKREMS 407-408
  byte   CALIVER 409-410
  byte   LIVRAGED 411-412
  byte   LIVRREMS 413-414
  byte   CALUNG 415-416
  byte   LUNGAGED 417-418
  byte   LUNGREMS 419-420
  byte   CALYMPH 421-422
  byte   LYMPAGED 423-424
  byte   LYMPREMS 425-426
  byte   CAMELANO 427-428
  byte   MELAAGED 429-430
  byte   MELAREMS 431-432
  byte   CAMOUTH 433-434
  byte   MOUTAGED 435-436
  byte   MOUTREMS 437-438
  byte   CAMUSCLE 439-440
  byte   MUSCAGED 441-442
  byte   MUSCREMS 443-444
  byte   CAOTHER 445-446
  byte   OTHRAGED 447-448
  byte   OTHRREMS 449-450
  byte   CAOVARY 451-452
  byte   OVRYAGED 453-454
  byte   OVRYREMS 455-456
  byte   CAPANCRS 457-458
  byte   PANCAGED 459-460
  byte   PANCREMS 461-462
  byte   CAPROSTA 463-464
  byte   PRSTAGED 465-466
  byte   PRSTREMS 467-468
  byte   CARECTUM 469-470
  byte   RECTAGED 471-472
  byte   RECTREMS 473-474
  byte   CASKINNM 475-476
  byte   SKNMAGED 477-478
  byte   SKNMREMS 479-480
  byte   CASKINDK 481-482
  byte   SKDKAGED 483-484
  byte   SKDKREMS 485-486
  byte   CASTOMCH 487-488
  byte   STOMAGED 489-490
  byte   STOMREMS 491-492
  byte   CATESTIS 493-494
  byte   TSTSAGED 495-496
  byte   TSTSREMS 497-498
  byte   CATHROAT 499-500
  byte   THRTAGED 501-502
  byte   THRTREMS 503-504
  byte   CATHYROD 505-506
  byte   THYRAGED 507-508
  byte   THYRREMS 509-510
  byte   CAUTERUS 511-512
  byte   UTERAGED 513-514
  byte   UTERREMS 515-516
  byte   DIABDX 517-518
  byte   DIABAGED 519-520
  byte   JTPAIN31 521-522
  byte   JTPAIN53 523-524
  byte   ARTHDX 525-526
  byte   ARTHTYPE 527-528
  byte   ARTHAGED 529-530
  byte   ASTHDX 531-532
  byte   ASTHAGED 533-534
  byte   ASSTIL31 535-536
  byte   ASSTIL53 537-538
  byte   ASATAK31 539-540
  byte   ASATAK53 541-542
  byte   ASTHEP31 543-544
  byte   ASTHEP53 545-546
  byte   ASACUT53 547-548
  byte   ASMRCN53 549-550
  byte   ASPREV53 551-552
  byte   ASDALY53 553-554
  byte   ASPKFL53 555-556
  byte   ASEVFL53 557-558
  byte   ASWNFL53 559-560
  byte   ADHDADDX 561-562
  byte   ADHDAGED 563-564
  byte   PREGNT31 565-566
  byte   PREGNT42 567-568
  byte   PREGNT53 569-570
  byte   IADLHP31 571-572
  byte   IADLHP42 573-574
  byte   IADLHP53 575-576
  byte   IADL3M31 577-578
  byte   IADL3M42 579-580
  byte   IADL3M53 581-582
  byte   ADLHLP31 583-584
  byte   ADLHLP42 585-586
  byte   ADLHLP53 587-588
  byte   ADL3MO31 589-590
  byte   ADL3MO42 591-592
  byte   ADL3MO53 593-594
  byte   AIDHLP31 595-596
  byte   AIDHLP53 597-598
  byte   WLKLIM31 599-600
  byte   WLKLIM53 601-602
  byte   LFTDIF31 603-604
  byte   LFTDIF53 605-606
  byte   STPDIF31 607-608
  byte   STPDIF53 609-610
  byte   WLKDIF31 611-612
  byte   WLKDIF53 613-614
  byte   MILDIF31 615-616
  byte   MILDIF53 617-618
  byte   STNDIF31 619-620
  byte   STNDIF53 621-622
  byte   BENDIF31 623-624
  byte   BENDIF53 625-626
  byte   RCHDIF31 627-628
  byte   RCHDIF53 629-630
  byte   FNGRDF31 631-632
  byte   FNGRDF53 633-634
  byte   WLK3MO31 635-636
  byte   WLK3MO53 637-638
  byte   ACTLIM31 639-640
  byte   ACTLIM53 641-642
  byte   WRKLIM31 643-644
  byte   WRKLIM53 645-646
  byte   HSELIM31 647-648
  byte   HSELIM53 649-650
  byte   SCHLIM31 651-652
  byte   SCHLIM53 653-654
  byte   UNABLE31 655-656
  byte   UNABLE53 657-658
  byte   SOCLIM31 659-660
  byte   SOCLIM53 661-662
  byte   COGLIM31 663-664
  byte   COGLIM53 665-666
  byte   WRGLAS42 667-668
  byte   SEEDIF42 669-670
  byte   BLIND42 671-672
  byte   READNW42 673-674
  byte   RECPEP42 675-676
  byte   VISION42 677-678
  byte   HEARAD42 679-680
  byte   HEARDI42 681-682
  byte   DEAF42 683-684
  byte   HEARMO42 685-686
  byte   HEARSM42 687-688
  byte   HEARNG42 689-690
  byte   ANYLIM09 691-692
  byte   LSHLTH42 693-694
  byte   NEVILL42 695-696
  byte   SICEAS42 697-698
  byte   HLTHLF42 699-700
  byte   WRHLTH42 701-702
  byte   CHPMED42 703-704
  byte   CHPMHB42 705-706
  byte   CHPMCN42 707-708
  byte   CHSERV42 709-710
  byte   CHSRHB42 711-712
  byte   CHSRCN42 713-714
  byte   CHLIMI42 715-716
  byte   CHLIHB42 717-718
  byte   CHLICO42 719-720
  byte   CHTHER42 721-722
  byte   CHTHHB42 723-724
  byte   CHTHCO42 725-726
  byte   CHCOUN42 727-728
  byte   CHEMPB42 729-730
  byte   CSHCN42 731-732
  byte   MOMPRO42 733-734
  byte   DADPRO42 735-736
  byte   UNHAP42 737-738
  byte   SCHLBH42 739-740
  byte   HAVFUN42 741-742
  byte   ADUPRO42 743-744
  byte   NERVAF42 745-746
  byte   SIBPRO42 747-748
  byte   KIDPRO42 749-750
  byte   SPRPRO42 751-752
  byte   SCHPRO42 753-754
  byte   HOMEBH42 755-756
  byte   TRBLE42 757-758
  byte   CHILCR42 759-760
  byte   CHILWW42 761-762
  byte   CHRTCR42 763-764
  byte   CHRTWW42 765-766
  byte   CHAPPT42 767-768
  byte   CHNDCR42 769-770
  byte   CHENEC42 771-772
  byte   CHLIST42 773-774
  byte   CHEXPL42 775-776
  byte   CHRESP42 777-778
  byte   CHPRTM42 779-780
  byte   CHHECR42 781-782
  byte   CHSPEC42 783-784
  byte   CHEYRE42 785-786
  byte   MESHGT42 787-788
  byte   WHNHGT42 789-790
  byte   MESWGT42 791-792
  byte   WHNWGT42 793-794
  double CHBMIX42 795-798
  byte   MESVIS42 799-800
  byte   MESBPR42 801-802
  byte   WHNBPR42 803-804
  byte   DENTAL42 805-806
  byte   WHNDEN42 807-808
  byte   EATHLT42 809-810
  byte   WHNEAT42 811-812
  byte   PHYSCL42 813-814
  byte   WHNPHY42 815-816
  byte   SAFEST42 817-818
  byte   WHNSAF42 819-820
  byte   BOOST42 821-822
  byte   WHNBST42 823-824
  byte   LAPBLT42 825-826
  byte   WHNLAP42 827-828
  byte   HELMET42 829-830
  byte   WHNHEL42 831-832
  byte   NOSMOK42 833-834
  byte   WHNSMK42 835-836
  byte   TIMALN42 837-838
  byte   DENTCK53 839-840
  byte   BPCHEK53 841-842
  byte   BPMONT53 843-844
  byte   CHOLCK53 845-846
  byte   CHECK53 847-848
  byte   NOFAT53 849-850
  byte   EXRCIS53 851-852
  byte   FLUSHT53 853-854
  byte   ASPRIN53 855-856
  byte   NOASPR53 857-858
  byte   STOMCH53 859-860
  byte   LSTETH53 861-862
  byte   PSA53 863-864
  byte   HYSTER53 865-866
  byte   PAPSMR53 867-868
  byte   BRSTEX53 869-870
  byte   MAMOGR53 871-872
  byte   BSTST53 873-874
  byte   BSTSRE53 875-876
  byte   CLNTST53 877-878
  byte   CLNTRE53 879-880
  byte   SGMTST53 881-882
  byte   SGMTRE53 883-884
  byte   PHYACT53 885-886
  double BMINDX53 887-891
  byte   SEATBE53 892-893
  byte   SAQELIG 894-894
  int    ADPRX42 895-897
  byte   ADILCR42 898-899
  byte   ADILWW42 900-901
  byte   ADRTCR42 902-903
  byte   ADRTWW42 904-905
  byte   ADAPPT42 906-907
  byte   ADNDCR42 908-909
  byte   ADEGMC42 910-911
  byte   ADLIST42 912-913
  byte   ADEXPL42 914-915
  byte   ADRESP42 916-917
  byte   ADPRTM42 918-919
  byte   ADHECR42 920-921
  byte   ADSMOK42 922-923
  byte   ADNSMK42 924-925
  byte   ADDRBP42 926-927
  byte   ADSPEC42 928-929
  byte   ADSPRF42 930-931
  byte   ADGENH42 932-933
  byte   ADDAYA42 934-935
  byte   ADCLIM42 936-937
  byte   ADPALS42 938-939
  byte   ADPWLM42 940-941
  byte   ADMALS42 942-943
  byte   ADMWLM42 944-945
  byte   ADPAIN42 946-947
  byte   ADCAPE42 948-949
  byte   ADNRGY42 950-951
  byte   ADDOWN42 952-953
  byte   ADSOCA42 954-955
  double PCS42 956-960
  double MCS42 961-965
  byte   SFFLAG42 966-967
  byte   ADNERV42 968-969
  byte   ADHOPE42 970-971
  byte   ADREST42 972-973
  byte   ADSAD42 974-975
  byte   ADEFRT42 976-977
  byte   ADWRTH42 978-979
  byte   K6SUM42 980-981
  byte   ADINTR42 982-983
  byte   ADDPRS42 984-985
  byte   PHQ242 986-987
  byte   ADINSA42 988-989
  byte   ADINSB42 990-991
  byte   ADRISK42 992-993
  byte   ADOVER42 994-995
  byte   ADCMPM42 996-997
  byte   ADCMPD42 998-999
  int    ADCMPY42 1000-1003
  byte   ADLANG42 1004-1005
  byte   DSDIA53 1006-1007
  byte   DSA1C53 1008-1009
  byte   DSFT1053 1010-1011
  byte   DSFT0953 1012-1013
  byte   DSFT0853 1014-1015
  byte   DSFB0853 1016-1017
  byte   DSFTNV53 1018-1019
  byte   DSEY1053 1020-1021
  byte   DSEY0953 1022-1023
  byte   DSEY0853 1024-1025
  byte   DSEB0853 1026-1027
  byte   DSEYNV53 1028-1029
  byte   DSCH1053 1030-1031
  byte   DSCH0953 1032-1033
  byte   DSCH0853 1034-1035
  byte   DSCB0853 1036-1037
  byte   DSCHNV53 1038-1039
  byte   DSFL1053 1040-1041
  byte   DSFL0953 1042-1043
  byte   DSFL0853 1044-1045
  byte   DSVB0853 1046-1047
  byte   DSFLNV53 1048-1049
  byte   DSKIDN53 1050-1051
  byte   DSEYPR53 1052-1053
  byte   DSDIET53 1054-1055
  byte   DSMED53 1056-1057
  byte   DSINSU53 1058-1059
  byte   DSCPCP53 1060-1061
  byte   DSCNPC53 1062-1063
  byte   DSCPHN53 1064-1065
  byte   DSCINT53 1066-1067
  byte   DSCGRP53 1068-1069
  byte   DSCONF53 1070-1071
  byte   DSPRX53 1072-1073
  int    DDNWRK31 1074-1076
  int    DDNWRK42 1077-1079
  int    DDNWRK53 1080-1082
  byte   WKINBD31 1083-1084
  int    WKINBD42 1085-1087
  int    WKINBD53 1088-1090
  int    DDNSCL31 1091-1093
  int    DDNSCL42 1094-1096
  byte   DDNSCL53 1097-1098
  byte   SCLNBD31 1099-1100
  int    SCLNBD42 1101-1103
  byte   SCLNBD53 1104-1105
  int    DDBDYS31 1106-1108
  int    DDBDYS42 1109-1111
  int    DDBDYS53 1112-1114
  byte   OTHDYS31 1115-1116
  byte   OTHDYS42 1117-1118
  byte   OTHDYS53 1119-1120
  byte   OTHNDD31 1121-1122
  int    OTHNDD42 1123-1125
  byte   OTHNDD53 1126-1127
  byte   ACCELI42 1128-1129
  byte   LANGHM42 1130-1131
  byte   ENGCMF42 1132-1133
  byte   ENGSPK42 1134-1135
  byte   USBORN42 1136-1137
  byte   USLIVE42 1138-1139
  byte   HAVEUS42 1140-1141
  byte   YNOUSC42 1142-1143
  byte   NOREAS42 1144-1145
  byte   SELDSI42 1146-1147
  byte   NEWARE42 1148-1149
  byte   DKWHRU42 1150-1151
  byte   USCNOT42 1152-1153
  byte   PERSLA42 1154-1155
  byte   DIFFPL42 1156-1157
  byte   INSRPL42 1158-1159
  byte   MYSELF42 1160-1161
  byte   CARECO42 1162-1163
  byte   NOHINS42 1164-1165
  byte   OTHINS42 1166-1167
  byte   JOBRSN42 1168-1169
  byte   NEWDOC42 1170-1171
  byte   DOCELS42 1172-1173
  byte   NOLIKE42 1174-1175
  byte   KNOWDR42 1176-1177
  byte   ONJOB42 1178-1179
  byte   NOGODR42 1180-1181
  byte   TRANS42 1182-1183
  byte   CLINIC42 1184-1185
  byte   OTHREA42 1186-1187
  byte   PROVTY42 1188-1189
  byte   PLCTYP42 1190-1191
  byte   GOTOUS42 1192-1193
  byte   TMTKUS42 1194-1195
  byte   DFTOUS42 1196-1197
  byte   TYPEPE42 1198-1199
  byte   LOCATN42 1200-1201
  byte   HSPLAP42 1202-1203
  byte   WHITPR42 1204-1205
  byte   BLCKPR42 1206-1207
  byte   ASIANP42 1208-1209
  byte   NATAMP42 1210-1211
  byte   PACISP42 1212-1213
  byte   OTHRCP42 1214-1215
  byte   GENDRP42 1216-1217
  byte   MINORP42 1218-1219
  byte   PREVEN42 1220-1221
  byte   REFFRL42 1222-1223
  byte   ONGONG42 1224-1225
  byte   PHNREG42 1226-1227
  byte   OFFHOU42 1228-1229
  byte   AFTHOU42 1230-1231
  byte   TREATM42 1232-1233
  byte   RESPCT42 1234-1235
  byte   DECIDE42 1236-1237
  byte   EXPLOP42 1238-1239
  byte   LANGPR42 1240-1241
  byte   MDUNAB42 1242-1243
  byte   MDUNRS42 1244-1245
  byte   MDUNPR42 1246-1247
  byte   MDDLAY42 1248-1249
  byte   MDDLRS42 1250-1251
  byte   MDDLPR42 1252-1253
  byte   DNUNAB42 1254-1255
  byte   DNUNRS42 1256-1257
  byte   DNUNPR42 1258-1259
  byte   DNDLAY42 1260-1261
  byte   DNDLRS42 1262-1263
  byte   DNDLPR42 1264-1265
  byte   PMUNAB42 1266-1267
  byte   PMUNRS42 1268-1269
  byte   PMUNPR42 1270-1271
  byte   PMDLAY42 1272-1273
  byte   PMDLRS42 1274-1275
  byte   PMDLPR42 1276-1277
  byte   EMPST31 1278-1279
  byte   EMPST42 1280-1281
  byte   EMPST53 1282-1283
  byte   RNDFLG31 1284-1285
  byte   MORJOB31 1286-1287
  byte   MORJOB42 1288-1289
  byte   MORJOB53 1290-1291
  byte   EVRWRK 1292-1293
  double HRWG31X 1294-1299
  double HRWG42X 1300-1305
  double HRWG53X 1306-1311
  byte   HRWGIM31 1312-1312
  byte   HRWGIM42 1313-1313
  byte   HRWGIM53 1314-1314
  byte   HRHOW31 1315-1316
  byte   HRHOW42 1317-1318
  byte   HRHOW53 1319-1320
  byte   DIFFWG31 1321-1322
  byte   DIFFWG42 1323-1324
  byte   DIFFWG53 1325-1326
  double NHRWG31 1327-1332
  double NHRWG42 1333-1338
  double NHRWG53 1339-1344
  int    HOUR31 1345-1347
  int    HOUR42 1348-1350
  byte   HOUR53 1351-1352
  byte   TEMPJB31 1353-1354
  byte   TEMPJB42 1355-1356
  byte   TEMPJB53 1357-1358
  byte   SSNLJB31 1359-1360
  byte   SSNLJB42 1361-1362
  byte   SSNLJB53 1363-1364
  byte   SELFCM31 1365-1366
  byte   SELFCM42 1367-1368
  byte   SELFCM53 1369-1370
  byte   DISVW31X 1371-1372
  byte   DISVW42X 1373-1374
  byte   DISVW53X 1375-1376
  byte   CHOIC31 1377-1378
  byte   CHOIC42 1379-1380
  byte   CHOIC53 1381-1382
  byte   INDCAT31 1383-1384
  byte   INDCAT42 1385-1386
  byte   INDCAT53 1387-1388
  int    NUMEMP31 1389-1391
  int    NUMEMP42 1392-1394
  int    NUMEMP53 1395-1397
  byte   MORE31 1398-1399
  byte   MORE42 1400-1401
  byte   MORE53 1402-1403
  byte   UNION31 1404-1405
  byte   UNION42 1406-1407
  byte   UNION53 1408-1409
  byte   NWK31 1410-1411
  byte   NWK42 1412-1413
  byte   NWK53 1414-1415
  byte   CHGJ3142 1416-1417
  byte   CHGJ4253 1418-1419
  byte   YCHJ3142 1420-1421
  byte   YCHJ4253 1422-1423
  byte   STJBMM31 1424-1425
  byte   STJBDD31 1426-1427
  int    STJBYY31 1428-1431
  byte   STJBMM42 1432-1433
  byte   STJBDD42 1434-1435
  int    STJBYY42 1436-1439
  byte   STJBMM53 1440-1441
  byte   STJBDD53 1442-1443
  int    STJBYY53 1444-1447
  byte   EVRETIRE 1448-1449
  byte   OCCCAT31 1450-1451
  byte   OCCCAT42 1452-1453
  byte   OCCCAT53 1454-1455
  byte   PAYVAC31 1456-1457
  byte   PAYVAC42 1458-1459
  byte   PAYVAC53 1460-1461
  byte   SICPAY31 1462-1463
  byte   SICPAY42 1464-1465
  byte   SICPAY53 1466-1467
  byte   PAYDR31 1468-1469
  byte   PAYDR42 1470-1471
  byte   PAYDR53 1472-1473
  byte   RETPLN31 1474-1475
  byte   RETPLN42 1476-1477
  byte   RETPLN53 1478-1479
  byte   BSNTY31 1480-1481
  byte   BSNTY42 1482-1483
  byte   BSNTY53 1484-1485
  byte   JOBORG31 1486-1487
  byte   JOBORG42 1488-1489
  byte   JOBORG53 1490-1491
  byte   HELD31X 1492-1493
  byte   HELD42X 1494-1495
  byte   HELD53X 1496-1497
  byte   OFFER31X 1498-1499
  byte   OFFER42X 1500-1501
  byte   OFFER53X 1502-1503
  byte   OFREMP31 1504-1505
  byte   OFREMP42 1506-1507
  byte   OFREMP53 1508-1509
  byte   YNOINS31 1510-1511
  byte   YNOINS42 1512-1513
  byte   YNOINS53 1514-1515
  byte   SSIDIS09 1516-1517
  byte   AFDC09 1518-1519
  byte   FILEDR09 1520-1521
  byte   WILFIL09 1522-1523
  byte   FLSTAT09 1524-1525
  byte   FILER09 1526-1527
  byte   JTINRU09 1528-1529
  int    JNTPID09 1530-1532
  byte   CLMDEP09 1533-1534
  byte   DEPDNT09 1535-1536
  byte   DPINRU09 1537-1538
  byte   DPOTSD09 1539-1540
  byte   TAXFRM09 1541-1542
  byte   DEDUCT09 1543-1544
  long   TOTDED09 1545-1550
  byte   CLMHIP09 1551-1552
  byte   EICRDT09 1553-1554
  byte   FOODST09 1555-1556
  byte   FOODMN09 1557-1558
  int    FOODVL09 1559-1562
  long   TTLP09X 1563-1568
  long   FAMINC09 1569-1574
  byte   POVCAT09 1575-1575
  double POVLEV09 1576-1586
  long   WAGEP09X 1587-1592
  byte   WAGIMP09 1593-1593
  long   BUSNP09X 1594-1599
  byte   BUSIMP09 1600-1600
  long   UNEMP09X 1601-1605
  byte   UNEIMP09 1606-1606
  long   WCMPP09X 1607-1611
  byte   WCPIMP09 1612-1612
  long   INTRP09X 1613-1618
  byte   INTIMP09 1619-1619
  long   DIVDP09X 1620-1624
  byte   DIVIMP09 1625-1625
  long   SALEP09X 1626-1632
  byte   SALIMP09 1633-1633
  long   PENSP09X 1634-1638
  byte   PENIMP09 1639-1639
  long   SSECP09X 1640-1644
  byte   SSCIMP09 1645-1645
  long   TRSTP09X 1646-1651
  byte   TRTIMP09 1652-1652
  long   VETSP09X 1653-1657
  byte   VETIMP09 1658-1658
  long   IRASP09X 1659-1664
  byte   IRAIMP09 1665-1665
  long   REFDP09X 1666-1670
  byte   REFIMP09 1671-1671
  long   ALIMP09X 1672-1676
  byte   ALIIMP09 1677-1677
  long   CHLDP09X 1678-1682
  byte   CHLIMP09 1683-1683
  long   CASHP09X 1684-1689
  byte   CSHIMP09 1690-1690
  long   SSIP09X 1691-1695
  byte   SSIIMP09 1696-1696
  long   PUBP09X 1697-1701
  byte   PUBIMP09 1702-1702
  long   OTHRP09X 1703-1707
  byte   OTHIMP09 1708-1708
  byte   TRIJA09X 1709-1710
  byte   TRIFE09X 1711-1712
  byte   TRIMA09X 1713-1714
  byte   TRIAP09X 1715-1716
  byte   TRIMY09X 1717-1718
  byte   TRIJU09X 1719-1720
  byte   TRIJL09X 1721-1722
  byte   TRIAU09X 1723-1724
  byte   TRISE09X 1725-1726
  byte   TRIOC09X 1727-1728
  byte   TRINO09X 1729-1730
  byte   TRIDE09X 1731-1732
  byte   MCRJA09 1733-1734
  byte   MCRFE09 1735-1736
  byte   MCRMA09 1737-1738
  byte   MCRAP09 1739-1740
  byte   MCRMY09 1741-1742
  byte   MCRJU09 1743-1744
  byte   MCRJL09 1745-1746
  byte   MCRAU09 1747-1748
  byte   MCRSE09 1749-1750
  byte   MCROC09 1751-1752
  byte   MCRNO09 1753-1754
  byte   MCRDE09 1755-1756
  byte   MCRJA09X 1757-1758
  byte   MCRFE09X 1759-1760
  byte   MCRMA09X 1761-1762
  byte   MCRAP09X 1763-1764
  byte   MCRMY09X 1765-1766
  byte   MCRJU09X 1767-1768
  byte   MCRJL09X 1769-1770
  byte   MCRAU09X 1771-1772
  byte   MCRSE09X 1773-1774
  byte   MCROC09X 1775-1776
  byte   MCRNO09X 1777-1778
  byte   MCRDE09X 1779-1780
  byte   MCDJA09 1781-1782
  byte   MCDFE09 1783-1784
  byte   MCDMA09 1785-1786
  byte   MCDAP09 1787-1788
  byte   MCDMY09 1789-1790
  byte   MCDJU09 1791-1792
  byte   MCDJL09 1793-1794
  byte   MCDAU09 1795-1796
  byte   MCDSE09 1797-1798
  byte   MCDOC09 1799-1800
  byte   MCDNO09 1801-1802
  byte   MCDDE09 1803-1804
  byte   MCDJA09X 1805-1806
  byte   MCDFE09X 1807-1808
  byte   MCDMA09X 1809-1810
  byte   MCDAP09X 1811-1812
  byte   MCDMY09X 1813-1814
  byte   MCDJU09X 1815-1816
  byte   MCDJL09X 1817-1818
  byte   MCDAU09X 1819-1820
  byte   MCDSE09X 1821-1822
  byte   MCDOC09X 1823-1824
  byte   MCDNO09X 1825-1826
  byte   MCDDE09X 1827-1828
  byte   OPAJA09 1829-1830
  byte   OPAFE09 1831-1832
  byte   OPAMA09 1833-1834
  byte   OPAAP09 1835-1836
  byte   OPAMY09 1837-1838
  byte   OPAJU09 1839-1840
  byte   OPAJL09 1841-1842
  byte   OPAAU09 1843-1844
  byte   OPASE09 1845-1846
  byte   OPAOC09 1847-1848
  byte   OPANO09 1849-1850
  byte   OPADE09 1851-1852
  byte   OPBJA09 1853-1854
  byte   OPBFE09 1855-1856
  byte   OPBMA09 1857-1858
  byte   OPBAP09 1859-1860
  byte   OPBMY09 1861-1862
  byte   OPBJU09 1863-1864
  byte   OPBJL09 1865-1866
  byte   OPBAU09 1867-1868
  byte   OPBSE09 1869-1870
  byte   OPBOC09 1871-1872
  byte   OPBNO09 1873-1874
  byte   OPBDE09 1875-1876
  byte   STAJA09 1877-1878
  byte   STAFE09 1879-1880
  byte   STAMA09 1881-1882
  byte   STAAP09 1883-1884
  byte   STAMY09 1885-1886
  byte   STAJU09 1887-1888
  byte   STAJL09 1889-1890
  byte   STAAU09 1891-1892
  byte   STASE09 1893-1894
  byte   STAOC09 1895-1896
  byte   STANO09 1897-1898
  byte   STADE09 1899-1900
  byte   PUBJA09X 1901-1902
  byte   PUBFE09X 1903-1904
  byte   PUBMA09X 1905-1906
  byte   PUBAP09X 1907-1908
  byte   PUBMY09X 1909-1910
  byte   PUBJU09X 1911-1912
  byte   PUBJL09X 1913-1914
  byte   PUBAU09X 1915-1916
  byte   PUBSE09X 1917-1918
  byte   PUBOC09X 1919-1920
  byte   PUBNO09X 1921-1922
  byte   PUBDE09X 1923-1924
  byte   PEGJA09 1925-1926
  byte   PEGFE09 1927-1928
  byte   PEGMA09 1929-1930
  byte   PEGAP09 1931-1932
  byte   PEGMY09 1933-1934
  byte   PEGJU09 1935-1936
  byte   PEGJL09 1937-1938
  byte   PEGAU09 1939-1940
  byte   PEGSE09 1941-1942
  byte   PEGOC09 1943-1944
  byte   PEGNO09 1945-1946
  byte   PEGDE09 1947-1948
  byte   PDKJA09 1949-1950
  byte   PDKFE09 1951-1952
  byte   PDKMA09 1953-1954
  byte   PDKAP09 1955-1956
  byte   PDKMY09 1957-1958
  byte   PDKJU09 1959-1960
  byte   PDKJL09 1961-1962
  byte   PDKAU09 1963-1964
  byte   PDKSE09 1965-1966
  byte   PDKOC09 1967-1968
  byte   PDKNO09 1969-1970
  byte   PDKDE09 1971-1972
  byte   PNGJA09 1973-1974
  byte   PNGFE09 1975-1976
  byte   PNGMA09 1977-1978
  byte   PNGAP09 1979-1980
  byte   PNGMY09 1981-1982
  byte   PNGJU09 1983-1984
  byte   PNGJL09 1985-1986
  byte   PNGAU09 1987-1988
  byte   PNGSE09 1989-1990
  byte   PNGOC09 1991-1992
  byte   PNGNO09 1993-1994
  byte   PNGDE09 1995-1996
  byte   POGJA09 1997-1998
  byte   POGFE09 1999-2000
  byte   POGMA09 2001-2002
  byte   POGAP09 2003-2004
  byte   POGMY09 2005-2006
  byte   POGJU09 2007-2008
  byte   POGJL09 2009-2010
  byte   POGAU09 2011-2012
  byte   POGSE09 2013-2014
  byte   POGOC09 2015-2016
  byte   POGNO09 2017-2018
  byte   POGDE09 2019-2020
  byte   PRSJA09 2021-2022
  byte   PRSFE09 2023-2024
  byte   PRSMA09 2025-2026
  byte   PRSAP09 2027-2028
  byte   PRSMY09 2029-2030
  byte   PRSJU09 2031-2032
  byte   PRSJL09 2033-2034
  byte   PRSAU09 2035-2036
  byte   PRSSE09 2037-2038
  byte   PRSOC09 2039-2040
  byte   PRSNO09 2041-2042
  byte   PRSDE09 2043-2044
  byte   POUJA09 2045-2046
  byte   POUFE09 2047-2048
  byte   POUMA09 2049-2050
  byte   POUAP09 2051-2052
  byte   POUMY09 2053-2054
  byte   POUJU09 2055-2056
  byte   POUJL09 2057-2058
  byte   POUAU09 2059-2060
  byte   POUSE09 2061-2062
  byte   POUOC09 2063-2064
  byte   POUNO09 2065-2066
  byte   POUDE09 2067-2068
  byte   PRIJA09 2069-2070
  byte   PRIFE09 2071-2072
  byte   PRIMA09 2073-2074
  byte   PRIAP09 2075-2076
  byte   PRIMY09 2077-2078
  byte   PRIJU09 2079-2080
  byte   PRIJL09 2081-2082
  byte   PRIAU09 2083-2084
  byte   PRISE09 2085-2086
  byte   PRIOC09 2087-2088
  byte   PRINO09 2089-2090
  byte   PRIDE09 2091-2092
  byte   HPEJA09 2093-2094
  byte   HPEFE09 2095-2096
  byte   HPEMA09 2097-2098
  byte   HPEAP09 2099-2100
  byte   HPEMY09 2101-2102
  byte   HPEJU09 2103-2104
  byte   HPEJL09 2105-2106
  byte   HPEAU09 2107-2108
  byte   HPESE09 2109-2110
  byte   HPEOC09 2111-2112
  byte   HPENO09 2113-2114
  byte   HPEDE09 2115-2116
  byte   HPDJA09 2117-2118
  byte   HPDFE09 2119-2120
  byte   HPDMA09 2121-2122
  byte   HPDAP09 2123-2124
  byte   HPDMY09 2125-2126
  byte   HPDJU09 2127-2128
  byte   HPDJL09 2129-2130
  byte   HPDAU09 2131-2132
  byte   HPDSE09 2133-2134
  byte   HPDOC09 2135-2136
  byte   HPDNO09 2137-2138
  byte   HPDDE09 2139-2140
  byte   HPNJA09 2141-2142
  byte   HPNFE09 2143-2144
  byte   HPNMA09 2145-2146
  byte   HPNAP09 2147-2148
  byte   HPNMY09 2149-2150
  byte   HPNJU09 2151-2152
  byte   HPNJL09 2153-2154
  byte   HPNAU09 2155-2156
  byte   HPNSE09 2157-2158
  byte   HPNOC09 2159-2160
  byte   HPNNO09 2161-2162
  byte   HPNDE09 2163-2164
  byte   HPOJA09 2165-2166
  byte   HPOFE09 2167-2168
  byte   HPOMA09 2169-2170
  byte   HPOAP09 2171-2172
  byte   HPOMY09 2173-2174
  byte   HPOJU09 2175-2176
  byte   HPOJL09 2177-2178
  byte   HPOAU09 2179-2180
  byte   HPOSE09 2181-2182
  byte   HPOOC09 2183-2184
  byte   HPONO09 2185-2186
  byte   HPODE09 2187-2188
  byte   HPSJA09 2189-2190
  byte   HPSFE09 2191-2192
  byte   HPSMA09 2193-2194
  byte   HPSAP09 2195-2196
  byte   HPSMY09 2197-2198
  byte   HPSJU09 2199-2200
  byte   HPSJL09 2201-2202
  byte   HPSAU09 2203-2204
  byte   HPSSE09 2205-2206
  byte   HPSOC09 2207-2208
  byte   HPSNO09 2209-2210
  byte   HPSDE09 2211-2212
  byte   HPRJA09 2213-2214
  byte   HPRFE09 2215-2216
  byte   HPRMA09 2217-2218
  byte   HPRAP09 2219-2220
  byte   HPRMY09 2221-2222
  byte   HPRJU09 2223-2224
  byte   HPRJL09 2225-2226
  byte   HPRAU09 2227-2228
  byte   HPRSE09 2229-2230
  byte   HPROC09 2231-2232
  byte   HPRNO09 2233-2234
  byte   HPRDE09 2235-2236
  byte   INSJA09X 2237-2238
  byte   INSFE09X 2239-2240
  byte   INSMA09X 2241-2242
  byte   INSAP09X 2243-2244
  byte   INSMY09X 2245-2246
  byte   INSJU09X 2247-2248
  byte   INSJL09X 2249-2250
  byte   INSAU09X 2251-2252
  byte   INSSE09X 2253-2254
  byte   INSOC09X 2255-2256
  byte   INSNO09X 2257-2258
  byte   INSDE09X 2259-2260
  byte   PRVEV09 2261-2261
  byte   TRIEV09 2262-2262
  byte   MCREV09 2263-2263
  byte   MCDEV09 2264-2264
  byte   OPAEV09 2265-2265
  byte   OPBEV09 2266-2266
  byte   UNINS09 2267-2267
  byte   INSCOV09 2268-2268
  byte   TRIST31X 2269-2270
  byte   TRIST42X 2271-2272
  byte   TRIST09X 2273-2274
  byte   TRIPR31X 2275-2276
  byte   TRIPR42X 2277-2278
  byte   TRIPR09X 2279-2280
  byte   TRIEX31X 2281-2282
  byte   TRIEX42X 2283-2284
  byte   TRIEX09X 2285-2286
  byte   TRILI31X 2287-2288
  byte   TRILI42X 2289-2290
  byte   TRILI09X 2291-2292
  byte   TRICH31X 2293-2294
  byte   TRICH42X 2295-2296
  byte   TRICH09X 2297-2298
  byte   MCRPD31 2299-2300
  byte   MCRPD42 2301-2302
  byte   MCRPD09 2303-2304
  byte   MCRPD31X 2305-2306
  byte   MCRPD42X 2307-2308
  byte   MCRPD09X 2309-2310
  byte   MCRPB31 2311-2312
  byte   MCRPB42 2313-2314
  byte   MCRPB09 2315-2316
  byte   MCRPHO31 2317-2318
  byte   MCRPHO42 2319-2320
  byte   MCRPHO09 2321-2322
  byte   MCDHMO31 2323-2324
  byte   MCDHMO42 2325-2326
  byte   MCDHMO09 2327-2328
  byte   MCDMC31 2329-2330
  byte   MCDMC42 2331-2332
  byte   MCDMC09 2333-2334
  byte   PRVHMO31 2335-2336
  byte   PRVHMO42 2337-2338
  byte   PRVHMO09 2339-2340
  byte   PRVMNC31 2341-2342
  byte   PRVMNC42 2343-2344
  byte   PRVMNC09 2345-2346
  byte   PRVDRL31 2347-2348
  byte   PRVDRL42 2349-2350
  byte   PRVDRL09 2351-2352
  byte   PHMONP31 2353-2354
  byte   PHMONP42 2355-2356
  byte   PHMONP09 2357-2358
  byte   PMNCNP31 2359-2360
  byte   PMNCNP42 2361-2362
  byte   PMNCNP09 2363-2364
  byte   PRDRNP31 2365-2366
  byte   PRDRNP42 2367-2368
  byte   PRDRNP09 2369-2370
  byte   PREVCOVR 2371-2372
  byte   COVRMM 2373-2374
  int    COVRYY 2375-2378
  byte   WASESTB 2379-2380
  byte   WASMCARE 2381-2382
  byte   WASMCAID 2383-2384
  byte   WASCHAMP 2385-2386
  byte   WASVA 2387-2388
  byte   WASPRIV 2389-2390
  byte   WASOTGOV 2391-2392
  byte   WASAFDC 2393-2394
  byte   WASSSI 2395-2396
  byte   WASSTAT1 2397-2398
  byte   WASSTAT2 2399-2400
  byte   WASSTAT3 2401-2402
  byte   WASSTAT4 2403-2404
  byte   WASOTHER 2405-2406
  byte   NOINSBEF 2407-2408
  byte   NOINSTM 2409-2410
  byte   NOINUNIT 2411-2412
  byte   MORECOVR 2413-2414
  byte   INSENDMM 2415-2416
  int    INSENDYY 2417-2420
  byte   TRICR31X 2421-2422
  byte   TRICR42X 2423-2424
  byte   TRICR53X 2425-2426
  byte   TRICR09X 2427-2428
  byte   TRIAT31X 2429-2430
  byte   TRIAT42X 2431-2432
  byte   TRIAT53X 2433-2434
  byte   TRIAT09X 2435-2436
  byte   MCAID31 2437-2438
  byte   MCAID42 2439-2440
  byte   MCAID53 2441-2442
  byte   MCAID09 2443-2444
  byte   MCAID31X 2445-2446
  byte   MCAID42X 2447-2448
  byte   MCAID53X 2449-2450
  byte   MCAID09X 2451-2452
  byte   MCARE31 2453-2454
  byte   MCARE42 2455-2456
  byte   MCARE53 2457-2458
  byte   MCARE09 2459-2460
  byte   MCARE31X 2461-2462
  byte   MCARE42X 2463-2464
  byte   MCARE53X 2465-2466
  byte   MCARE09X 2467-2468
  byte   MCDAT31X 2469-2470
  byte   MCDAT42X 2471-2472
  byte   MCDAT53X 2473-2474
  byte   MCDAT09X 2475-2476
  byte   OTPAAT31 2477-2478
  byte   OTPAAT42 2479-2480
  byte   OTPAAT53 2481-2482
  byte   OTPAAT09 2483-2484
  byte   OTPBAT31 2485-2486
  byte   OTPBAT42 2487-2488
  byte   OTPBAT53 2489-2490
  byte   OTPBAT09 2491-2492
  byte   OTPUBA31 2493-2494
  byte   OTPUBA42 2495-2496
  byte   OTPUBA53 2497-2498
  byte   OTPUBA09 2499-2500
  byte   OTPUBB31 2501-2502
  byte   OTPUBB42 2503-2504
  byte   OTPUBB53 2505-2506
  byte   OTPUBB09 2507-2508
  byte   PRIDK31 2509-2510
  byte   PRIDK42 2511-2512
  byte   PRIDK53 2513-2514
  byte   PRIDK09 2515-2516
  byte   PRIEU31 2517-2518
  byte   PRIEU42 2519-2520
  byte   PRIEU53 2521-2522
  byte   PRIEU09 2523-2524
  byte   PRING31 2525-2526
  byte   PRING42 2527-2528
  byte   PRING53 2529-2530
  byte   PRING09 2531-2532
  byte   PRIOG31 2533-2534
  byte   PRIOG42 2535-2536
  byte   PRIOG53 2537-2538
  byte   PRIOG09 2539-2540
  byte   PRIS31 2541-2542
  byte   PRIS42 2543-2544
  byte   PRIS53 2545-2546
  byte   PRIS09 2547-2548
  byte   PRIV31 2549-2550
  byte   PRIV42 2551-2552
  byte   PRIV53 2553-2554
  byte   PRIV09 2555-2556
  byte   PRIVAT31 2557-2558
  byte   PRIVAT42 2559-2560
  byte   PRIVAT53 2561-2562
  byte   PRIVAT09 2563-2564
  byte   PROUT31 2565-2566
  byte   PROUT42 2567-2568
  byte   PROUT53 2569-2570
  byte   PROUT09 2571-2572
  byte   PUB31X 2573-2574
  byte   PUB42X 2575-2576
  byte   PUB53X 2577-2578
  byte   PUB09X 2579-2580
  byte   PUBAT31X 2581-2582
  byte   PUBAT42X 2583-2584
  byte   PUBAT53X 2585-2586
  byte   PUBAT09X 2587-2588
  byte   INS31X 2589-2590
  byte   INS42X 2591-2592
  byte   INS53X 2593-2594
  byte   INS09X 2595-2596
  byte   INSAT31X 2597-2598
  byte   INSAT42X 2599-2600
  byte   INSAT53X 2601-2602
  byte   INSAT09X 2603-2604
  byte   STAPR31 2605-2606
  byte   STAPR42 2607-2608
  byte   STAPR53 2609-2610
  byte   STAPR09 2611-2612
  byte   STPRAT31 2613-2614
  byte   STPRAT42 2615-2616
  byte   STPRAT53 2617-2618
  byte   STPRAT09 2619-2620
  byte   EVRUNINS 2621-2621
  byte   EVRUNAT 2622-2622
  byte   DENTIN31 2623-2624
  byte   DENTIN42 2625-2626
  byte   DENTIN53 2627-2628
  byte   DNTINS31 2629-2630
  byte   DNTINS09 2631-2632
  byte   PMEDIN31 2633-2634
  byte   PMEDIN42 2635-2636
  byte   PMEDIN53 2637-2638
  byte   PMDINS31 2639-2640
  byte   PMDINS09 2641-2642
  byte   PMEDUP31 2643-2644
  byte   PMEDUP42 2645-2646
  byte   PMEDUP53 2647-2648
  byte   PMEDPY31 2649-2650
  byte   PMEDPY42 2651-2652
  byte   PMEDPY53 2653-2654
  double PMEDPP31 2655-2661
  double PMEDPP42 2662-2668
  double PMEDPP53 2669-2675
  byte   GDCPBM42 2676-2677
  byte   APRTRM42 2678-2679
  byte   APRDLM42 2680-2681
  byte   LKINFM42 2682-2683
  byte   PBINFM42 2684-2685
  byte   CSTSVM42 2686-2687
  byte   PBSVCM42 2688-2689
  byte   PPRWKM42 2690-2691
  byte   PBPWKM42 2692-2693
  byte   RTPLNM42 2694-2695
  byte   GDCPBT42 2696-2697
  byte   APRTRT42 2698-2699
  byte   APRDLT42 2700-2701
  byte   LKINFT42 2702-2703
  byte   PBINFT42 2704-2705
  byte   CSTSVT42 2706-2707
  byte   PBSVCT42 2708-2709
  byte   PPRWKT42 2710-2711
  byte   PBPWKT42 2712-2713
  byte   RTPLNT42 2714-2715
  long   TOTTCH09 2716-2722
  long   TOTEXP09 2723-2728
  long   TOTSLF09 2729-2734
  long   TOTMCR09 2735-2740
  long   TOTMCD09 2741-2746
  long   TOTPRV09 2747-2752
  long   TOTVA09 2753-2757
  long   TOTTRI09 2758-2762
  long   TOTOFD09 2763-2767
  long   TOTSTL09 2768-2773
  long   TOTWCP09 2774-2778
  long   TOTOPR09 2779-2784
  long   TOTOPU09 2785-2790
  long   TOTOSR09 2791-2796
  int    OBTOTV09 2797-2799
  long   OBVTCH09 2800-2805
  long   OBVEXP09 2806-2811
  long   OBVSLF09 2812-2816
  long   OBVMCR09 2817-2822
  long   OBVMCD09 2823-2827
  long   OBVPRV09 2828-2832
  long   OBVVA09 2833-2837
  long   OBVTRI09 2838-2842
  int    OBVOFD09 2843-2846
  long   OBVSTL09 2847-2851
  long   OBVWCP09 2852-2856
  long   OBVOPR09 2857-2861
  long   OBVOPU09 2862-2866
  long   OBVOSR09 2867-2871
  int    OBDRV09 2872-2874
  long   OBDTCH09 2875-2880
  long   OBDEXP09 2881-2886
  long   OBDSLF09 2887-2891
  long   OBDMCR09 2892-2896
  long   OBDMCD09 2897-2901
  long   OBDPRV09 2902-2906
  long   OBDVA09 2907-2911
  long   OBDTRI09 2912-2916
  int    OBDOFD09 2917-2920
  int    OBDSTL09 2921-2924
  long   OBDWCP09 2925-2929
  long   OBDOPR09 2930-2934
  int    OBDOPU09 2935-2938
  long   OBDOSR09 2939-2943
  int    OBOTHV09 2944-2946
  long   OBOTCH09 2947-2952
  long   OBOEXP09 2953-2958
  long   OBOSLF09 2959-2963
  long   OBOMCR09 2964-2969
  long   OBOMCD09 2970-2974
  long   OBOPRV09 2975-2979
  int    OBOVA09 2980-2983
  long   OBOTRI09 2984-2988
  int    OBOOFD09 2989-2992
  long   OBOSTL09 2993-2997
  long   OBOWCP09 2998-3002
  long   OBOOPR09 3003-3007
  long   OBOOPU09 3008-3012
  long   OBOOSR09 3013-3017
  int    OBCHIR09 3018-3020
  long   OBCTCH09 3021-3025
  long   OBCEXP09 3026-3030
  long   OBCSLF09 3031-3035
  int    OBCMCR09 3036-3039
  int    OBCMCD09 3040-3043
  int    OBCPRV09 3044-3047
  int    OBCVA09 3048-3051
  int    OBCTRI09 3052-3055
  byte   OBCOFD09 3056-3056
  int    OBCSTL09 3057-3059
  int    OBCWCP09 3060-3063
  int    OBCOPR09 3064-3067
  int    OBCOPU09 3068-3070
  long   OBCOSR09 3071-3075
  int    OBNURS09 3076-3078
  long   OBNTCH09 3079-3084
  long   OBNEXP09 3085-3089
  int    OBNSLF09 3090-3093
  long   OBNMCR09 3094-3098
  long   OBNMCD09 3099-3103
  long   OBNPRV09 3104-3108
  int    OBNVA09 3109-3112
  int    OBNTRI09 3113-3116
  int    OBNOFD09 3117-3120
  int    OBNSTL09 3121-3124
  int    OBNWCP09 3125-3128
  int    OBNOPR09 3129-3132
  int    OBNOPU09 3133-3136
  long   OBNOSR09 3137-3141
  byte   OBOPTO09 3142-3142
  int    OBETCH09 3143-3146
  int    OBEEXP09 3147-3150
  int    OBESLF09 3151-3154
  int    OBEMCR09 3155-3158
  int    OBEMCD09 3159-3162
  int    OBEPRV09 3163-3166
  int    OBEVA09 3167-3169
  int    OBETRI09 3170-3172
  int    OBEOFD09 3173-3175
  int    OBESTL09 3176-3178
  int    OBEWCP09 3179-3181
  int    OBEOPR09 3182-3184
  byte   OBEOPU09 3185-3186
  int    OBEOSR09 3187-3190
  byte   OBASST09 3191-3192
  long   OBATCH09 3193-3197
  long   OBAEXP09 3198-3202
  int    OBASLF09 3203-3206
  int    OBAMCR09 3207-3210
  int    OBAMCD09 3211-3214
  int    OBAPRV09 3215-3218
  int    OBAVA09 3219-3222
  int    OBATRI09 3223-3225
  int    OBAOFD09 3226-3229
  int    OBASTL09 3230-3233
  int    OBAWCP09 3234-3237
  int    OBAOPR09 3238-3241
  int    OBAOPU09 3242-3244
  int    OBAOSR09 3245-3248
  int    OBTHER09 3249-3251
  long   OBTTCH09 3252-3256
  long   OBTEXP09 3257-3261
  int    OBTSLF09 3262-3265
  int    OBTMCR09 3266-3269
  long   OBTMCD09 3270-3274
  long   OBTPRV09 3275-3279
  int    OBTVA09 3280-3283
  int    OBTTRI09 3284-3287
  int    OBTOFD09 3288-3291
  int    OBTSTL09 3292-3295
  long   OBTWCP09 3296-3300
  int    OBTOPR09 3301-3304
  int    OBTOPU09 3305-3308
  int    OBTOSR09 3309-3312
  int    OPTOTV09 3313-3315
  long   OPTTCH09 3316-3321
  long   OPTEXP09 3322-3327
  long   OPTSLF09 3328-3332
  long   OPTMCR09 3333-3337
  long   OPTMCD09 3338-3342
  long   OPTPRV09 3343-3348
  long   OPTVA09 3349-3353
  int    OPTTRI09 3354-3357
  int    OPTOFD09 3358-3361
  long   OPTSTL09 3362-3366
  long   OPTWCP09 3367-3371
  long   OPTOPR09 3372-3376
  int    OPTOPU09 3377-3380
  long   OPTOSR09 3381-3385
  long   OPFTCH09 3386-3391
  long   OPFEXP09 3392-3397
  long   OPFSLF09 3398-3402
  long   OPFMCR09 3403-3407
  long   OPFMCD09 3408-3412
  long   OPFPRV09 3413-3418
  long   OPFVA09 3419-3423
  int    OPFTRI09 3424-3427
  int    OPFOFD09 3428-3431
  long   OPFSTL09 3432-3436
  long   OPFWCP09 3437-3441
  long   OPFOPR09 3442-3446
  int    OPFOPU09 3447-3450
  long   OPFOSR09 3451-3455
  long   OPDEXP09 3456-3460
  long   OPDTCH09 3461-3465
  int    OPDSLF09 3466-3469
  long   OPDMCR09 3470-3474
  int    OPDMCD09 3475-3478
  int    OPDPRV09 3479-3482
  int    OPDVA09 3483-3486
  int    OPDTRI09 3487-3490
  byte   OPDOFD09 3491-3491
  int    OPDSTL09 3492-3495
  long   OPDWCP09 3496-3500
  long   OPDOPR09 3501-3505
  int    OPDOPU09 3506-3509
  int    OPDOSR09 3510-3513
  int    OPDRV09 3514-3516
  long   OPVTCH09 3517-3522
  long   OPVEXP09 3523-3528
  long   OPVSLF09 3529-3533
  long   OPVMCR09 3534-3538
  long   OPVMCD09 3539-3543
  long   OPVPRV09 3544-3549
  long   OPVVA09 3550-3554
  int    OPVTRI09 3555-3558
  int    OPVOFD09 3559-3562
  long   OPVSTL09 3563-3567
  long   OPVWCP09 3568-3572
  long   OPVOPR09 3573-3577
  int    OPVOPU09 3578-3581
  long   OPVOSR09 3582-3586
  long   OPSEXP09 3587-3591
  long   OPSTCH09 3592-3596
  int    OPSSLF09 3597-3600
  long   OPSMCR09 3601-3605
  int    OPSMCD09 3606-3609
  int    OPSPRV09 3610-3613
  int    OPSVA09 3614-3617
  int    OPSTRI09 3618-3621
  byte   OPSOFD09 3622-3622
  int    OPSSTL09 3623-3626
  int    OPSWCP09 3627-3630
  long   OPSOPR09 3631-3635
  int    OPSOPU09 3636-3639
  int    OPSOSR09 3640-3643
  int    OPOTHV09 3644-3646
  long   OPOTCH09 3647-3652
  long   OPOEXP09 3653-3657
  int    OPOSLF09 3658-3661
  long   OPOMCR09 3662-3666
  long   OPOMCD09 3667-3671
  long   OPOPRV09 3672-3676
  int    OPOVA09 3677-3680
  int    OPOTRI09 3681-3684
  int    OPOOFD09 3685-3688
  int    OPOSTL09 3689-3692
  long   OPOWCP09 3693-3697
  long   OPOOPR09 3698-3702
  int    OPOOPU09 3703-3706
  int    OPOOSR09 3707-3710
  long   OPPEXP09 3711-3715
  long   OPPTCH09 3716-3720
  int    OPPSLF09 3721-3724
  long   OPPMCR09 3725-3729
  int    OPPMCD09 3730-3733
  int    OPPPRV09 3734-3737
  int    OPPVA09 3738-3741
  int    OPPTRI09 3742-3744
  byte   OPPOFD09 3745-3745
  int    OPPSTL09 3746-3749
  long   OPPWCP09 3750-3754
  long   OPPOPR09 3755-3759
  int    OPPOPU09 3760-3763
  int    OPPOSR09 3764-3767
  int    AMCHIR09 3768-3770
  long   AMCTCH09 3771-3775
  long   AMCEXP09 3776-3780
  long   AMCSLF09 3781-3785
  int    AMCMCR09 3786-3789
  int    AMCMCD09 3790-3793
  int    AMCPRV09 3794-3797
  int    AMCVA09 3798-3801
  int    AMCTRI09 3802-3805
  byte   AMCOFD09 3806-3806
  int    AMCSTL09 3807-3809
  int    AMCWCP09 3810-3813
  int    AMCOPR09 3814-3817
  int    AMCOPU09 3818-3820
  long   AMCOSR09 3821-3825
  int    AMNURS09 3826-3828
  long   AMNTCH09 3829-3834
  long   AMNEXP09 3835-3839
  int    AMNSLF09 3840-3843
  long   AMNMCR09 3844-3848
  long   AMNMCD09 3849-3853
  long   AMNPRV09 3854-3858
  int    AMNVA09 3859-3862
  int    AMNTRI09 3863-3866
  int    AMNOFD09 3867-3870
  int    AMNSTL09 3871-3874
  int    AMNWCP09 3875-3878
  long   AMNOPR09 3879-3883
  int    AMNOPU09 3884-3887
  long   AMNOSR09 3888-3892
  byte   AMOPTO09 3893-3893
  int    AMETCH09 3894-3897
  int    AMEEXP09 3898-3901
  int    AMESLF09 3902-3905
  int    AMEMCR09 3906-3909
  int    AMEMCD09 3910-3913
  int    AMEPRV09 3914-3917
  int    AMEVA09 3918-3920
  int    AMETRI09 3921-3923
  int    AMEOFD09 3924-3926
  int    AMESTL09 3927-3929
  int    AMEWCP09 3930-3932
  int    AMEOPR09 3933-3935
  byte   AMEOPU09 3936-3937
  int    AMEOSR09 3938-3941
  byte   AMASST09 3942-3943
  long   AMATCH09 3944-3948
  long   AMAEXP09 3949-3953
  int    AMASLF09 3954-3957
  int    AMAMCR09 3958-3961
  int    AMAMCD09 3962-3965
  long   AMAPRV09 3966-3970
  int    AMAVA09 3971-3974
  int    AMATRI09 3975-3977
  int    AMAOFD09 3978-3981
  int    AMASTL09 3982-3985
  int    AMAWCP09 3986-3989
  int    AMAOPR09 3990-3993
  int    AMAOPU09 3994-3996
  int    AMAOSR09 3997-4000
  int    AMTHER09 4001-4003
  long   AMTTCH09 4004-4009
  long   AMTEXP09 4010-4014
  int    AMTSLF09 4015-4018
  long   AMTMCR09 4019-4023
  long   AMTMCD09 4024-4028
  long   AMTPRV09 4029-4033
  int    AMTVA09 4034-4037
  int    AMTTRI09 4038-4041
  int    AMTOFD09 4042-4045
  int    AMTSTL09 4046-4049
  long   AMTWCP09 4050-4054
  int    AMTOPR09 4055-4058
  int    AMTOPU09 4059-4062
  int    AMTOSR09 4063-4066
  byte   AMTOTC09 4067-4068
  byte   AMDRC09 4069-4069
  byte   ERTOT09 4070-4071
  long   ERTTCH09 4072-4077
  long   ERTEXP09 4078-4082
  long   ERTSLF09 4083-4087
  long   ERTMCR09 4088-4092
  long   ERTMCD09 4093-4097
  long   ERTPRV09 4098-4102
  int    ERTVA09 4103-4106
  int    ERTTRI09 4107-4110
  int    ERTOFD09 4111-4114
  int    ERTSTL09 4115-4118
  int    ERTWCP09 4119-4122
  int    ERTOPR09 4123-4126
  int    ERTOPU09 4127-4130
  long   ERTOSR09 4131-4135
  long   ERFTCH09 4136-4141
  long   ERFEXP09 4142-4146
  long   ERFSLF09 4147-4151
  long   ERFMCR09 4152-4156
  long   ERFMCD09 4157-4161
  long   ERFPRV09 4162-4166
  int    ERFVA09 4167-4170
  int    ERFTRI09 4171-4174
  int    ERFOFD09 4175-4178
  int    ERFSTL09 4179-4182
  int    ERFWCP09 4183-4186
  int    ERFOPR09 4187-4190
  int    ERFOPU09 4191-4194
  long   ERFOSR09 4195-4199
  long   ERDEXP09 4200-4204
  long   ERDTCH09 4205-4209
  int    ERDSLF09 4210-4213
  int    ERDMCR09 4214-4217
  int    ERDMCD09 4218-4221
  int    ERDPRV09 4222-4225
  int    ERDVA09 4226-4229
  int    ERDTRI09 4230-4233
  byte   ERDOFD09 4234-4234
  int    ERDSTL09 4235-4238
  int    ERDWCP09 4239-4242
  int    ERDOPR09 4243-4246
  int    ERDOPU09 4247-4249
  int    ERDOSR09 4250-4253
  byte   IPZERO09 4254-4254
  long   ZIFTCH09 4255-4259
  long   ZIFEXP09 4260-4264
  int    ZIFSLF09 4265-4268
  long   ZIFMCR09 4269-4273
  long   ZIFMCD09 4274-4278
  long   ZIFPRV09 4279-4283
  int    ZIFVA09 4284-4287
  long   ZIFTRI09 4288-4292
  int    ZIFOFD09 4293-4296
  int    ZIFSTL09 4297-4300
  int    ZIFWCP09 4301-4303
  int    ZIFOPR09 4304-4307
  int    ZIFOPU09 4308-4310
  int    ZIFOSR09 4311-4314
  long   ZIDEXP09 4315-4319
  long   ZIDTCH09 4320-4324
  int    ZIDSLF09 4325-4328
  int    ZIDMCR09 4329-4332
  int    ZIDMCD09 4333-4336
  int    ZIDPRV09 4337-4340
  int    ZIDVA09 4341-4343
  int    ZIDTRI09 4344-4347
  int    ZIDOFD09 4348-4351
  int    ZIDSTL09 4352-4354
  byte   ZIDWCP09 4355-4355
  int    ZIDOPR09 4356-4358
  byte   ZIDOPU09 4359-4360
  byte   ZIDOSR09 4361-4361
  byte   IPDIS09 4362-4362
  long   IPTEXP09 4363-4368
  long   IPTTCH09 4369-4374
  long   IPTSLF09 4375-4379
  long   IPTMCR09 4380-4385
  long   IPTMCD09 4386-4391
  long   IPTPRV09 4392-4397
  long   IPTVA09 4398-4402
  long   IPTTRI09 4403-4407
  long   IPTOFD09 4408-4412
  long   IPTSTL09 4413-4418
  long   IPTWCP09 4419-4423
  long   IPTOPR09 4424-4428
  long   IPTOPU09 4429-4434
  long   IPTOSR09 4435-4440
  long   IPFEXP09 4441-4446
  long   IPFTCH09 4447-4452
  long   IPFSLF09 4453-4457
  long   IPFMCR09 4458-4463
  long   IPFMCD09 4464-4469
  long   IPFPRV09 4470-4475
  long   IPFVA09 4476-4480
  long   IPFTRI09 4481-4485
  long   IPFOFD09 4486-4490
  long   IPFSTL09 4491-4496
  long   IPFWCP09 4497-4501
  long   IPFOPR09 4502-4506
  long   IPFOPU09 4507-4512
  long   IPFOSR09 4513-4518
  long   IPDEXP09 4519-4523
  long   IPDTCH09 4524-4529
  int    IPDSLF09 4530-4533
  long   IPDMCR09 4534-4538
  long   IPDMCD09 4539-4543
  long   IPDPRV09 4544-4548
  long   IPDVA09 4549-4553
  int    IPDTRI09 4554-4557
  int    IPDOFD09 4558-4561
  int    IPDSTL09 4562-4565
  long   IPDWCP09 4566-4570
  long   IPDOPR09 4571-4575
  long   IPDOPU09 4576-4580
  long   IPDOSR09 4581-4585
  int    IPNGTD09 4586-4588
  byte   DVTOT09 4589-4590
  double DVTTCH09 4591-4598
  double DVTEXP09 4599-4606
  double DVTSLF09 4607-4614
  double DVTMCR09 4615-4621
  double DVTMCD09 4622-4629
  double DVTPRV09 4630-4637
  double DVTVA09 4638-4644
  double DVTTRI09 4645-4651
  double DVTOFD09 4652-4658
  double DVTSTL09 4659-4665
  double DVTWCP09 4666-4672
  double DVTOPR09 4673-4680
  double DVTOPU09 4681-4687
  double DVTOSR09 4688-4694
  double DVGEN09 4695-4699
  double DVGTCH09 4700-4707
  double DVGEXP09 4708-4715
  double DVGSLF09 4716-4723
  double DVGMCR09 4724-4730
  double DVGMCD09 4731-4737
  double DVGPRV09 4738-4745
  double DVGVA09 4746-4752
  double DVGTRI09 4753-4759
  double DVGOFD09 4760-4766
  double DVGSTL09 4767-4773
  double DVGWCP09 4774-4780
  double DVGOPR09 4781-4787
  double DVGOPU09 4788-4794
  double DVGOSR09 4795-4801
  double DVORTH09 4802-4806
  double DVOTCH09 4807-4814
  double DVOEXP09 4815-4822
  double DVOSLF09 4823-4830
  double DVOMCR09 4831-4834
  double DVOMCD09 4835-4842
  double DVOPRV09 4843-4850
  double DVOVA09 4851-4856
  double DVOTRI09 4857-4863
  double DVOOFD09 4864-4870
  double DVOSTL09 4871-4877
  double DVOWCP09 4878-4883
  double DVOOPR09 4884-4890
  double DVOOPU09 4891-4896
  double DVOOSR09 4897-4903
  int    HHTOTD09 4904-4906
  int    HHAGD09 4907-4909
  long   HHATCH09 4910-4915
  long   HHAEXP09 4916-4921
  long   HHASLF09 4922-4926
  long   HHAMCR09 4927-4931
  long   HHAMCD09 4932-4937
  long   HHAPRV09 4938-4942
  long   HHAVA09 4943-4947
  int    HHATRI09 4948-4951
  byte   HHAOFD09 4952-4952
  long   HHASTL09 4953-4957
  int    HHAWCP09 4958-4961
  long   HHAOPR09 4962-4966
  int    HHAOPU09 4967-4970
  long   HHAOSR09 4971-4975
  int    HHINDD09 4976-4978
  long   HHNTCH09 4979-4983
  long   HHNEXP09 4984-4988
  long   HHNSLF09 4989-4993
  long   HHNMCD09 4994-4998
  int    HHNMCR09 4999-5002
  int    HHNPRV09 5003-5006
  int    HHNVA09 5007-5009
  int    HHNTRI09 5010-5012
  int    HHNOFD09 5013-5016
  byte   HHNSTL09 5017-5017
  byte   HHNWCP09 5018-5018
  long   HHNOPR09 5019-5023
  int    HHNOPU09 5024-5026
  byte   HHNOSR09 5027-5027
  int    HHINFD09 5028-5030
  int    VISEXP09 5031-5034
  int    VISTCH09 5035-5038
  int    VISSLF09 5039-5042
  int    VISMCR09 5043-5045
  int    VISMCD09 5046-5049
  int    VISPRV09 5050-5053
  int    VISVA09 5054-5057
  int    VISTRI09 5058-5060
  int    VISOFD09 5061-5063
  int    VISSTL09 5064-5066
  int    VISWCP09 5067-5069
  int    VISOPR09 5070-5072
  int    VISOPU09 5073-5075
  int    VISOSR09 5076-5078
  long   OTHTCH09 5079-5083
  long   OTHEXP09 5084-5088
  long   OTHSLF09 5089-5093
  long   OTHMCR09 5094-5098
  long   OTHMCD09 5099-5103
  long   OTHPRV09 5104-5108
  int    OTHVA09 5109-5112
  int    OTHTRI09 5113-5116
  int    OTHOFD09 5117-5119
  int    OTHSTL09 5120-5123
  int    OTHWCP09 5124-5127
  int    OTHOPR09 5128-5131
  int    OTHOPU09 5132-5135
  int    OTHOSR09 5136-5139
  int    RXTOT09 5140-5142
  long   RXEXP09 5143-5148
  long   RXSLF09 5149-5153
  long   RXMCR09 5154-5158
  long   RXMCD09 5159-5163
  long   RXPRV09 5164-5169
  long   RXVA09 5170-5174
  long   RXTRI09 5175-5179
  long   RXOFD09 5180-5184
  long   RXSTL09 5185-5189
  long   RXWCP09 5190-5194
  long   RXOPR09 5195-5199
  int    RXOPU09 5200-5203
  int    RXOSR09 5204-5207
  long   TOTPTR09 5208-5213
  long   TOTOTH09 5214-5219
  long   OBVPTR09 5220-5224
  long   OBVOTH09 5225-5229
  long   OBDPTR09 5230-5234
  long   OBDOTH09 5235-5239
  long   OBOPTR09 5240-5244
  long   OBOOTH09 5245-5249
  int    OBCPTR09 5250-5253
  long   OBCOTH09 5254-5258
  long   OBNPTR09 5259-5263
  long   OBNOTH09 5264-5268
  int    OBEPTR09 5269-5272
  int    OBEOTH09 5273-5276
  int    OBAPTR09 5277-5280
  long   OBAOTH09 5281-5285
  long   OBTPTR09 5286-5290
  int    OBTOTH09 5291-5294
  long   OPTPTR09 5295-5300
  long   OPTOTH09 5301-5305
  long   OPFPTR09 5306-5311
  long   OPFOTH09 5312-5316
  int    OPDPTR09 5317-5320
  long   OPDOTH09 5321-5325
  long   OPVPTR09 5326-5331
  long   OPVOTH09 5332-5336
  int    OPSPTR09 5337-5340
  long   OPSOTH09 5341-5345
  long   OPOPTR09 5346-5350
  long   OPOOTH09 5351-5355
  int    OPPPTR09 5356-5359
  long   OPPOTH09 5360-5364
  int    AMCPTR09 5365-5368
  long   AMCOTH09 5369-5373
  long   AMNPTR09 5374-5378
  long   AMNOTH09 5379-5383
  int    AMEPTR09 5384-5387
  int    AMEOTH09 5388-5391
  long   AMAPTR09 5392-5396
  long   AMAOTH09 5397-5401
  long   AMTPTR09 5402-5406
  int    AMTOTH09 5407-5410
  long   ERTPTR09 5411-5415
  long   ERTOTH09 5416-5420
  long   ERFPTR09 5421-5425
  long   ERFOTH09 5426-5430
  int    ERDPTR09 5431-5434
  int    ERDOTH09 5435-5438
  long   ZIFPTR09 5439-5443
  int    ZIFOTH09 5444-5447
  int    ZIDPTR09 5448-5451
  int    ZIDOTH09 5452-5455
  long   IPTPTR09 5456-5461
  long   IPTOTH09 5462-5467
  long   IPFPTR09 5468-5473
  long   IPFOTH09 5474-5479
  long   IPDPTR09 5480-5484
  long   IPDOTH09 5485-5489
  long   DVTPTR09 5490-5494
  long   DVTOTH09 5495-5499
  long   DVGPTR09 5500-5504
  int    DVGOTH09 5505-5508
  long   DVOPTR09 5509-5513
  int    DVOOTH09 5514-5517
  long   HHAPTR09 5518-5522
  long   HHAOTH09 5523-5527
  int    HHNPTR09 5528-5531
  long   HHNOTH09 5532-5536
  int    VISPTR09 5537-5540
  int    VISOTH09 5541-5543
  long   OTHPTR09 5544-5548
  int    OTHOTH09 5549-5552
  long   RXPTR09 5553-5558
  long   RXOTH09 5559-5563
  double PERWT09F 5564-5575
  double FAMWT09F 5576-5587
  double FAMWT09C 5588-5599
  double SAQWT09F 5600-5611
  double DIABW09F 5612-5623
  int    VARSTR 5624-5627
  byte   VARPSU 5628-5628
using H129.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSON ID (DUID + PID)";
label variable PANEL "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID09 "FAMILY ID (STUDENT MERGED IN) - 12/31/09";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPSFAMID";
label variable HIEUIDX "HIEU IDENTIFIER";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR09 "RU LETTER AS OF 12/31/09";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE09 "RU SIZE AS OF 12/31/09";
label variable RUCLAS31 "RU FIELDED AS:STANDARD/NEW/STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD/NEW/STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS:STANDARD/NEW/STUDENT-R5/3";
label variable RUCLAS09 "RU FIELDED AS:STANDARD/NEW/STUD-12/31/09";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE09 "RU SIZE INCLUDING STUDENT AS OF 12/31/09";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION09 "CENSUS REGION AS OF 12/31/09";
label variable MSA31 "MSA STATUS - R3/1";
label variable MSA42 "MSA STATUS - R4/2";
label variable MSA53 "MSA STATUS - R5/3";
label variable MSA09 "MSA AS OF 12/31/09";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS09 "REFERENCE PERSON AS OF 12/31/09";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP09 "1ST RESPONDENT INDICATOR AS OF 12/31/09";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY09 "WAS RESPONDENT A PROXY AS OF 12/31/09";
label variable INTVLANG "LANGUAGE INTERVIEW WAS COMPLETED";
label variable BEGRFD31 "R3/1 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD31 "R3/1 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD42 "R4/2 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD42 "R4/2 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD53 "R5/3 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD53 "R5/3 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFD09 "2009 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM09 "2009 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY09 "2009 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP09 "INSCOPE - R5/3 START THROUGH 12/31/09";
label variable INSC1231 "INSCOPE STATUS ON 12/31/09";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 2009";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND09 "ELIGIBILITY STATUS AS OF 12/31/09";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE09X "AGE AS OF 12/31/09 (EDITED/IMPUTED)";
label variable AGELAST "PERSON S AGE LAST TIME ELIGIBLE";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEX "RACE (EDITED/IMPUTED)";
label variable RACEAX "ASIAN AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEBX "BLACK AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEWX "WHITE AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACETHNX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPCAT "SPECIFIC HISPANIC ETHNICITY GROUP";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY09X "MARITAL STATUS-12/31/09 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID09 "SPOUSE ID - 12/31/09";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT-R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT-R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT-R5/3";
label variable SPOUIN09 "MARITAL STATUS W/SPOUSE PRESENT-12/31/09";
label variable EDUCYR "YEARS OF EDUC WHEN FIRST ENTERED MEPS";
label variable HIDEG "HIGHEST DEGREE WHEN FIRST ENTERED MEPS";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 - R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 - R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 - R5/3";
label variable FTSTU09X "STUDENT STATUS IF AGES 17-23 - 12/31/09";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - R3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable HONRDC31 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC42 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC53 "HONORABLY DISCHARGED FROM MILITARY";
label variable RFREL31X "RELATION TO REF PERS-R3/1 (EDIT/IMP)";
label variable RFREL42X "RELATION TO REF PERS-R4/2 (EDIT/IMP)";
label variable RFREL53X "RELATION TO REF PERS-R5/3 (EDIT/IMP)";
label variable RFREL09X "RELATION TO REF PERS-12/31/09 (EDIT/IMP)";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable HIBPDX "HIGH BLOOD PRESSURE DIAG (>17)";
label variable HIBPAGED "AGE OF DIAGNOSIS-HIGH BLOOD PRESSURE";
label variable BPMLDX "MULT DIAG HIGH BLOOD PRESS (>17)";
label variable CHDDX "CORONARY HRT DISEASE DIAG (>17)";
label variable CHDAGED "AGE OF DIAGNOSIS-CORONARY HEART DISEASE";
label variable ANGIDX "ANGINA DIAGNOSIS (>17)";
label variable ANGIAGED "AGE OF DIAGNOSIS-ANGINA";
label variable MIDX "HEART ATTACK (MI) DIAG (>17)";
label variable MIAGED "AGE OF DIAGNOSIS-HEART ATTACK(MI)";
label variable OHRTDX "OTHER HEART DISEASE DIAG (>17)";
label variable OHRTAGED "AGE OF DIAGNOSIS-OTHER HEART DISEASE";
label variable STRKDX "STROKE DIAGNOSIS (>17)";
label variable STRKAGED "AGE OF DIAGNOSIS-STROKE";
label variable EMPHDX "EMPHYSEMA DIAGNOSIS (>17)";
label variable EMPHAGED "AGE OF DIAGNOSIS-EMPHYSEMA";
label variable CHBRON31 "CHRONC BRONCHITS LAST 12 MTHS (>17)-R3/1";
label variable CHBRON53 "CHRONC BRONCHITS LAST 12 MTHS (>17)-R5/3";
label variable CHOLDX "HIGH CHOLESTEROL DIAGNOSIS (>17)";
label variable CHOLAGED "AGE OF DIAGNOSIS-HIGH CHOLESTEROL";
label variable CANCERDX "CANCER DIAGNOSIS (>17)";
label variable CABLADDR "CANCER DIAGNOSED - BLADDER (>17)";
label variable BLDRAGED "AGE OF DIAGNOSIS-BLADDER CANCER";
label variable BLDRREMS "BLADDER CANCER IN REMISSION";
label variable CABONE "CANCER DIAGNOSED - BONE (>17)";
label variable BONEAGED "AGE OF DIAGNOSIS-BONE CANCER";
label variable BONEREMS "BONE CANCER IN REMISSION";
label variable CABRAIN "CANCER DIAGNOSED - BRAIN (>17)";
label variable BRAIAGED "AGE OF DIAGNOSIS-BRAIN CANCER";
label variable BRAIREMS "BRAIN CANCER IN REMISSION";
label variable CABREAST "CANCER DIAGNOSED - BREAST (>17)";
label variable BRSTAGED "AGE OF DIAGNOSIS-BREAST CANCER";
label variable BRSTREMS "BREAST CANCER IN REMISSION";
label variable CACERVIX "CANCER DIAGNOSED - CERVIX (>17)";
label variable CERVAGED "AGE OF DIAGNOSIS-CERVICAL CANCER";
label variable CERVREMS "CERVICAL CANCER IN REMISSION";
label variable CACOLON "CANCER DIAGNOSED - COLON (>17)";
label variable COLOAGED "AGE OF DIAGNOSIS-COLON CANCER";
label variable COLOREMS "COLON CANCER IN REMISSION";
label variable CAKIDNEY "CANCER DIAGNOSED - KIDNEY (>17)";
label variable KIDNAGED "AGE OF DIAGNOSIS-RENAL CANCER";
label variable KIDNREMS "RENAL CANCER IN REMISSION";
label variable CALARYNX "CANCER DIAGNOSED - LARYNX (>17)";
label variable LRNXAGED "AGE OF DIAGNOSIS-LARYNGEAL CANCER";
label variable LRNXREMS "LARYNGEAL CANCER IN REMISSION";
label variable CALEUKEM "CANCER DIAGNOSED - LEUKEMIA (>17)";
label variable LEUKAGED "AGE OF DIAGNOSIS-LEUKEMIA";
label variable LEUKREMS "LEUKEMIA IN REMISSION";
label variable CALIVER "CANCER DIAGNOSED - LIVER (>17)";
label variable LIVRAGED "AGE OF DIAGNOSIS-LIVER CANCER";
label variable LIVRREMS "LIVER CANCER IN REMISSION";
label variable CALUNG "CANCER DIAGNOSED - LUNG (>17)";
label variable LUNGAGED "AGE OF DIAGNOSIS-LUNG CANCER";
label variable LUNGREMS "LUNG CANCER IN REMISSION";
label variable CALYMPH "CANCER DIAGNOSED - LYMPHOMA (>17)";
label variable LYMPAGED "AGE OF DIAGNOSIS-LYMPHOMA";
label variable LYMPREMS "LYMPHOMA IN REMISSION";
label variable CAMELANO "CANCER DIAGNOSED - MELANOMA (>17)";
label variable MELAAGED "AGE OF DIAGNOSIS-MELANOMA";
label variable MELAREMS "MELANOMA IN REMISSION";
label variable CAMOUTH "CANCER DIAGNOSED - MOUTH/LIP/TONGE (>17)";
label variable MOUTAGED "AGE OF DIAGNOSIS-MOUTH/LIP/TONGUE CANCER";
label variable MOUTREMS "MOUTH/TONGUE/LIP CANCER IN REMISSION";
label variable CAMUSCLE "CANCER DIAGNSD - SOFTTISS/MUSC/FAT (>17)";
label variable MUSCAGED "AGE OF DIAGNOSIS-SFTTISS/MUSC/FAT CANCER";
label variable MUSCREMS "SFTTISS/MUSC/FAT CANCER IN REMISSION";
label variable CAOTHER "CANCER DIAGNOSED - OTHER (>17)";
label variable OTHRAGED "AGE OF DIAGNOSIS-OTHER CANCER";
label variable OTHRREMS "OTHER CANCER IN REMISSION";
label variable CAOVARY "CANCER DIAGNOSED - OVARY (>17)";
label variable OVRYAGED "AGE OF DIAGNOSIS-OVARIAN CANCER";
label variable OVRYREMS "OVARIAN CANCER IN REMISSION";
label variable CAPANCRS "CANCER DIAGNOSED - PANCREAS (>17)";
label variable PANCAGED "AGE OF DIAGNOSIS-PANCREATIC CANCER";
label variable PANCREMS "PANCREATIC CANCER IN REMISSION";
label variable CAPROSTA "CANCER DIAGNOSED - PROSTATE (>17)";
label variable PRSTAGED "AGE OF DIAGNOSIS-PROSTATE CANCER";
label variable PRSTREMS "PROSTATE CANCER IN REMISSION";
label variable CARECTUM "CANCER DIAGNOSED - RECTUM (>17)";
label variable RECTAGED "AGE OF DIAGNOSIS-RECTAL CANCER";
label variable RECTREMS "RECTAL CANCER IN REMISSION";
label variable CASKINNM "CANCER DIAGNOSED - SKIN-NONMELANO (>17)";
label variable SKNMAGED "AGE OF DIAGNOSIS-SKIN-NONMELANOMA CANCER";
label variable SKNMREMS "SKIN-NONMELANOMA CANCER IN REMISSION";
label variable CASKINDK "CANCER DIAGNOSED - SKIN-DKKIND (>17)";
label variable SKDKAGED "AGE OF DIAGNOSIS-SKIN-DK KIND CANCER";
label variable SKDKREMS "SKIN-DK KIND CANCER IN REMISSION";
label variable CASTOMCH "CANCER DIAGNOSED - STOMACH (>17)";
label variable STOMAGED "AGE OF DIAGNOSIS-STOMACH CANCER";
label variable STOMREMS "STOMACH CANCER IN REMISSION";
label variable CATESTIS "CANCER DIAGNOSED - TESTIS (>17)";
label variable TSTSAGED "AGE OF DIAGNOSIS-TESTICULAR CANCER";
label variable TSTSREMS "TESTICULAR CANCER IN REMISSION";
label variable CATHROAT "CANCER DIAGNOSED - THROAT (>17)";
label variable THRTAGED "AGE OF DIAGNOSIS-THROAT CANCER";
label variable THRTREMS "THROAT CANCER IN REMISSION";
label variable CATHYROD "CANCER DIAGNOSED - THYROID (>17)";
label variable THYRAGED "AGE OF DIAGNOSIS-THYROID CANCER";
label variable THYRREMS "THYROID CANCER IN REMISSION";
label variable CAUTERUS "CANCER DIAGNOSED - UTERUS (>17)";
label variable UTERAGED "AGE OF DIAGNOSIS-UTERINE CANCER";
label variable UTERREMS "UTERINE CANCER IN REMISSION";
label variable DIABDX "DIABETES DIAGNOSIS (>17)";
label variable DIABAGED "AGE OF DIAGNOSIS-DIABETES";
label variable JTPAIN31 "JOINT PAIN LAST 12 MONTHS (>17) - RD 3/1";
label variable JTPAIN53 "JOINT PAIN LAST 12 MONTHS (>17) - RD 5/3";
label variable ARTHDX "ARTHRITIS DIAGNOSIS (>17)";
label variable ARTHTYPE "TYPE OF ARTHRITIS DIAGNOSED (>17)";
label variable ARTHAGED "AGE OF DIAGNOSIS-ARTHRITIS";
label variable ASTHDX "ASTHMA DIAGNOSIS";
label variable ASTHAGED "AGE OF DIAGNOSIS-ASTHMA";
label variable ASSTIL31 "DOES PERSON STILL HAVE ASTHMA-RD3/1";
label variable ASSTIL53 "DOES PERSON STILL HAVE ASTHMA - RD 5/3";
label variable ASATAK31 "ASTHMA ATTACK LAST 12 MOS - RD3/1";
label variable ASATAK53 "ASTHMA ATTACK LAST 12 MOS - RD 5/3";
label variable ASTHEP31 "WHEN WAS LAST EPISODE OF ASTHMA - RD 3/1";
label variable ASTHEP53 "WHEN WAS LAST EPISODE OF ASTHMA - RD 5/3";
label variable ASACUT53 "USED ACUTE PRES INHALER LAST 3 MOS-RD5/3";
label variable ASMRCN53 "USED>3ACUTE CN PRES INH LAST 3 MOS-RD5/3";
label variable ASPREV53 "EVER USED PREV DAILY ASTHMA MEDS -RD 5/3";
label variable ASDALY53 "NOW TAKE PREV DAILY ASTHMA MEDS - RD 5/3";
label variable ASPKFL53 "HAVE PEAK FLOW METER AT HOME - RD 5/3";
label variable ASEVFL53 "EVER USED PEAK FLOW METER - RD 5/3";
label variable ASWNFL53 "WHEN LAST USED PEAK FLOW METER - RD 5/3";
label variable ADHDADDX "ADHDADD DIAGNOSIS (5-17)";
label variable ADHDAGED "AGE OF DIAGNOSIS-ADHD/ADD";
label variable PREGNT31 "PREGNANT DURING REF PERIOD - RD 3/1";
label variable PREGNT42 "PREGNANT DURING REF PERIOD - RD 4/2";
label variable PREGNT53 "PREGNANT DURING REF PERIOD - RD 5/3";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable IADLHP42 "IADL SCREENER - RD 4/2";
label variable IADLHP53 "IADL SCREENER - RD 5/3";
label variable IADL3M31 "IADL HELP 3+ MONTHS - RD 3/1";
label variable IADL3M42 "IADL HELP 3+ MONTHS - RD 4/2";
label variable IADL3M53 "IADL HELP 3+ MONTHS - RD 5/3";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable ADLHLP42 "ADL SCREENER - RD 4/2";
label variable ADLHLP53 "ADL SCREENER - RD 5/3";
label variable ADL3MO31 "ADL HELP 3+ MONTHS - RD 3/1";
label variable ADL3MO42 "ADL HELP 3+ MONTHS - RD 4/2";
label variable ADL3MO53 "ADL HELP 3+ MONTHS - RD 5/3";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable AIDHLP53 "USED ASSISTIVE DEVICES - RD 5/3";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable WLKLIM53 "LIMITATION IN PHYSICAL FUNCTIONING-RD5/3";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable LFTDIF53 "DIFFICULTY LIFTING 10 POUNDS - RD 5/3";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable STPDIF53 "DIFFICULTY WALKING UP 10 STEPS - RD 5/3";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable WLKDIF53 "DIFFICULTY WALKING 3 BLOCKS - RD 5/3";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable MILDIF53 "DIFFICULTY WALKING A MILE - RD 5/3";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable STNDIF53 "DIFFICULTY STANDING 20 MINUTES - RD 5/3";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable BENDIF53 "DIFFICULTY BENDING/STOOPING - RD 5/3";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable RCHDIF53 "DIFFICULTY REACHING OVERHEAD - RD 5/3";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable FNGRDF53 "DIFFICULTY USING FINGERS TO GRASP-RD 5/3";
label variable WLK3MO31 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 3/1";
label variable WLK3MO53 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 5/3";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable ACTLIM53 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 5/3";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable WRKLIM53 "WORK LIMITATION - RD 5/3";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable HSELIM53 "HOUSEWORK LIMITATION - RD 5/3";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable SCHLIM53 "SCHOOL LIMITATION - RD 5/3";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable UNABLE53 "COMPLETELY UNABLE TO DO ACTIVITY-RD 5/3";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable SOCLIM53 "SOCIAL LIMITATIONS - RD 5/3";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable COGLIM53 "COGNITIVE LIMITATIONS - RD 5/3";
label variable WRGLAS42 "WEARS EYEGLASSES OR CONTACTS - RD 4/2";
label variable SEEDIF42 "DIFFCLTY SEEING W/GLASSES/CNTCTS-RD 4/2";
label variable BLIND42 "PERSON IS BLIND - RD 4/2";
label variable READNW42 "CAN READ NEWSPRNT W/GLASSES/CNTCTS-RD4/2";
label variable RECPEP42 "CAN RECGNZE PEOPLE W/GLASSES/CNTCTS-R4/2";
label variable VISION42 "VISION IMPAIRMENT (SUMMARY) - RD 4/2";
label variable HEARAD42 "PERSON WEARS HEARING AID - RD 4/2";
label variable HEARDI42 "ANY DIFFCLTY HEARING W/HEARING AID-RD4/2";
label variable DEAF42 "PERSON IS DEAF - RD 4/2";
label variable HEARMO42 "CAN HEAR MOST CONVERSATION - RD 4/2";
label variable HEARSM42 "CAN HEAR SOME CONVERSATION - RD 4/2";
label variable HEARNG42 "HEARING IMPAIRMENT (SUMMARY) - RD 4/2";
label variable ANYLIM09 "ANY LIMITATION IN P13R3,4,5/P14R1,2,3";
label variable LSHLTH42 "LESS HEALTHY THAN OTHR CHILD (0-17)-R4/2";
label variable NEVILL42 "NEVER BEEN SERIOUSLY ILL (0-17)-R4/2";
label variable SICEAS42 "CHILD GETS SICK EASILY (0-17)-R4/2";
label variable HLTHLF42 "CHILD WILL HAVE HEALTHY LIFE (0-17)-R4/2";
label variable WRHLTH42 "WORRY MORE ABOUT HEALTH (0-17)-R4/2";
label variable CHPMED42 "CSHCN:CHILD NEEDS PRESCRB MED(0-17)-R4/2";
label variable CHPMHB42 "CSHCN:PMED FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHPMCN42 "CSHCN:PMED COND LAST 12+ MOS (0-17)-R4/2";
label variable CHSERV42 "CSHCN:CHLD NEEDS MED&OTH SERV(0-17)-R4/2";
label variable CHSRHB42 "CSHCN:SERV FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHSRCN42 "CSHCN:SERV COND LAST 12+ MOS (0-17)-R4/2";
label variable CHLIMI42 "CSHCN:LIMITED IN ANY WAY (0-17)-R4/2";
label variable CHLIHB42 "CSHCN:LIMT FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHLICO42 "CSHCN:LIMIT COND LAST 12+MOS (0-17)-R4/2";
label variable CHTHER42 "CSHCN:CHLD NEEDS SPEC THERAPY(0-17)-R4/2";
label variable CHTHHB42 "CSHCN:SPEC THER FOR HLTH+COND(0-17)-R4/2";
label variable CHTHCO42 "CSHCN:THER COND LAST 12+ MOS (0-17)-R4/2";
label variable CHCOUN42 "CSHCN:CHILD NEEDS COUNSELING (0-17)-R4/2";
label variable CHEMPB42 "CSHCN:COUNS PROB LAST 12+MOS (0-17)-R4/2";
label variable CSHCN42 "CSHCN:CHILD W/SPEC HC NEEDS (0-17)-R4/2";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-R4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-R4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-R4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-R4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - R4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PRBLM GETTING ALONG W/SIBS (5-17)-R4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17)-R4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17)-R4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-R4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-R4/2";
label variable TRBLE42 "PRBLM STAY OUT OF TROUBLE (5-17)-R4/2";
label variable CHILCR42 "CAHPS:12MOS:ILL/INJ NEED CARE(0-17)-R4/2";
label variable CHILWW42 "CAHPS:12MOS:ILL CARE WHN WNTD(0-17)-R4/2";
label variable CHRTCR42 "CAHPS:12MOS:MAKE ROUT CARE APT(0-17)R4/2";
label variable CHRTWW42 "CAHPS:12MOS:ROUT APT WHN WNTD(0-17)-R4/2";
label variable CHAPPT42 "CAHPS:12MOS:# OF OFF/CLIN APTS(0-17)R4/2";
label variable CHNDCR42 "CAHPS:12MOS:NEED ANY CARE/TRT(0-17)-R4/2";
label variable CHENEC42 "CAHPS:12MOS:EASY GET NEC CARE (0-17)R4/2";
label variable CHLIST42 "CAHPS:12MOS:CHLD DR LSN TO YOU(0-17)R4/2";
label variable CHEXPL42 "CAHPS:12MOS:CHLD DR EXPL THNG(0-17)R4/2";
label variable CHRESP42 "CAHPS:12MOS:CHLD S DR SHW RESP(0-17)R4/2";
label variable CHPRTM42 "CAHPS:12MOS:CHILD DR ENGH TIME(0-17)R4/2";
label variable CHHECR42 "CAHPS:12MOS:RATE CHLD HLT CARE(0-17)R4/2";
label variable CHSPEC42 "CAHPS:12MOS:CHLD NEEDED SPEC(0-17)R4/2";
label variable CHEYRE42 "CAHPS:12MOS:ESY W/RFR TO SPEC(0-17)-R4/2";
label variable MESHGT42 "DOCTOR EVER MEASURED HEIGHT (0-17)-R4/2";
label variable WHNHGT42 "WHEN DOCTOR MEASURED HEIGHT (0-17)-R4/2";
label variable MESWGT42 "DOCTOR EVER MEASURED WEIGHT (0-17)-R4/2";
label variable WHNWGT42 "WHEN DOCTOR MEASURED WEIGHT (0-17)-R4/2";
label variable CHBMIX42 "CHILD S BODY MASS INDEX (6-17)-R4/2";
label variable MESVIS42 "DOCTOR CHECKED CHILD S VISION (3-6)-R4/2";
label variable MESBPR42 "DR CHECKED BLOOD PRESSURE (2-17)-R4/2";
label variable WHNBPR42 "WHEN DR CHECKED BLOOD PRESS (2-17)-R4/2";
label variable DENTAL42 "DR ADVISE REG DENTAL CHECKUP (2-17)-R4/2";
label variable WHNDEN42 "WHEN DR ADVISE DENT CHECKUP (2-17)-R4/2";
label variable EATHLT42 "DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable WHNEAT42 "WHEN DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable PHYSCL42 "DR ADVISE EXERCISE (2-17)-R4/2";
label variable WHNPHY42 "WHEN DR ADVISE EXERCISE (2-17)-R4/2";
label variable SAFEST42 "DR ADVISE CHLD SAFETY SEAT (WT<=40)-R4/2";
label variable WHNSAF42 "WHEN DR ADVISE SAFETY SEAT (WT<=40)-R4/2";
label variable BOOST42 "DR ADVISE BOOSTER SEAT (40<WT<=80)-R4/2";
label variable WHNBST42 "WHN DR ADVISE BOOST SEAT(40<WT<=80)-R4/2";
label variable LAPBLT42 "DR ADVISE LAP/SHOULDER BELT (80<WT)-R4/2";
label variable WHNLAP42 "WHN DR ADVISE LAP/SHLDR BLT (80<WT)-R4/2";
label variable HELMET42 "DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable WHNHEL42 "WHEN DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable NOSMOK42 "DR ADVISE SMKG IN HOME IS BAD(0-17)-R4/2";
label variable WHNSMK42 "WHN DR ADVIS SMKG IN HOME BAD(0-17)-R4/2";
label variable TIMALN42 "DOCTOR SPEND ANY TIME ALONE (12-17)-R4/2";
label variable DENTCK53 "HOW OFTEN DENTAL CHECK-UP - RD 5/3";
label variable BPCHEK53 "TIME SNCE LST BLOOD PRES CHK (>17)-RD5/3";
label variable BPMONT53 "# MOS SNCE LST BLOOD PRES CHK (>17)-R5/3";
label variable CHOLCK53 "HOW LNG CHOLEST LST CHCK (>17) - RD 5/3";
label variable CHECK53 "HOW LNG LST ROUTNE CHECKUP (>17)-RD 5/3";
label variable NOFAT53 "RESTRICT HGH FAT/CHOLES FOOD (>17)-RD5/3";
label variable EXRCIS53 "ADVISED TO EXERCISE MORE (>17) - RD 5/3";
label variable FLUSHT53 "HOW LNG LAST FLU VACINATION (>17)-RD 5/3";
label variable ASPRIN53 "TKE ASPIRN EVERY (OTHR) DAY (>17)-RD 5/3";
label variable NOASPR53 "TAKING ASPIRIN UNSAFE (>17) - RD 5/3";
label variable STOMCH53 "TKE ASPRN UNSAFE B/C STOMCH (>17)-RD 5/3";
label variable LSTETH53 "LOST ALL UPPR AND LOWR TEETH (>17)-RD5/3";
label variable PSA53 "HOW LONG SINCE LAST PSA (>39) - RD 5/3";
label variable HYSTER53 "HAD A HYSTERECTOMY (>17) - RD 5/3";
label variable PAPSMR53 "HOW LNG LST PAP SMEAR TST (>17) - RD 5/3";
label variable BRSTEX53 "HOW LNG SNCE LST BREAST EXAM (>17)-RD5/3";
label variable MAMOGR53 "HOW LNG SNCE LST MAMMOGRAM (>29) - RD5/3";
label variable BSTST53 "MST RCNT BLD STOOL TST HME KIT(>39)-R5/3";
label variable BSTSRE53 "RSN HAVE BLD STOOL TST (>39)-R5/3";
label variable CLNTST53 "MOST RECENT COLONOSCOPY (>39) - R5/3";
label variable CLNTRE53 "RSN HAVE COLONOSCOPY (>39)-R5/3";
label variable SGMTST53 "MOST RECENT SIGMOIDOSCOPY (>39) - R5/3";
label variable SGMTRE53 "RSN HAVE SIGMOIDOSCOPY (>39)-R5/3";
label variable PHYACT53 "MOD/VIG PHYS ACTIV 3X WK (>17) - RD 5/3";
label variable BMINDX53 "ADULT BODY MASS INDEX (>17) - RD 5/3";
label variable SEATBE53 "WEARS SEAT BELT (>15) - RD 5/3";
label variable SAQELIG "ELIGIBILITY STATUS FOR SAQ";
label variable ADPRX42 "SAQ: RELATIONSHIP OF PROXY TO ADULT";
label variable ADILCR42 "SAQ 12MOS: ILL/INJURY NEEDING IMMED CARE";
label variable ADILWW42 "SAQ 12 MOS: GOT CARE WHEN NEEDED ILL/INJ";
label variable ADRTCR42 "SAQ 12 MOS: MADE APPT ROUTINE MED CARE";
label variable ADRTWW42 "SAQ 12 MOS: GOT MED APPT WHEN WANTED";
label variable ADAPPT42 "SAQ 12 MOS: # VISITS TO MED OFF FOR CARE";
label variable ADNDCR42 "SAQ 12MOS: NEED ANY CARE, TEST, TREATMNT";
label variable ADEGMC42 "SAQ 12MOS: EASY GETTING NEEDED MED CARE";
label variable ADLIST42 "SAQ 12 MOS: DOCTOR LISTENED TO YOU";
label variable ADEXPL42 "SAQ 12 MOS: DOC EXPLAINED SO UNDERSTOOD";
label variable ADRESP42 "SAQ 12 MOS: DR SHOWED RESPECT";
label variable ADPRTM42 "SAQ 12 MOS: DR SPENT ENUF TIME WITH YOU";
label variable ADHECR42 "SAQ 12 MOS: RATING OF HEALTH CARE";
label variable ADSMOK42 "SAQ: CURRENTLY SMOKE";
label variable ADNSMK42 "SAQ 12MOS: DR ADVISED TO QUIT SMOKING";
label variable ADDRBP42 "SAQ 2 YRS: DR CHECKED BLOOD PRESSURE";
label variable ADSPEC42 "SAQ 12 MOS: NEEDED TO SEE SPECIALIST";
label variable ADSPRF42 "SAQ 12MOS: HOW ESY GETTING SPEC REFERRAL";
label variable ADGENH42 "SAQ: HEALTH IN GENERAL SF-12V2";
label variable ADDAYA42 "SAQ: HLTH LIMITS MOD ACTIVITIES SF-12V2";
label variable ADCLIM42 "SAQ: HLTH LIMITS CLIMBING STAIRS SF-12V2";
label variable ADPALS42 "SAQ 4WKS:ACCMP LESS B/C PHY PRBS SF-12V2";
label variable ADPWLM42 "SAQ 4WKS:WORK LIMT B/C PHY PROBS SF-12V2";
label variable ADMALS42 "SAQ 4WKS:ACCMP LESS B/C MNT PRBS SF-12V2";
label variable ADMWLM42 "SAQ 4WKS:WORK LIMT B/C MNT PROBS SF-12V2";
label variable ADPAIN42 "SAQ 4WKS:PAIN LIMITS NORMAL WORK SF-12V2";
label variable ADCAPE42 "SAQ 4WKS: FELT CALM/PEACEFUL SF-12V2";
label variable ADNRGY42 "SAQ 4WKS: HAD A LOT OF ENERGY SF-12V2";
label variable ADDOWN42 "SAQ 4WKS: FELT DOWNHEARTED/DEPR SF-12V2";
label variable ADSOCA42 "SAQ 4WKS: HLTH STOPPED SOC ACTIV SF-12V2";
label variable PCS42 "SAQ:PHY COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable MCS42 "SAQ:MNT COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable SFFLAG42 "SAQ: PCS/MCS IMPUTATION FLAG SF-12V2";
label variable ADNERV42 "SAQ 30 DAYS: HOW OFTEN FELT NERVOUS";
label variable ADHOPE42 "SAQ 30 DAYS: HOW OFTEN FELT HOPELESS";
label variable ADREST42 "SAQ 30 DAYS: HOW OFTEN FELT RESTLESS";
label variable ADSAD42 "SAQ 30 DAYS: HOW OFTEN FELT SAD";
label variable ADEFRT42 "SAQ 30 DAYS: HOW OFTN EVRYTHNG AN EFFORT";
label variable ADWRTH42 "SAQ 30 DAYS: HOW OFTEN FELT WORTHLESS";
label variable K6SUM42 "SAQ 30 DAYS: OVERALL RATING OF FEELINGS";
label variable ADINTR42 "SAQ 2 WKS: LITTLE INTEREST IN THINGS";
label variable ADDPRS42 "SAQ 2 WKS: FELT DOWN/DEPRESSED/HOPELESS";
label variable PHQ242 "SAQ 2 WKS: OVERALL RATING OF FEELINGS";
label variable ADINSA42 "SAQ: DO NOT NEED HEALTH INSURANCE";
label variable ADINSB42 "SAQ: HEALTH INSURANCE NOT WORTH COST";
label variable ADRISK42 "SAQ: MORE LIKELY TO TAKE RISKS";
label variable ADOVER42 "SAQ: CAN OVERCOME ILLS WITHOUT MED HELP";
label variable ADCMPM42 "SAQ: DATE COMPLETED - MONTH";
label variable ADCMPD42 "SAQ: DATE COMPLETED - DAY";
label variable ADCMPY42 "SAQ: DATE COMPLETED - YEAR";
label variable ADLANG42 "SAQ: LANGUAGE OF SAQ INTERVIEW";
label variable DSDIA53 "DCS: DIABETES DIAGNOSIS BY HEALTH PROF";
label variable DSA1C53 "DCS: TIMES TESTED FOR A-ONE-C - 2009";
label variable DSFT1053 "DCS: HAD FEET CHECKED DURING 2010";
label variable DSFT0953 "DCS: HAD FEET CHECKED DURING 2009";
label variable DSFT0853 "DCS: HAD FEET CHECKED DURING 2008";
label variable DSFB0853 "DCS: HAD FEET CHECKED BEFORE 2008";
label variable DSFTNV53 "DCS: NEVER HAD FEET CHECKED";
label variable DSEY1053 "DCS: DILATED EYE EXAM IN 2010";
label variable DSEY0953 "DCS: DILATED EYE EXAM IN 2009";
label variable DSEY0853 "DCS: DILATED EYE EXAM IN 2008";
label variable DSEB0853 "DCS: DILATED EYE EXAM BEFORE 2008";
label variable DSEYNV53 "DCS: NEVER HAD DILATED EYE EXAM";
label variable DSCH1053 "DCS: BLOOD CHOLESTEROL CHECKED IN 2010";
label variable DSCH0953 "DCS: BLOOD CHOLESTEROL CHECKED IN 2009";
label variable DSCH0853 "DCS: BLOOD CHOLESTEROL CHECKED IN 2008";
label variable DSCB0853 "DCS: BLOOD CHOLESTEROL CHECKED BEF 2008";
label variable DSCHNV53 "DCS: NEVER HAD BLOOD CHOLESTEROL CHECKED";
label variable DSFL1053 "DCS: GOT FLU VACCINATION IN 2010";
label variable DSFL0953 "DCS: GOT FLU VACCINATION IN 2009";
label variable DSFL0853 "DCS: GOT FLU VACCINATION IN 2008";
label variable DSVB0853 "DCS: GOT FLU VACCINATION BEFORE 2008";
label variable DSFLNV53 "DCS: NEVER GOT FLU VACCINATION";
label variable DSKIDN53 "DCS: HAS DIABETES CAUSED KIDNEY PROBLEMS";
label variable DSEYPR53 "DCS: HAS DIABETES CAUSED EYE PROBS";
label variable DSDIET53 "DCS: TREAT DIABETES W/DIET MODIFICATION";
label variable DSMED53 "DCS: TREAT DIABETES W/MEDS BY MOUTH";
label variable DSINSU53 "DCS: TREAT DIABETES W/INSULIN INJECTIONS";
label variable DSCPCP53 "DCS: LEARNED CARE FROM PRIMARY CARE PROV";
label variable DSCNPC53 "DCS: LEARNED CARE FROM OTHER PROVIDER";
label variable DSCPHN53 "DCS: LEARN CARE FROM PHONE CALL W/PROV";
label variable DSCINT53 "DCS: LEARNED CARE FROM READING INTERNET";
label variable DSCGRP53 "DCS: LEARNED CARE BY TAKING GROUP CLASS";
label variable DSCONF53 "DCS: CONFIDENT TAKING CARE OF DIABETES";
label variable DSPRX53 "DCS: WAS RESPONDENT A PROXY";
label variable DDNWRK31 "# DAYS MISSED WORK DUE TO ILL/INJ (RD31)";
label variable DDNWRK42 "# DAYS MISSED WORK DUE TO ILL/INJ (RD42)";
label variable DDNWRK53 "# DAYS MISSED WORK DUE TO ILL/INJ (RD53)";
label variable WKINBD31 "# DAYS MISSED WORK STAYED IN BED (RD31)";
label variable WKINBD42 "# DAYS MISSED WORK STAYED IN BED (RD42)";
label variable WKINBD53 "# DAYS MISSED WORK STAYED IN BED (RD53)";
label variable DDNSCL31 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD31)";
label variable DDNSCL42 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD42)";
label variable DDNSCL53 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD53)";
label variable SCLNBD31 "# DAYS MISSED SCHOOL STAYD IN BED (RD31)";
label variable SCLNBD42 "# DAYS MISSED SCHOOL STAYD IN BED (RD42)";
label variable SCLNBD53 "# DAYS MISSED SCHOOL STAYD IN BED (RD53)";
label variable DDBDYS31 "# OTH DAY SPENT IN BED SINCE START(RD31)";
label variable DDBDYS42 "# OTH DAY SPENT IN BED SINCE START(RD42)";
label variable DDBDYS53 "# OTH DAY SPENT IN BED SINCE START(RD53)";
label variable OTHDYS31 "MISS ANY WORK DAY TO CARE FOR OTH (RD31)";
label variable OTHDYS42 "MISS ANY WORK DAY TO CARE FOR OTH (RD42)";
label variable OTHDYS53 "MISS ANY WORK DAY TO CARE FOR OTH (RD53)";
label variable OTHNDD31 "# DAY MISSED WORK TO CARE FOR OTH (RD31)";
label variable OTHNDD42 "# DAY MISSED WORK TO CARE FOR OTH (RD42)";
label variable OTHNDD53 "# DAY MISSED WORK TO CARE FOR OTH (RD53)";
label variable ACCELI42 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT-R4/2";
label variable LANGHM42 "AC01 LANGUAGE SPOKEN MOST IN HOME-R4/2";
label variable ENGCMF42 "AC02 WHOLE HH COMFRTBLE SPEAKNG ENG-R4/2";
label variable ENGSPK42 "AC02A NOT COMFRTBLE SPEAKNG ENGLISH-R4/2";
label variable USBORN42 "AC03 WAS PERSON BORN IN US-R4/2";
label variable USLIVE42 "AC04 # YRS PERSON LIVED IN US-R4/2";
label variable HAVEUS42 "AC05 DOES PERSON HAVE USC PROVIDER-R4/2";
label variable YNOUSC42 "AC07 MAIN REAS PERS DOESNT HAVE USC-R4/2";
label variable NOREAS42 "AC08 OTH REAS NO USC:NO OTH REASONS-R4/2";
label variable SELDSI42 "AC08 OTH REAS NO USC:SELDM/NEV SICK-R4/2";
label variable NEWARE42 "AC08 OTH REAS NO USC:RECENTLY MOVED-R4/2";
label variable DKWHRU42 "AC08 OTH REAS NO USC:DK WHERE TO GO-R4/2";
label variable USCNOT42 "AC08 OTH REAS NO USC: USC NOT AVAIL-R4/2";
label variable PERSLA42 "AC08 OTH REAS NO USC: LANGUAGE-R4/2";
label variable DIFFPL42 "AC08 OTH REAS NO USC:DIFFRNT PLACES-R4/2";
label variable INSRPL42 "AC08 OTH REAS NO USC:JUST CHNGD INS-R4/2";
label variable MYSELF42 "AC08 OTH REAS NO USC:NO DOC/TRT SLF-R4/2";
label variable CARECO42 "AC08 OTH REAS NO USC:COST OF MED CR-R4/2";
label variable NOHINS42 "AC08 OTH REAS NO USC:NO HLTH INSRNC-R4/2";
label variable OTHINS42 "AC08 OTH REAS NO USC: INS RELATED-R4/2";
label variable JOBRSN42 "AC08 OTH REAS NO USC: JOB RELATED-R4/2";
label variable NEWDOC42 "AC08 OTH REAS NO USC: LOOKNG FOR DR-R4/2";
label variable DOCELS42 "AC08 OTH REAS NO USC: DR ELSEWHERE-R4/2";
label variable NOLIKE42 "AC08 OTH REAS NO USC: DONT LIKE DRS-R4/2";
label variable KNOWDR42 "AC08 OTH REAS NO USC: KNOWS/IS A DR-R4/2";
label variable ONJOB42 "AC08 OTH REAS NO USC: DR AT WORK-R4/2";
label variable NOGODR42 "AC08 OTH REAS NO USC: WONT GO TO DR-R4/2";
label variable TRANS42 "AC08 OTH REAS NO USC: TRANSPRT/TIME-R4/2";
label variable CLINIC42 "AC08 OTH REAS NO USC: HOSP/ER/CLNIC-R4/2";
label variable OTHREA42 "AC08 OTH REAS NO USC: OTHER REASON-R4/2";
label variable PROVTY42 "PROVIDER TYPE-R4/2";
label variable PLCTYP42 "USC TYPE OF PLACE-R4/2";
label variable GOTOUS42 "AC12 HOW DOES PERS GET TO USC PROV-R4/2";
label variable TMTKUS42 "AC13 HOW LONG IT TAKES GET TO USC-R4/2";
label variable DFTOUS42 "AC14 HOW DIFFICULT IS IT GET TO USC-R4/2";
label variable TYPEPE42 "USC TYPE OF PROVIDER-R4/2";
label variable LOCATN42 "USC LOCATION-R4/2";
label variable HSPLAP42 "AC18 IS PROVIDER HISPANIC OR LATINO-R4/2";
label variable WHITPR42 "AC19 IS PROVIDER WHITE-R4/2";
label variable BLCKPR42 "AC19 IS PROVIDER BLACK/AFRICAN AMER-R4/2";
label variable ASIANP42 "AC19 IS PROVIDER ASIAN-R4/2";
label variable NATAMP42 "AC19 IS PROVIDER NATIVE AMERICAN-R4/2";
label variable PACISP42 "AC19 IS PROVIDER OTH PACIFIC ISLNDR-R4/2";
label variable OTHRCP42 "AC19 IS PROVIDER SOME OTHER RACE-R4/2";
label variable GENDRP42 "AC20 IS PROVIDER MALE OR FEMALE-R4/2";
label variable MINORP42 "AC22 GO TO USC FOR NEW HEALTH PROB-R4/2";
label variable PREVEN42 "AC22 GO TO USC FOR PRVNTVE HLT CARE-R4/2";
label variable REFFRL42 "AC22 GO TO USC FOR REFERRALS-R4/2";
label variable ONGONG42 "AC22 GO TO USC FOR ONGOING HLTH PRB-R4/2";
label variable PHNREG42 "AC23 HOW DIFF CONTACT USC BY PHONE-R4/2";
label variable OFFHOU42 "AC24 USC HAS OFFCE HRS NGHTS/WKENDS-R4/2";
label variable AFTHOU42 "AC25 HOW DIFF CONTACT USC AFT HOURS-R4/2";
label variable TREATM42 "AC26 PROV ASK ABOUT OTH TREATMENTS-R4/2";
label variable RESPCT42 "AC27 PROV SHOWS RESPECT FOR TRTMNTS-R4/2";
label variable DECIDE42 "AC28 PROV ASKS PERS TO HELP DECIDE-R4/2";
label variable EXPLOP42 "AC30 PROV EXPLNS OPTIONS TO PERS-R4/2";
label variable LANGPR42 "AC31 PROV SPEAKS PERSON S LANGUAGE-R4/2";
label variable MDUNAB42 "UNABLE TO GET NECESSRY MEDICAL CARE-R4/2";
label variable MDUNRS42 "AC34 RSN UNABLE GET NECSRY MED CARE-R4/2";
label variable MDUNPR42 "AC35 PRB NOT GETTING NCSRY MED CARE-R4/2";
label variable MDDLAY42 "DELAYED IN GETTING NECSRY MED CARE-R4/2";
label variable MDDLRS42 "AC38 RSN DLAYD GETTING NEC MED CARE-R4/2";
label variable MDDLPR42 "AC39 PRB DLAYD GETTING NEC MED CARE-R4/2";
label variable DNUNAB42 "UNABLE TO GET NECESSARY DENTAL CARE-R4/2";
label variable DNUNRS42 "AC42 RSN UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNUNPR42 "AC43 PRB UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNDLAY42 "DELAYED IN GETTING NEC DENTAL CARE-R4/2";
label variable DNDLRS42 "AC46 RSN DLAYD GETTNG NEC DENT CARE-R4/2";
label variable DNDLPR42 "AC47 PRB DLAYD GETTNG NEC DENT CARE-R4/2";
label variable PMUNAB42 "UNABLE TO GET NECESSARY PRES MED-R4/2";
label variable PMUNRS42 "AC50 RSN UNABLE TO GET NEC PRES MED-R4/2";
label variable PMUNPR42 "AC51 PRB UNABLE TO GET NEC PRES MED-R4/2";
label variable PMDLAY42 "DELAYED IN GETTING NECSRY PRES MED-R4/2";
label variable PMDLRS42 "AC54 RSN DLAYD GETTING NEC PRES MED-R4/2";
label variable PMDLPR42 "AC55 PRB DLAYD GETTING NEC PRES MED-R4/2";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/09";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED RD 3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED RD 4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED RD 5/3";
label variable DIFFWG31 "PERSONS WAGES DIFFERENT THIS RD31 AT CMJ";
label variable DIFFWG42 "PERSONS WAGES DIFFERENT THIS RD42 AT CMJ";
label variable DIFFWG53 "PERSONS WAGES DIFFERENT THIS RD53 AT CMJ";
label variable NHRWG31 "UPDATED HRLY WAGE RD 3/1 CMJ (EDITED)";
label variable NHRWG42 "UPDATED HRLY WAGE RD 4/2 CMJ (EDITED)";
label variable NHRWG53 "UPDATED HRLY WAGE RD 5/3 CMJ (EDITED)";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable TEMPJB31 "IS CMJ A TEMPORARY JOB RD 3/1";
label variable TEMPJB42 "IS CMJ A TEMPORARY JOB RD 4/2";
label variable TEMPJB53 "IS CMJ A TEMPORARY JOB RD 5/3";
label variable SSNLJB31 "IS CMJ A SEASONAL JOB RD 3/1";
label variable SSNLJB42 "IS CMJ A SEASONAL JOB RD 4/2";
label variable SSNLJB53 "IS CMJ A SEASONAL JOB RD 5/3";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT RD 3/1 CMJ (ED)";
label variable DISVW42X "DISAVOWED HEALTH INS AT RD 4/2 CMJ (ED)";
label variable DISVW53X "DISAVOWED HEALTH INS AT RD 5/3 CMJ (ED)";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable INDCAT31 "INDUSTRY GROUP RD 3/1 CMJ";
label variable INDCAT42 "INDUSTRY GROUP RD 4/2 CMJ";
label variable INDCAT53 "INDUSTRY GROUP RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBDD31 "DAY STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBDD42 "DAY STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBDD53 "DAY STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable OCCCAT31 "OCCUPATION GROUP RD 3/1 CMJ";
label variable OCCCAT42 "OCCUPATION GROUP RD 4/2 CMJ";
label variable OCCCAT53 "OCCUPATION GROUP RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSUR HELD FROM RD 3/1 CMJ (ED)";
label variable HELD42X "HEALTH INSUR HELD FROM RD 4/2 CMJ (ED)";
label variable HELD53X "HEALTH INSUR HELD FROM RD 5/3 CMJ (ED)";
label variable OFFER31X "HEALTH INSUR OFFERED BY RD 3/1 CMJ (ED)";
label variable OFFER42X "HEALTH INSUR OFFERED BY RD 4/2 CMJ (ED)";
label variable OFFER53X "HEALTH INSUR OFFERED BY RD 5/3 CMJ (ED)";
label variable OFREMP31 "EMPLOYER OFFERS HEALTH INS RD 3/1 CMJ";
label variable OFREMP42 "EMPLOYER OFFERS HEALTH INS RD 4/2 CMJ";
label variable OFREMP53 "EMPLOYER OFFERS HEALTH INS RD 5/3 CMJ";
label variable YNOINS31 "WHY NOT ELIGIBLE HEALTH INS RD 3/1 CMJ";
label variable YNOINS42 "WHY NOT ELIGIBLE HEALTH INS RD 4/2 CMJ";
label variable YNOINS53 "WHY NOT ELIGIBLE HEALTH INS RD 5/3 CMJ";
label variable SSIDIS09 "SSI RECEIPT DUE TO DISABILITY";
label variable AFDC09 "DID PERSON S CHECK INCLUDE TANF";
label variable FILEDR09 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL09 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT09 "PERSON S FILING STATUS";
label variable FILER09 "PRIMARY OR SECONDARY FILER";
label variable JTINRU09 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID09 "PID OF SECONDARY FILER";
label variable CLMDEP09 "DID/WILL PERS CLAIM DEPENDENTS ON RETURN";
label variable DEPDNT09 "PERSON IS FLAGGED A DEPENDENT";
label variable DPINRU09 "DEPENDENTS IN/OUT OF RU";
label variable DPOTSD09 "HOW MANY DEPENDENTS LIVE OUTSIDE RU";
label variable TAXFRM09 "TAX FORM PERSON WILL FILE";
label variable DEDUCT09 "ITEMIZE OR STANDARD DEDUCTION";
label variable TOTDED09 "TOTAL OF ALL ITEMIZED DEDUCTIONS";
label variable CLMHIP09 "DID/WILL PERS DEDUCT HEALTH INSUR. PREM.";
label variable EICRDT09 "DID/WILL PERS RECEIVE EARNED INC CREDIT";
label variable FOODST09 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN09 "NUMBER OF MONTHS FOOD STAMPS PURCHASED";
label variable FOODVL09 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP09X "PERSON S TOTAL INCOME";
label variable FAMINC09 "FAMILY S TOTAL INCOME";
label variable POVCAT09 "FAMILY INC AS % OF POVERTY LINE - CATEGO";
label variable POVLEV09 "FAMILY INC AS % OF POVERTY LINE - CONTIN";
label variable WAGEP09X "PERSON S WAGE INCOME";
label variable WAGIMP09 "WAGE IMPUTATION FLAG";
label variable BUSNP09X "PERSON S BUSINESS INCOME";
label variable BUSIMP09 "BUSINESS INCOME IMPUTATION FLAG";
label variable UNEMP09X "PERSON S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP09 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP09X "PERSON S WORKERS  COMPENSATION";
label variable WCPIMP09 "WORKERS  COMP IMPUTATION FLAG";
label variable INTRP09X "PERSON S INTEREST INCOME";
label variable INTIMP09 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP09X "PERSON S DIVIDEND INCOME";
label variable DIVIMP09 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP09X "PERSON S SALES INCOME";
label variable SALIMP09 "SALES INCOME IMPUTATION FLAG";
label variable PENSP09X "PERSON S PENSION INCOME";
label variable PENIMP09 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP09X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP09 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP09X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP09 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP09X "PERSON S VETERAN S INCOME";
label variable VETIMP09 "VETERAN S INCOME IMPUTATION FLAG";
label variable IRASP09X "PERSON S IRA INCOME";
label variable IRAIMP09 "IRA INCOME IMPUTATION FLAG";
label variable REFDP09X "PERSON S REFUND INCOME";
label variable REFIMP09 "REFUND INCOME IMPUTATION FLAG";
label variable ALIMP09X "PERSON S ALIMONY INCOME";
label variable ALIIMP09 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP09X "PERSON S CHILD SUPPORT";
label variable CHLIMP09 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP09X "PERSON S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP09 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP09X "PERSON S SSI";
label variable SSIIMP09 "SSI IMPUTATION FLAG";
label variable PUBP09X "PERSON S PUBLIC ASSISTANCE";
label variable PUBIMP09 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP09X "PERSON S OTHER INCOME";
label variable OTHIMP09 "OTHER INCOME IMPUTATION FLAG";
label variable TRIJA09X "COVERED BY TRICARE/CHAMPVA IN JAN09 (ED)";
label variable TRIFE09X "COVERED BY TRICARE/CHAMPVA IN FEB09 (ED)";
label variable TRIMA09X "COVERED BY TRICARE/CHAMPVA IN MAR09 (ED)";
label variable TRIAP09X "COVERED BY TRICARE/CHAMPVA IN APR09 (ED)";
label variable TRIMY09X "COVERED BY TRICARE/CHAMPVA IN MAY09 (ED)";
label variable TRIJU09X "COVERED BY TRICARE/CHAMPVA IN JUN09 (ED)";
label variable TRIJL09X "COVERED BY TRICARE/CHAMPVA IN JUL09 (ED)";
label variable TRIAU09X "COVERED BY TRICARE/CHAMPVA IN AUG09 (ED)";
label variable TRISE09X "COVERED BY TRICARE/CHAMPVA IN SEP09 (ED)";
label variable TRIOC09X "COVERED BY TRICARE/CHAMPVA IN OCT09 (ED)";
label variable TRINO09X "COVERED BY TRICARE/CHAMPVA IN NOV09 (ED)";
label variable TRIDE09X "COVERED BY TRICARE/CHAMPVA IN DEC09 (ED)";
label variable MCRJA09 "COVERED BY MEDICARE IN JAN09";
label variable MCRFE09 "COVERED BY MEDICARE IN FEB09";
label variable MCRMA09 "COVERED BY MEDICARE IN MAR09";
label variable MCRAP09 "COVERED BY MEDICARE IN APR09";
label variable MCRMY09 "COVERED BY MEDICARE IN MAY09";
label variable MCRJU09 "COVERED BY MEDICARE IN JUN09";
label variable MCRJL09 "COVERED BY MEDICARE IN JUL09";
label variable MCRAU09 "COVERED BY MEDICARE IN AUG09";
label variable MCRSE09 "COVERED BY MEDICARE IN SEP09";
label variable MCROC09 "COVERED BY MEDICARE IN OCT09";
label variable MCRNO09 "COVERED BY MEDICARE IN NOV09";
label variable MCRDE09 "COVERED BY MEDICARE IN DEC09";
label variable MCRJA09X "COVERED BY MEDICARE IN JAN09 (ED)";
label variable MCRFE09X "COVERED BY MEDICARE IN FEB09 (ED)";
label variable MCRMA09X "COVERED BY MEDICARE IN MAR09 (ED)";
label variable MCRAP09X "COVERED BY MEDICARE IN APR09 (ED)";
label variable MCRMY09X "COVERED BY MEDICARE IN MAY09 (ED)";
label variable MCRJU09X "COVERED BY MEDICARE IN JUN09 (ED)";
label variable MCRJL09X "COVERED BY MEDICARE IN JUL09 (ED)";
label variable MCRAU09X "COVERED BY MEDICARE IN AUG09 (ED)";
label variable MCRSE09X "COVERED BY MEDICARE IN SEP09 (ED)";
label variable MCROC09X "COVERED BY MEDICARE IN OCT09 (ED)";
label variable MCRNO09X "COVERED BY MEDICARE IN NOV09 (ED)";
label variable MCRDE09X "COVERED BY MEDICARE IN DEC09 (ED)";
label variable MCDJA09 "COV BY MEDICAID OR SCHIP IN JAN09";
label variable MCDFE09 "COV BY MEDICAID OR SCHIP IN FEB09";
label variable MCDMA09 "COV BY MEDICAID OR SCHIP IN MAR09";
label variable MCDAP09 "COV BY MEDICAID OR SCHIP IN APR09";
label variable MCDMY09 "COV BY MEDICAID OR SCHIP IN MAY09";
label variable MCDJU09 "COV BY MEDICAID OR SCHIP IN JUN09";
label variable MCDJL09 "COV BY MEDICAID OR SCHIP IN JUL09";
label variable MCDAU09 "COV BY MEDICAID OR SCHIP IN AUG09";
label variable MCDSE09 "COV BY MEDICAID OR SCHIP IN SEP09";
label variable MCDOC09 "COV BY MEDICAID OR SCHIP IN OCT09";
label variable MCDNO09 "COV BY MEDICAID OR SCHIP IN NOV09";
label variable MCDDE09 "COV BY MEDICAID OR SCHIP IN DEC09";
label variable MCDJA09X "COV BY MEDICAID OR SCHIP IN JAN09 (ED)";
label variable MCDFE09X "COV BY MEDICAID OR SCHIP IN FEB09 (ED)";
label variable MCDMA09X "COV BY MEDICAID OR SCHIP IN MAR09 (ED)";
label variable MCDAP09X "COV BY MEDICAID OR SCHIP IN APR09 (ED)";
label variable MCDMY09X "COV BY MEDICAID OR SCHIP IN MAY09 (ED)";
label variable MCDJU09X "COV BY MEDICAID OR SCHIP IN JUN09 (ED)";
label variable MCDJL09X "COV BY MEDICAID OR SCHIP IN JUL09 (ED)";
label variable MCDAU09X "COV BY MEDICAID OR SCHIP IN AUG09 (ED)";
label variable MCDSE09X "COV BY MEDICAID OR SCHIP IN SEP09 (ED)";
label variable MCDOC09X "COV BY MEDICAID OR SCHIP IN OCT09 (ED)";
label variable MCDNO09X "COV BY MEDICAID OR SCHIP IN NOV09 (ED)";
label variable MCDDE09X "COV BY MEDICAID OR SCHIP IN DEC09 (ED)";
label variable OPAJA09 "COV BY OTHER PUBLIC A INS IN JAN09";
label variable OPAFE09 "COV BY OTHER PUBLIC A INS IN FEB09";
label variable OPAMA09 "COV BY OTHER PUBLIC A INS IN MAR09";
label variable OPAAP09 "COV BY OTHER PUBLIC A INS IN APR09";
label variable OPAMY09 "COV BY OTHER PUBLIC A INS IN MAY09";
label variable OPAJU09 "COV BY OTHER PUBLIC A INS IN JUN09";
label variable OPAJL09 "COV BY OTHER PUBLIC A INS IN JUL09";
label variable OPAAU09 "COV BY OTHER PUBLIC A INS IN AUG09";
label variable OPASE09 "COV BY OTHER PUBLIC A INS IN SEP09";
label variable OPAOC09 "COV BY OTHER PUBLIC A INS IN OCT09";
label variable OPANO09 "COV BY OTHER PUBLIC A INS IN NOV09";
label variable OPADE09 "COV BY OTHER PUBLIC A INS IN DEC09";
label variable OPBJA09 "COV BY OTHER PUBLIC B INS IN JAN09";
label variable OPBFE09 "COV BY OTHER PUBLIC B INS IN FEB09";
label variable OPBMA09 "COV BY OTHER PUBLIC B INS IN MAR09";
label variable OPBAP09 "COV BY OTHER PUBLIC B INS IN APR09";
label variable OPBMY09 "COV BY OTHER PUBLIC B INS IN MAY09";
label variable OPBJU09 "COV BY OTHER PUBLIC B INS IN JUN09";
label variable OPBJL09 "COV BY OTHER PUBLIC B INS IN JUL09";
label variable OPBAU09 "COV BY OTHER PUBLIC B INS IN AUG09";
label variable OPBSE09 "COV BY OTHER PUBLIC B INS IN SEP09";
label variable OPBOC09 "COV BY OTHER PUBLIC B INS IN OCT09";
label variable OPBNO09 "COV BY OTHER PUBLIC B INS IN NOV09";
label variable OPBDE09 "COV BY OTHER PUBLIC B INS IN DEC09";
label variable STAJA09 "COVERED BY OTHER STATE PROG IN JAN09";
label variable STAFE09 "COVERED BY OTHER STATE PROG IN FEB09";
label variable STAMA09 "COVERED BY OTHER STATE PROG IN MAR09";
label variable STAAP09 "COVERED BY OTHER STATE PROG IN APR09";
label variable STAMY09 "COVERED BY OTHER STATE PROG IN MAY09";
label variable STAJU09 "COVERED BY OTHER STATE PROG IN JUN09";
label variable STAJL09 "COVERED BY OTHER STATE PROG IN JUL09";
label variable STAAU09 "COVERED BY OTHER STATE PROG IN AUG09";
label variable STASE09 "COVERED BY OTHER STATE PROG IN SEP09";
label variable STAOC09 "COVERED BY OTHER STATE PROG IN OCT09";
label variable STANO09 "COVERED BY OTHER STATE PROG IN NOV09";
label variable STADE09 "COVERED BY OTHER STATE PROG IN DEC09";
label variable PUBJA09X "COVR BY ANY PUBLIC INS IN JAN09 (ED)";
label variable PUBFE09X "COVR BY ANY PUBLIC INS IN FEB09 (ED)";
label variable PUBMA09X "COVR BY ANY PUBLIC INS IN MAR09 (ED)";
label variable PUBAP09X "COVR BY ANY PUBLIC INS IN APR09 (ED)";
label variable PUBMY09X "COVR BY ANY PUBLIC INS IN MAY09 (ED)";
label variable PUBJU09X "COVR BY ANY PUBLIC INS IN JUN09 (ED)";
label variable PUBJL09X "COVR BY ANY PUBLIC INS IN JUL09 (ED)";
label variable PUBAU09X "COVR BY ANY PUBLIC INS IN AUG09 (ED)";
label variable PUBSE09X "COVR BY ANY PUBLIC INS IN SEP09 (ED)";
label variable PUBOC09X "COVR BY ANY PUBLIC INS IN OCT09 (ED)";
label variable PUBNO09X "COVR BY ANY PUBLIC INS IN NOV09 (ED)";
label variable PUBDE09X "COVR BY ANY PUBLIC INS IN DEC09 (ED)";
label variable PEGJA09 "COVERED BY EMPL UNION INS IN JAN09";
label variable PEGFE09 "COVERED BY EMPL UNION INS IN FEB09";
label variable PEGMA09 "COVERED BY EMPL UNION INS IN MAR09";
label variable PEGAP09 "COVERED BY EMPL UNION INS IN APR09";
label variable PEGMY09 "COVERED BY EMPL UNION INS IN MAY09";
label variable PEGJU09 "COVERED BY EMPL UNION INS IN JUN09";
label variable PEGJL09 "COVERED BY EMPL UNION INS IN JUL09";
label variable PEGAU09 "COVERED BY EMPL UNION INS IN AUG09";
label variable PEGSE09 "COVERED BY EMPL UNION INS IN SEP09";
label variable PEGOC09 "COVERED BY EMPL UNION INS IN OCT09";
label variable PEGNO09 "COVERED BY EMPL UNION INS IN NOV09";
label variable PEGDE09 "COVERED BY EMPL UNION INS IN DEC09";
label variable PDKJA09 "COVR BY PRIV INS (SOURCE UNKNWN) JAN09";
label variable PDKFE09 "COVR BY PRIV INS (SOURCE UNKNWN) FEB09";
label variable PDKMA09 "COVR BY PRIV INS (SOURCE UNKNWN) MAR09";
label variable PDKAP09 "COVR BY PRIV INS (SOURCE UNKNWN) APR09";
label variable PDKMY09 "COVR BY PRIV INS (SOURCE UNKNWN) MAY09";
label variable PDKJU09 "COVR BY PRIV INS (SOURCE UNKNWN) JUN09";
label variable PDKJL09 "COVR BY PRIV INS (SOURCE UNKNWN) JUL09";
label variable PDKAU09 "COVR BY PRIV INS (SOURCE UNKNWN) AUG09";
label variable PDKSE09 "COVR BY PRIV INS (SOURCE UNKNWN) SEP09";
label variable PDKOC09 "COVR BY PRIV INS (SOURCE UNKNWN) OCT09";
label variable PDKNO09 "COVR BY PRIV INS (SOURCE UNKNWN) NOV09";
label variable PDKDE09 "COVR BY PRIV INS (SOURCE UNKNWN) DEC09";
label variable PNGJA09 "COVERED BY NONGROUP INS IN JAN09";
label variable PNGFE09 "COVERED BY NONGROUP INS IN FEB09";
label variable PNGMA09 "COVERED BY NONGROUP INS IN MAR09";
label variable PNGAP09 "COVERED BY NONGROUP INS IN APR09";
label variable PNGMY09 "COVERED BY NONGROUP INS IN MAY09";
label variable PNGJU09 "COVERED BY NONGROUP INS IN JUN09";
label variable PNGJL09 "COVERED BY NONGROUP INS IN JUL09";
label variable PNGAU09 "COVERED BY NONGROUP INS IN AUG09";
label variable PNGSE09 "COVERED BY NONGROUP INS IN SEP09";
label variable PNGOC09 "COVERED BY NONGROUP INS IN OCT09";
label variable PNGNO09 "COVERED BY NONGROUP INS IN NOV09";
label variable PNGDE09 "COVERED BY NONGROUP INS IN DEC09";
label variable POGJA09 "COVERED BY OTHER GROUP INS IN JAN09";
label variable POGFE09 "COVERED BY OTHER GROUP INS IN FEB09";
label variable POGMA09 "COVERED BY OTHER GROUP INS IN MAR09";
label variable POGAP09 "COVERED BY OTHER GROUP INS IN APR09";
label variable POGMY09 "COVERED BY OTHER GROUP INS IN MAY09";
label variable POGJU09 "COVERED BY OTHER GROUP INS IN JUN09";
label variable POGJL09 "COVERED BY OTHER GROUP INS IN JUL09";
label variable POGAU09 "COVERED BY OTHER GROUP INS IN AUG09";
label variable POGSE09 "COVERED BY OTHER GROUP INS IN SEP09";
label variable POGOC09 "COVERED BY OTHER GROUP INS IN OCT09";
label variable POGNO09 "COVERED BY OTHER GROUP INS IN NOV09";
label variable POGDE09 "COVERED BY OTHER GROUP INS IN DEC09";
label variable PRSJA09 "COVERED BY SELF-EMP-1 INS IN JAN09";
label variable PRSFE09 "COVERED BY SELF-EMP-1 INS IN FEB09";
label variable PRSMA09 "COVERED BY SELF-EMP-1 INS IN MAR09";
label variable PRSAP09 "COVERED BY SELF-EMP-1 INS IN APR09";
label variable PRSMY09 "COVERED BY SELF-EMP-1 INS IN MAY09";
label variable PRSJU09 "COVERED BY SELF-EMP-1 INS IN JUN09";
label variable PRSJL09 "COVERED BY SELF-EMP-1 INS IN JUL09";
label variable PRSAU09 "COVERED BY SELF-EMP-1 INS IN AUG09";
label variable PRSSE09 "COVERED BY SELF-EMP-1 INS IN SEP09";
label variable PRSOC09 "COVERED BY SELF-EMP-1 INS IN OCT09";
label variable PRSNO09 "COVERED BY SELF-EMP-1 INS IN NOV09";
label variable PRSDE09 "COVERED BY SELF-EMP-1 INS IN DEC09";
label variable POUJA09 "COVERED BY HOLDER OUTSIDE OF RU IN JAN09";
label variable POUFE09 "COVERED BY HOLDER OUTSIDE OF RU IN FEB09";
label variable POUMA09 "COVERED BY HOLDER OUTSIDE OF RU IN MAR09";
label variable POUAP09 "COVERED BY HOLDER OUTSIDE OF RU IN APR09";
label variable POUMY09 "COVERED BY HOLDER OUTSIDE OF RU IN MAY09";
label variable POUJU09 "COVERED BY HOLDER OUTSIDE OF RU IN JUN09";
label variable POUJL09 "COVERED BY HOLDER OUTSIDE OF RU IN JUL09";
label variable POUAU09 "COVERED BY HOLDER OUTSIDE OF RU IN AUG09";
label variable POUSE09 "COVERED BY HOLDER OUTSIDE OF RU IN SEP09";
label variable POUOC09 "COVERED BY HOLDER OUTSIDE OF RU IN OCT09";
label variable POUNO09 "COVERED BY HOLDER OUTSIDE OF RU IN NOV09";
label variable POUDE09 "COVERED BY HOLDER OUTSIDE OF RU IN DEC09";
label variable PRIJA09 "COVERED BY PRIVATE INS IN JAN09";
label variable PRIFE09 "COVERED BY PRIVATE INS IN FEB09";
label variable PRIMA09 "COVERED BY PRIVATE INS IN MAR09";
label variable PRIAP09 "COVERED BY PRIVATE INS IN APR09";
label variable PRIMY09 "COVERED BY PRIVATE INS IN MAY09";
label variable PRIJU09 "COVERED BY PRIVATE INS IN JUN09";
label variable PRIJL09 "COVERED BY PRIVATE INS IN JUL09";
label variable PRIAU09 "COVERED BY PRIVATE INS IN AUG09";
label variable PRISE09 "COVERED BY PRIVATE INS IN SEP09";
label variable PRIOC09 "COVERED BY PRIVATE INS IN OCT09";
label variable PRINO09 "COVERED BY PRIVATE INS IN NOV09";
label variable PRIDE09 "COVERED BY PRIVATE INS IN DEC09";
label variable HPEJA09 "HOLDER OF EMPL UNION INS IN JAN09";
label variable HPEFE09 "HOLDER OF EMPL UNION INS IN FEB09";
label variable HPEMA09 "HOLDER OF EMPL UNION INS IN MAR09";
label variable HPEAP09 "HOLDER OF EMPL UNION INS IN APR09";
label variable HPEMY09 "HOLDER OF EMPL UNION INS IN MAY09";
label variable HPEJU09 "HOLDER OF EMPL UNION INS IN JUN09";
label variable HPEJL09 "HOLDER OF EMPL UNION INS IN JUL09";
label variable HPEAU09 "HOLDER OF EMPL UNION INS IN AUG09";
label variable HPESE09 "HOLDER OF EMPL UNION INS IN SEP09";
label variable HPEOC09 "HOLDER OF EMPL UNION INS IN OCT09";
label variable HPENO09 "HOLDER OF EMPL UNION INS IN NOV09";
label variable HPEDE09 "HOLDER OF EMPL UNION INS IN DEC09";
label variable HPDJA09 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN09";
label variable HPDFE09 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB09";
label variable HPDMA09 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR09";
label variable HPDAP09 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR09";
label variable HPDMY09 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY09";
label variable HPDJU09 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN09";
label variable HPDJL09 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL09";
label variable HPDAU09 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG09";
label variable HPDSE09 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP09";
label variable HPDOC09 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT09";
label variable HPDNO09 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV09";
label variable HPDDE09 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC09";
label variable HPNJA09 "HOLDER OF NONGROUP INS IN JAN09";
label variable HPNFE09 "HOLDER OF NONGROUP INS IN FEB09";
label variable HPNMA09 "HOLDER OF NONGROUP INS IN MAR09";
label variable HPNAP09 "HOLDER OF NONGROUP INS IN APR09";
label variable HPNMY09 "HOLDER OF NONGROUP INS IN MAY09";
label variable HPNJU09 "HOLDER OF NONGROUP INS IN JUN09";
label variable HPNJL09 "HOLDER OF NONGROUP INS IN JUL09";
label variable HPNAU09 "HOLDER OF NONGROUP INS IN AUG09";
label variable HPNSE09 "HOLDER OF NONGROUP INS IN SEP09";
label variable HPNOC09 "HOLDER OF NONGROUP INS IN OCT09";
label variable HPNNO09 "HOLDER OF NONGROUP INS IN NOV09";
label variable HPNDE09 "HOLDER OF NONGROUP INS IN DEC09";
label variable HPOJA09 "HOLDER OF OTHER GROUP INS IN JAN09";
label variable HPOFE09 "HOLDER OF OTHER GROUP INS IN FEB09";
label variable HPOMA09 "HOLDER OF OTHER GROUP INS IN MAR09";
label variable HPOAP09 "HOLDER OF OTHER GROUP INS IN APR09";
label variable HPOMY09 "HOLDER OF OTHER GROUP INS IN MAY09";
label variable HPOJU09 "HOLDER OF OTHER GROUP INS IN JUN09";
label variable HPOJL09 "HOLDER OF OTHER GROUP INS IN JUL09";
label variable HPOAU09 "HOLDER OF OTHER GROUP INS IN AUG09";
label variable HPOSE09 "HOLDER OF OTHER GROUP INS IN SEP09";
label variable HPOOC09 "HOLDER OF OTHER GROUP INS IN OCT09";
label variable HPONO09 "HOLDER OF OTHER GROUP INS IN NOV09";
label variable HPODE09 "HOLDER OF OTHER GROUP INS IN DEC09";
label variable HPSJA09 "HOLDER OF SELF-EMP-1 INS IN JAN09";
label variable HPSFE09 "HOLDER OF SELF-EMP-1 INS IN FEB09";
label variable HPSMA09 "HOLDER OF SELF-EMP-1 INS IN MAR09";
label variable HPSAP09 "HOLDER OF SELF-EMP-1 INS IN APR09";
label variable HPSMY09 "HOLDER OF SELF-EMP-1 INS IN MAY09";
label variable HPSJU09 "HOLDER OF SELF-EMP-1 INS IN JUN09";
label variable HPSJL09 "HOLDER OF SELF-EMP-1 INS IN JUL09";
label variable HPSAU09 "HOLDER OF SELF-EMP-1 INS IN AUG09";
label variable HPSSE09 "HOLDER OF SELF-EMP-1 INS IN SEP09";
label variable HPSOC09 "HOLDER OF SELF-EMP-1 INS IN OCT09";
label variable HPSNO09 "HOLDER OF SELF-EMP-1 INS IN NOV09";
label variable HPSDE09 "HOLDER OF SELF-EMP-1 INS IN DEC09";
label variable HPRJA09 "HOLDER OF PRIVATE INSURANCE IN JAN09";
label variable HPRFE09 "HOLDER OF PRIVATE INSURANCE IN FEB09";
label variable HPRMA09 "HOLDER OF PRIVATE INSURANCE IN MAR09";
label variable HPRAP09 "HOLDER OF PRIVATE INSURANCE IN APR09";
label variable HPRMY09 "HOLDER OF PRIVATE INSURANCE IN MAY09";
label variable HPRJU09 "HOLDER OF PRIVATE INSURANCE IN JUN09";
label variable HPRJL09 "HOLDER OF PRIVATE INSURANCE IN JUL09";
label variable HPRAU09 "HOLDER OF PRIVATE INSURANCE IN AUG09";
label variable HPRSE09 "HOLDER OF PRIVATE INSURANCE IN SEP09";
label variable HPROC09 "HOLDER OF PRIVATE INSURANCE IN OCT09";
label variable HPRNO09 "HOLDER OF PRIVATE INSURANCE IN NOV09";
label variable HPRDE09 "HOLDER OF PRIVATE INSURANCE IN DEC09";
label variable INSJA09X "COVR BY HOSP/MED INS IN JAN09 (ED)";
label variable INSFE09X "COVR BY HOSP/MED INS IN FEB09 (ED)";
label variable INSMA09X "COVR BY HOSP/MED INS IN MAR09 (ED)";
label variable INSAP09X "COVR BY HOSP/MED INS IN APR09 (ED)";
label variable INSMY09X "COVR BY HOSP/MED INS IN MAY09 (ED)";
label variable INSJU09X "COVR BY HOSP/MED INS IN JUN09 (ED)";
label variable INSJL09X "COVR BY HOSP/MED INS IN JUL09 (ED)";
label variable INSAU09X "COVR BY HOSP/MED INS IN AUG09 (ED)";
label variable INSSE09X "COVR BY HOSP/MED INS IN SEP09 (ED)";
label variable INSOC09X "COVR BY HOSP/MED INS IN OCT09 (ED)";
label variable INSNO09X "COVR BY HOSP/MED INS IN NOV09 (ED)";
label variable INSDE09X "COVR BY HOSP/MED INS IN DEC09 (ED)";
label variable PRVEV09 "EVER HAVE PRIVATE INSURANCE DURING 09";
label variable TRIEV09 "EVER HAVE TRICARE/CHAMPVA DURING 09";
label variable MCREV09 "EVER HAVE MEDICARE DURING 09 (ED)";
label variable MCDEV09 "EVER HAVE MEDICAID/SCHIP DURING 09 (ED)";
label variable OPAEV09 "EVER HAVE OTHER PUBLIC A INS DURING 09";
label variable OPBEV09 "EVER HAVE OTHER PUBLIC B INS DURING 09";
label variable UNINS09 "UNINSURED ALL OF 09";
label variable INSCOV09 "HEALTH INSURANCE COVERAGE INDICATOR 09";
label variable TRIST31X "COVERED BY TRICARE STANDARD - R3/1";
label variable TRIST42X "COVERED BY TRICARE STANDARD - R4/2";
label variable TRIST09X "COVERED BY TRICARE STANDARD - 12/31/09";
label variable TRIPR31X "COVERED BY TRICARE PRIME - R3/1";
label variable TRIPR42X "COVERED BY TRICARE PRIME - R4/2";
label variable TRIPR09X "COVERED BY TRICARE PRIME - 12/31/09";
label variable TRIEX31X "COVERED BY TRICARE EXTRA - R3/1";
label variable TRIEX42X "COVERED BY TRICARE EXTRA - R4/2";
label variable TRIEX09X "COVERED BY TRICARE EXTRA - 12/31/09";
label variable TRILI31X "COVERED BY TRICARE FOR LIFE - R3/1";
label variable TRILI42X "COVERED BY TRICARE FOR LIFE - R4/2";
label variable TRILI09X "COVERED BY TRICARE FOR LIFE - 12/31/09";
label variable TRICH31X "COVERED BY TRICARE CHAMPVA - R3/1";
label variable TRICH42X "COVERED BY TRICARE CHAMPVA - R4/2";
label variable TRICH09X "COVERED BY TRICARE CHAMPVA - 12/31/09";
label variable MCRPD31 "COV BY MEDICARE PMED BENEFIT - R3/1";
label variable MCRPD42 "COV BY MEDICARE PMED BENEFIT - R4/2";
label variable MCRPD09 "COV BY MEDICARE PMED BENEFIT - 12/31/09";
label variable MCRPD31X "COV BY MEDICARE PMED BENEFIT - R3/1 (ED)";
label variable MCRPD42X "COV BY MEDICARE PMED BENEFIT - R4/2 (ED)";
label variable MCRPD09X "COV BY MCARE PMED BENEFIT-12/31/09 (ED)";
label variable MCRPB31 "COV BY MEDICARE PART B - R3/1";
label variable MCRPB42 "COV BY MEDICARE PART B - R4/2";
label variable MCRPB09 "COV BY MEDICARE PART B - 12/31/09";
label variable MCRPHO31 "COV BY MEDICARE MANAGED CARE - R3/1";
label variable MCRPHO42 "COV BY MEDICARE MANAGED CARE - R4/2";
label variable MCRPHO09 "COV BY MEDICARE MANAGED CARE - 12/31/09";
label variable MCDHMO31 "COVERED BY MEDICAID OR SCHIP HMO - R3/1";
label variable MCDHMO42 "COVERED BY MEDICAID OR SCHIP HMO - R4/2";
label variable MCDHMO09 "COVRED BY MEDICAID OR SCHIP HMO-12/31/09";
label variable MCDMC31 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R3/1";
label variable MCDMC42 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R4/2";
label variable MCDMC09 "COV BY MCAID/SCHIP GTKEEPR PLAN-12/31/09";
label variable PRVHMO31 "COVERED BY PRIVATE HMO - R3/1";
label variable PRVHMO42 "COVERED BY PRIVATE HMO - R4/2";
label variable PRVHMO09 "COVERED BY PRIVATE HMO - 12/31/09";
label variable PRVMNC31 "COVERED BY PRIVATE GATEKEEPER PLAN-R3/1";
label variable PRVMNC42 "COVERED BY PRIVATE GATEKEEPER PLAN-R4/2";
label variable PRVMNC09 "COVERED BY PRIV GATEKEEPER PLAN-12/31/09";
label variable PRVDRL31 "COV BY PRIV PLAN W/DOCTOR LIST - R3/1";
label variable PRVDRL42 "COV BY PRIV PLAN W/DOCTOR LIST - R4/2";
label variable PRVDRL09 "COV BY PRIV PLAN W/DOCTOR LIST-12/31/09";
label variable PHMONP31 "COV BY HMO-PAYS NON-PLAN DR VISITS-R3/1";
label variable PHMONP42 "COV BY HMO-PAYS NON-PLAN DR VISITS-R4/2";
label variable PHMONP09 "COV BY HMO-PAYS NON-PLAN DRS - 12/31/09";
label variable PMNCNP31 "COV BY GATEKPR-PAYS NON-PLAN DRS-R3/1";
label variable PMNCNP42 "COV BY GATEKPR-PAYS NON-PLAN DRS-R4/2";
label variable PMNCNP09 "COV BY GATEKP-PAYS NON-PLAN DRS-12/31/09";
label variable PRDRNP31 "COV BY DR LIST-PAYS NON-PLAN DRS-R3/1";
label variable PRDRNP42 "COV BY DR LIST-PAYS NON-PLAN DRS-R4/2";
label variable PRDRNP09 "COV BY DR LIST-PAYS NON-PLAN DR-12/31/09";
label variable PREVCOVR "PER COV BY INS IN PREV 2 YRS-PNL 14 ONLY";
label variable COVRMM "MONTH MOST RECENTLY COVERED-PNL 14 ONLY";
label variable COVRYY "YEAR MOST RECENTLY COVERED-PANEL 14 ONLY";
label variable WASESTB "WAS PREV INS BY EMPL OR UNION-PN 14 ONLY";
label variable WASMCARE "WAS PREV INS BY MEDICARE-PANEL 14 ONLY";
label variable WASMCAID "WAS PREV INS BY MCAID/SCHIP-PNL 14 ONLY";
label variable WASCHAMP "WAS PREV INS TRICARE/CHAMPVA-PNL 14 ONLY";
label variable WASVA "WAS PREV INS VA/MILITAR CARE-PNL 14 ONLY";
label variable WASPRIV "WAS PREV INS GRP/ASSOC/INS CO-PN 14 ONLY";
label variable WASOTGOV "WAS PREV INS BY OTH GOV PRG-PNL 14 ONLY";
label variable WASAFDC "WAS PREV INS BY PUBLIC AFDC-PNL 14 ONLY";
label variable WASSSI "WAS PREV INS BY SSI PROGRAM-PNL 14 ONLY";
label variable WASSTAT1 "WAS PREV INS BY STAT PROG 1-PNL 14 ONLY";
label variable WASSTAT2 "WAS PREV INS BY STAT PROG 2-PNL 14 ONLY";
label variable WASSTAT3 "WAS PREV INS BY STAT PROG 3-PNL 14 ONLY";
label variable WASSTAT4 "WAS PREV INS BY STAT PROG 4-PNL 14 ONLY";
label variable WASOTHER "WAS PREV INS BY OTH SOURCE-PANEL 14 ONLY";
label variable NOINSBEF "EVR WOUT HLTH INSR PREV YR-PANEL 14 ONLY";
label variable NOINSTM "# WKS/MON WOUT HLTH INS PRV YR-PN 14 ONL";
label variable NOINUNIT "UNIT OF TIME WOUT HLTH INS-PANEL 14 ONLY";
label variable MORECOVR "COV BY MOR COMPR PL PREV 2 YR-PN 14 ONLY";
label variable INSENDMM "MONTH MOST RECENTLY COVD-PANEL 14 ONLY";
label variable INSENDYY "YEAR MOST RECENTLY COVD-PANEL 14 ONLY";
label variable TRICR31X "COV BY TRICR/CHAMV - R3/1 INT DT (ED)";
label variable TRICR42X "COV BY TRICR/CHAMV - R4/2 INT DT (ED)";
label variable TRICR53X "COV BY TRICR/CHAMV 12-31/R3 INT DT (ED)";
label variable TRICR09X "COV BY TRICR/CHAMV - 12/31/09 (ED)";
label variable TRIAT31X "ANY TIME COV TRICARE/CHAMPVA - R3/1";
label variable TRIAT42X "ANY TIME COV TRICARE/CHAMPVA - R4/2";
label variable TRIAT53X "ANY TIME COV TRICARE/CHAMPVA - R5/3";
label variable TRIAT09X "ANY TIME COV TRICARE/CHAMPVA - 12/31/09";
label variable MCAID31 "COV BY MEDICAID OR SCHIP - R3/1 INT DT";
label variable MCAID42 "COV BY MEDICAID OR SCHIP - R4/2 INT DT";
label variable MCAID53 "COV BY MEDICAID OR SCHIP 12-31/R3 INT DT";
label variable MCAID09 "COV BY MEDICAID OR SCHIP - 12/31/09";
label variable MCAID31X "COV BY MEDICAID/SCHIP - R3/1 INT DT (ED)";
label variable MCAID42X "COV BY MEDICAID/SCHIP - R4/2 INT DT (ED)";
label variable MCAID53X "COV MEDICAID/SCHIP 12-31/R3 INT DT(ED)";
label variable MCAID09X "COV BY MEDICAID OR SCHIP - 12/31/09 (ED)";
label variable MCARE31 "COV BY MEDICARE - R3/1 INT DT";
label variable MCARE42 "COV BY MEDICARE - R4/2 INT DT";
label variable MCARE53 "COV BY MEDICARE 12-31/R3 INT DT";
label variable MCARE09 "COV BY MEDICARE - 12/31/09";
label variable MCARE31X "COV BY MEDICARE - R3/1 INT DT (ED)";
label variable MCARE42X "COV BY MEDICARE - R4/2 INT DT (ED)";
label variable MCARE53X "COV BY MEDICARE 12-31/R3 INT DT (ED)";
label variable MCARE09X "COV BY MEDICARE - 12/31/09 (ED)";
label variable MCDAT31X "ANY TIME COV MEDICAID OR SCHIP - R3/1";
label variable MCDAT42X "ANY TIME COV MEDICAID OR SCHIP - R4/2";
label variable MCDAT53X "ANY TIME COV MEDICAID OR SCHIP - R5/3";
label variable MCDAT09X "ANY TIME COV MEDICAID OR SCHIP-12/31/09";
label variable OTPAAT31 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R3/1";
label variable OTPAAT42 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R4/2";
label variable OTPAAT53 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R5/3";
label variable OTPAAT09 "ANY COV OT GOV MCAID/SCHIP HMO-12/31/09";
label variable OTPBAT31 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R3/1";
label variable OTPBAT42 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R4/2";
label variable OTPBAT53 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R5/3";
label variable OTPBAT09 "ANY CV OT GV NT MCAID/SCHIP HMO-12/31/09";
label variable OTPUBA31 "COV/PAY OTH GOV MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBA42 "COV/PAY OTH GOV MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBA53 "COV/PAY OTH GOV MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBA09 "COV/PAY OTH GOV MCAID/SCHIP HMO-12/31/09";
label variable OTPUBB31 "COV OTH GOV NOT MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBB42 "COV OTH GOV NOT MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBB53 "COV OTH GOV NOT MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBB09 "COV OTH GOV NOT MCAID/SCHIP HMO-12/31/09";
label variable PRIDK31 "COV BY PRIV INS (DK PLAN) - R3/1 INT";
label variable PRIDK42 "COV BY PRIV INS (DK PLAN) - R4/2 INT";
label variable PRIDK53 "COV BY PRIV INS (DK PLAN) 12-31/R3 INT";
label variable PRIDK09 "COV BY PRIV INS (DK PLAN) - 12/31/09";
label variable PRIEU31 "COV BY EMPL/UNION GRP INS - R3/1 INT DT";
label variable PRIEU42 "COV BY EMPL/UNION GRP INS - R4/2 INT DT";
label variable PRIEU53 "COV BY EMPL/UNION GRP INS 12-31/R3 INT";
label variable PRIEU09 "COV BY EMPL/UNION GRP INS - 12/31/09";
label variable PRING31 "COV BY NON-GROUP INS - R3/1 INT DT";
label variable PRING42 "COV BY NON-GROUP INS - R4/2 INT DT";
label variable PRING53 "COV BY NON-GROUP INS 12-31/R3 INT DT";
label variable PRING09 "COV BY NON-GROUP INS - 12/31/09";
label variable PRIOG31 "COV BY OTHER GROUP INS - R3/1 INT DT";
label variable PRIOG42 "COV BY OTHER GROUP INS - R4/2 INT DT";
label variable PRIOG53 "COV BY OTHER GROUP INS 12-31/R3 INT DT";
label variable PRIOG09 "COV BY OTHER GROUP INS - 12/31/09";
label variable PRIS31 "COV BY SELF-EMP-1 INS - R3/1 INT DT";
label variable PRIS42 "COV BY SELF-EMP-1 INS - R4/2 INT DT";
label variable PRIS53 "COV BY SELF-EMP-1 INS 12-31/R3 INT DT";
label variable PRIS09 "COV BY SELF-EMP-1 INS - 12/31/09";
label variable PRIV31 "COV BY PRIV HLTH INS - R3/1 INT DATE";
label variable PRIV42 "COV BY PRIV HLTH INS - R4/2 INT DATE";
label variable PRIV53 "COV BY PRIV HLTH INS 12-31/R3 INT DATE";
label variable PRIV09 "COV BY PRIV HLTH INS - 12/31/09";
label variable PRIVAT31 "ANY TIME COV PRIVATE INS - R3/1";
label variable PRIVAT42 "ANY TIME COV PRIVATE INS - R4/2";
label variable PRIVAT53 "ANY TIME COV PRIVATE INS - R5/3";
label variable PRIVAT09 "ANY TIME COV PRIVATE INS - 12/31/09";
label variable PROUT31 "COV BY SOMEONE OUT OF RU - R3/1 INT";
label variable PROUT42 "COV BY SOMEONE OUT OF RU - R4/2 INT";
label variable PROUT53 "COV BY SOMEONE OUT OF RU 12-31/R3 INT DT";
label variable PROUT09 "COV BY SOMEONE OUT OF RU - 12/31/09";
label variable PUB31X "COV BY PUBLIC INS - R3/1 INT DT (ED)";
label variable PUB42X "COV BY PUBLIC INS - R4/2 INT DT (ED)";
label variable PUB53X "COV BY PUBLIC INS 12-31/R3 INT DT (ED)";
label variable PUB09X "COV BY PUBLIC INS - 12/31/09 (ED)";
label variable PUBAT31X "ANY TIME COV BY PUBLIC - R3/1";
label variable PUBAT42X "ANY TIME COV BY PUBLIC - R4/2";
label variable PUBAT53X "ANY TIME COV BY PUBLIC - R5/3";
label variable PUBAT09X "ANY TIME COV BY PUBLIC - 12/31/09";
label variable INS31X "INSURED - R3/1 INT DATE (ED)";
label variable INS42X "INSURED - R4/2 INT DATE (ED)";
label variable INS53X "INSURED 12-31/R3 INT DATE (ED)";
label variable INS09X "INSURED - 12/31/09 (ED)";
label variable INSAT31X "INSURED ANY TIME IN R3/1";
label variable INSAT42X "INSURED ANY TIME IN R4/2";
label variable INSAT53X "INSURED ANY TIME IN R5/3";
label variable INSAT09X "INSURED ANY TIME IN R5/R3 UNTIL 12/31/09";
label variable STAPR31 "COV BY STATE-SPEC PROG - R3/1 INT DT";
label variable STAPR42 "COV BY STATE-SPEC PROG - R4/2 INT DT";
label variable STAPR53 "COV BY STATE-SPEC PROG 12-31/R3 INT DT";
label variable STAPR09 "COV BY STATE-SPEC PROG - 12/31/09";
label variable STPRAT31 "ANY TIME COVERAGE BY STATE INS - R3/1";
label variable STPRAT42 "ANY TIME COVERAGE BY STATE INS - R4/2";
label variable STPRAT53 "ANY TIME COVERAGE BY STATE INS - R5/3";
label variable STPRAT09 "ANY TIME COV BY STATE INS - 12/31/09";
label variable EVRUNINS "EVER UNINSURED IN 09 USING PRIV/PUBX";
label variable EVRUNAT "EVER UNINSURED IN 09 USING PRIVAT/PUBATX";
label variable DENTIN31 "DENTAL INSURANCE - RD 3/1";
label variable DENTIN42 "DENTAL INSURANCE - RD 4/2";
label variable DENTIN53 "DENTAL INSURANCE - RD 5/3";
label variable DNTINS31 "DENTAL INS - RD 3/1 IN 09";
label variable DNTINS09 "DENTAL INS - R5/R3 UNTIL 12/31/09";
label variable PMEDIN31 "PRESCRIPTION DRUG INSURANCE - RD 3/1";
label variable PMEDIN42 "PRESCRIPTION DRUG INSURANCE - RD 4/2";
label variable PMEDIN53 "PRESCRIPTION DRUG INSURANCE - RD 5/3";
label variable PMDINS31 "PMED INS - RD 3/1 IN 09";
label variable PMDINS09 "PMED INS - R5/R3 UNTIL 12/31/09";
label variable PMEDUP31 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R3/1";
label variable PMEDUP42 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R4/2";
label variable PMEDUP53 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R5/3";
label variable PMEDPY31 "USUAL 3RD PARTY PAYER FOR PMEDS - R3/1";
label variable PMEDPY42 "USUAL 3RD PARTY PAYER FOR PMEDS - R4/2";
label variable PMEDPY53 "USUAL 3RD PARTY PAYER FOR PMEDS - R5/3";
label variable PMEDPP31 "OUT-OF-POCKET PAYMENT FOR LAST PMED-R3/1";
label variable PMEDPP42 "OUT-OF-POCKET PAYMENT FOR LAST PMED-R4/2";
label variable PMEDPP53 "OUT-OF-POCKET PAYMENT FOR LAST PMED-R5/3";
label variable GDCPBM42 "MCAID/SCHIP/O PUB: PRB GET PERS DOC-R4/2";
label variable APRTRM42 "MCAID/SCHIP/O PUB: NEED APPRV 4 TRT-R4/2";
label variable APRDLM42 "MCAID/SCHIP/O PUB: DLY WAIT 4 APPRV-R4/2";
label variable LKINFM42 "MCAID/SCHIP/O PUB: LOOK 4 PLAN INFO-R4/2";
label variable PBINFM42 "MCAID/SCHIP/O PUB: PROB FINDNG INFO-R4/2";
label variable CSTSVM42 "MCAID/SCHIP/O PUB: CALL CUSTMR SERV-R4/2";
label variable PBSVCM42 "MCAID/SCHIP/O PUB: PRB W CUSRVC HLP-R4/2";
label variable PPRWKM42 "MCAID/SCHIP/O PUB: COMP PLAN PPRWRK-R4/2";
label variable PBPWKM42 "MCAID/SCHIP/O PUB: PRB W PLN PPRWRK-R4/2";
label variable RTPLNM42 "MCAID/SCHIP/O PUB: RATE EXP W PLAN-R4/2";
label variable GDCPBT42 "TRICR/CHAMV: PROB GETTING PERS DOC-R4/2";
label variable APRTRT42 "TRICR/CHAMV: NEED APPRVL 4 TREATMNT-R4/2";
label variable APRDLT42 "TRICR/CHAMV: DELAY WAITING 4 APPRVL-R4/2";
label variable LKINFT42 "TRICR/CHAMV: INFO ON HOW PLAN WORKS-R4/2";
label variable PBINFT42 "TRICR/CHAMV: PROBLEM FINDING INFO-R4/2";
label variable CSTSVT42 "TRICR/CHAMV: CALL CUSTOMER SERVICE-R4/2";
label variable PBSVCT42 "TRICR/CHAMV: PROB GET HELP FR CSRVC-R4/2";
label variable PPRWKT42 "TRICR/CHAMV:FILL OUT PAPERWRK 4 PLN-R4/2";
label variable PBPWKT42 "TRICR/CHAMV: PROB W PLAN PAPERWORK-R4/2";
label variable RTPLNT42 "TRICR/CHAMV: RATE EXPERIENCE W PLAN-R4/2";
label variable TOTTCH09 "TOTAL HEALTH CARE CHARGES 09, EXCL RX";
label variable TOTEXP09 "TOTAL HEALTH CARE EXP 09";
label variable TOTSLF09 "TOTAL AMT PAID BY SELF/FAMILY 09";
label variable TOTMCR09 "TOTAL AMT PAID BY MEDICARE 09";
label variable TOTMCD09 "TOTAL AMT PAID BY MEDICAID 09";
label variable TOTPRV09 "TOTAL AMT PAID BY PRIVATE INS 09";
label variable TOTVA09 "TOTAL AMT PAID BY VA/CHAMPVA 09";
label variable TOTTRI09 "TOTAL AMT PAID BY TRICARE 09";
label variable TOTOFD09 "TOTAL AMT PAID BY OTHER FEDERAL 09";
label variable TOTSTL09 "TOTAL AMT PAID BY OTH ST/LOCAL 09";
label variable TOTWCP09 "TOTAL AMT PAID BY WORKERS COMP 09";
label variable TOTOPR09 "TOTAL AMT PAID BY OTHER PRIVATE 09";
label variable TOTOPU09 "TOTAL AMT PAID BY OTHER PUBLIC 09";
label variable TOTOSR09 "TOTAL AMT PAID BY OTHER SOURCES 09";
label variable OBTOTV09 "# OFFICE-BASED PROVIDER VISITS 09";
label variable OBVTCH09 "OFFICE-BASED PROVIDER VISIT CHARGES 09";
label variable OBVEXP09 "TOTAL OFFICE-BASED EXP 09";
label variable OBVSLF09 "ALL OFFICE VISITS - SELF/FAMILY AMT 09";
label variable OBVMCR09 "ALL OFFICE VISITS - MEDICARE AMT 09";
label variable OBVMCD09 "ALL OFFICE VISITS - MEDICAID AMT 09";
label variable OBVPRV09 "ALL OFFICE VISITS - PRIVATE INS AMT 09";
label variable OBVVA09 "ALL OFFICE VISITS-VA/CHAMPVA AMT 09";
label variable OBVTRI09 "ALL OFFICE VISITS-TRICARE AMT 09";
label variable OBVOFD09 "ALL OFFICE VISITS-OTHER FEDERAL AMT 09";
label variable OBVSTL09 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 09";
label variable OBVWCP09 "ALL OFFICE VISITS - WORKERS COMP AMT 09";
label variable OBVOPR09 "ALL OFFICE VISITS - OTH PRIVATE AMT 09";
label variable OBVOPU09 "ALL OFFICE VISITS - OTH PUBLIC AMT 09";
label variable OBVOSR09 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 09";
label variable OBDRV09 "# OFFICE-BASED PHYSICIAN VISITS 09";
label variable OBDTCH09 "OFFICE-BASED PHYSICIAN VISIT CHARGES 09";
label variable OBDEXP09 "TOTAL OFF-BASED DR EXP 09";
label variable OBDSLF09 "DR OFFICE VISITS - SELF/FAMILY AMT 09";
label variable OBDMCR09 "DR OFFICE VISITS - MEDICARE AMT 09";
label variable OBDMCD09 "DR OFFICE VISITS - MEDICAID AMT 09";
label variable OBDPRV09 "DR OFFICE VISITS - PRIVATE INS AMT 09";
label variable OBDVA09 "DR OFFICE VISITS - VA/CHAMPVA AMT 09";
label variable OBDTRI09 "DR OFFICE VISITS - TRICARE AMT 09";
label variable OBDOFD09 "DR OFFICE VISITS - OTHER FEDERAL AMT 09";
label variable OBDSTL09 "DR OFFICE VISITS - OTH ST/LOCAL AMT 09";
label variable OBDWCP09 "DR OFFICE VISITS - WORKERS COMP AMT 09";
label variable OBDOPR09 "DR OFFICE VISITS - OTH PRIVATE AMT 09";
label variable OBDOPU09 "DR OFFICE VISITS - OTH PUBLIC AMT 09";
label variable OBDOSR09 "DR OFF VSTS - OTH UNCLASS SRCE AMT 09";
label variable OBOTHV09 "# OFFICE-BASED NON-PHYSICAN VISITS 09";
label variable OBOTCH09 "OFFICE-BASED NON-DR VISIT CHARGES 09";
label variable OBOEXP09 "TOTAL OFF-BASED NON-DR EXP 09";
label variable OBOSLF09 "NON-DR OFF VISTS - SELF/FAMILY AMT 09";
label variable OBOMCR09 "NON-DR OFF VISTS - MEDICARE AMT 09";
label variable OBOMCD09 "NON-DR OFF VISTS - MEDICAID AMT 09";
label variable OBOPRV09 "NON-DR OFF VISTS - PRIVATE INS AMT 09";
label variable OBOVA09 "NON-DR OFF VISTS - VA/CHAMPVA AMT 09";
label variable OBOTRI09 "NON-DR OFF VISTS - TRICARE AMT 09";
label variable OBOOFD09 "NON-DR OFF VISTS - OTHER FEDERAL AMT 09";
label variable OBOSTL09 "NON-DR OFF VISTS - OTH ST/LOCAL AMT 09";
label variable OBOWCP09 "NON-DR OFF VISTS - WORKERS COMP AMT 09";
label variable OBOOPR09 "NON-DR OFF VISTS - OTH PRIVATE AMT 09";
label variable OBOOPU09 "NON-DR OFF VISTS - OTH PUBLIC AMT 09";
label variable OBOOSR09 "NON-DR OF VSTS - OTH UNCLASS SRCE AMT 09";
label variable OBCHIR09 "# OFFICE-BASED CHIROPRACTOR VISITS 09";
label variable OBCTCH09 "OFFICE-BASED CHIRO VISIT CHARGES 09";
label variable OBCEXP09 "TOTAL OFF-BASED CHIRO EXP 09";
label variable OBCSLF09 "CHIRO OFF VISITS - SELF/FAMILY AMT 09";
label variable OBCMCR09 "CHIRO OFF VISITS - MEDICARE AMT 09";
label variable OBCMCD09 "CHIRO OFF VISITS - MEDICAID AMT 09";
label variable OBCPRV09 "CHIRO OFF VISITS - PRIVATE INS AMT 09";
label variable OBCVA09 "CHIRO OFF VISITS - VA/CHAMPVA AMT 09";
label variable OBCTRI09 "CHIRO OFF VISITS - TRICARE AMT 09";
label variable OBCOFD09 "CHIRO OFF VISITS - OTHER FEDERAL AMT 09";
label variable OBCSTL09 "CHIRO OFF VISITS - OTH ST/LOCAL AMT 09";
label variable OBCWCP09 "CHIRO OFF VISITS - WORKERS COMP AMT 09";
label variable OBCOPR09 "CHIRO OFF VISTS - OTHR PRIVATE AMT 09";
label variable OBCOPU09 "CHIRO OFF VISTS - OTHR PUBLIC AMT 09";
label variable OBCOSR09 "CHIRO OFF VSTS-OTHR UNCLASS SRCE AMT 09";
label variable OBNURS09 "# OFF-BASED NURSE/PRACTITIONER VISITS 09";
label variable OBNTCH09 "OFFICE-BASED NURSE/PRAC VISIT CHARGES 09";
label variable OBNEXP09 "TOTAL OFF-BASED NURSE/PRAC 09";
label variable OBNSLF09 "NURSE/PRAC OFF VISITS-SELF/FAMILY AMT 09";
label variable OBNMCR09 "NURSE/PRAC OFF VISITS - MEDICARE AMT 09";
label variable OBNMCD09 "NURSE/PRAC OFF VSTS - MEDICAID AMT 09";
label variable OBNPRV09 "NURSE/PRAC OFF VSTS-PRIVATE INS AMT 09";
label variable OBNVA09 "NURSE/PRAC OFF VSTS - VA/CHAMPVA AMT 09";
label variable OBNTRI09 "NURSE/PRAC OFF VSTS - TRICARE AMT 09";
label variable OBNOFD09 "NURSE/PRAC OFF VSTS-OTHER FEDERAL AMT 09";
label variable OBNSTL09 "NURSE/PRAC OFF VSTS-OTH ST/LOCAL AMT 09";
label variable OBNWCP09 "NURSE/PRAC OFF VSTS-WORKERS COMP AMT 09";
label variable OBNOPR09 "NURSE/PRAC OFF VSTS - OTH PRIVATE AMT 09";
label variable OBNOPU09 "NURSE/PRAC OFF VSTS - OTH PUBLIC AMT 09";
label variable OBNOSR09 "NRS/PR OFF VSTS-OTH UNCLASS SRCE AMT 09";
label variable OBOPTO09 "# OFF-BASED OPTOMETRIST VISITS 09";
label variable OBETCH09 "OFFICE-BASED OPTOMTRIST VISIT CHARGES 09";
label variable OBEEXP09 "TOTAL OFF-BASED OPTOMETRIST EXP 09";
label variable OBESLF09 "OPTOMETRIST OFF VSTS-SELF/FAMILY AMT 09";
label variable OBEMCR09 "OPTOMETRIST OFF VSTS - MEDICARE AMT 09";
label variable OBEMCD09 "OPTOMETRIST OFF VSTS - MEDICAID AMT 09";
label variable OBEPRV09 "OPTOMETRIST OFF VSTS-PRIVATE INS AMT 09";
label variable OBEVA09 "OPTOMETRIST OFF VSTS - VA/CHAMPVA AMT 09";
label variable OBETRI09 "OPTOMETRIST OFF VSTS - TRICARE AMT 09";
label variable OBEOFD09 "OPTOMETRIST OFF VSTS-OTH FEDERAL AMT 09";
label variable OBESTL09 "OPTOMETRIST OFF VSTS-OTH ST/LOCL AMT 09";
label variable OBEWCP09 "OPTOMETRIST OFF VSTS-WORKERS COMP AMT 09";
label variable OBEOPR09 "OPTOMETRIST OFF VSTS-OTH PRIVATE AMT 09";
label variable OBEOPU09 "OPTOMETRIST OFF VSTS - OTH PUBLIC AMT 09";
label variable OBEOSR09 "OPTOM OFF VSTS-OTH UNCLASS SRCE AMT 09";
label variable OBASST09 "# OFF-BASED PHYSICIAN ASSIST VISITS 09";
label variable OBATCH09 "OFFICE-BASED PHYS ASST VISIT CHARGES 09";
label variable OBAEXP09 "TOTAL OFF-BASED PHYS ASS T EXP 09";
label variable OBASLF09 "PHYS ASS T OFF VSTS - SELF/FAMILY AMT 09";
label variable OBAMCR09 "PHYS ASS T OFF VSTS - MEDICARE AMT 09";
label variable OBAMCD09 "PHYS ASS T OFF VSTS - MEDICAID AMT 09";
label variable OBAPRV09 "PHYS ASS T OFF VSTS - PRIVATE INS AMT 09";
label variable OBAVA09 "PHYS ASS T OFF VSTS - VA/CHAMPVA AMT 09";
label variable OBATRI09 "PHYS ASS T OFF VSTS - TRICARE AMT 09";
label variable OBAOFD09 "PHYS ASS T OFF VSTS - OTHER FED AMT 09";
label variable OBASTL09 "PHYS ASS T OFF VSTS - OTH ST/LOCL AMT 09";
label variable OBAWCP09 "PHYS ASS T OFF VSTS-WORKERS COMP AMT 09";
label variable OBAOPR09 "PHYS ASS T OFF VSTS - OTH PRIVATE AMT 09";
label variable OBAOPU09 "PHYS ASS T OFF VSTS - OTH PUBLIC AMT 09";
label variable OBAOSR09 "P A OFF VSTS - OTH UNCLASS SRCE AMT 09";
label variable OBTHER09 "# OFF-BASED PT/OT VISITS 09";
label variable OBTTCH09 "OFFICE-BASED PT/OC VISIT CHARGES 09";
label variable OBTEXP09 "TOT OFF-BASED PT EXP 09";
label variable OBTSLF09 "PT/OT OFF VISITS - SELF/FAMILY AMT 09";
label variable OBTMCR09 "PT/OT OFF VISITS - MEDICARE AMT 09";
label variable OBTMCD09 "PT/OT OFF VISITS - MEDICAID AMT 09";
label variable OBTPRV09 "PT/OT OFF VISITS - PRIVATE INS AMT 09";
label variable OBTVA09 "PT/OT OFF VISITS - VA/CHAMPVA AMT 09";
label variable OBTTRI09 "PT/OT OFF VISITS - TRICARE AMT 09";
label variable OBTOFD09 "PT/OT OFF VISITS - OTHER FED AMT 09";
label variable OBTSTL09 "PT/OT OFF VISITS - OTH ST/LOCL AMT 09";
label variable OBTWCP09 "PT/OT OFF VISITS - WORKERS COMP AMT 09";
label variable OBTOPR09 "PT/OT OFF VISITS - OTH PRIVATE AMT 09";
label variable OBTOPU09 "PT/OT OFF VISITS - OTH PUBLIC AMT 09";
label variable OBTOSR09 "PT/OT OFF VSTS-OTH UNCLASS SRCE AMT 09";
label variable OPTOTV09 "# OUTPATIENT DEPT PROVIDER VISITS 09";
label variable OPTTCH09 "OPD FACILITY + DR VISIT CHARGES - 09";
label variable OPTEXP09 "TOTAL OUTPATIENT FAC + DR EXP 09";
label variable OPTSLF09 "ALL OPD VSTS-SELF/FAMILY AMT-(FAC+DR) 09";
label variable OPTMCR09 "ALL OPD VSTS-MEDICARE AMT-(FAC+DR) 09";
label variable OPTMCD09 "ALL OPD VSTS-MEDICAID AMT-(FAC+DR) 09";
label variable OPTPRV09 "ALL OPD VSTS-PRIV INS AMT-(FAC+DR) 09";
label variable OPTVA09 "ALL OPD VSTS-VA/CHAMPVA AMT-(FAC+DR) 09";
label variable OPTTRI09 "ALL OPD VSTS-TRICARE AMT-(FAC+DR) 09";
label variable OPTOFD09 "ALL OPD VSTS-OTHER FED AMT-(FAC+DR) 09";
label variable OPTSTL09 "ALL OPD VST-OTH ST/LOCAL AMT(FAC+DR) 09";
label variable OPTWCP09 "ALL OPD VST-WORKRS COMP AMT-(FAC+DR) 09";
label variable OPTOPR09 "ALL OPD VSTS-OTH PRIVATE AMT-(FAC+DR) 09";
label variable OPTOPU09 "ALL OPD VSTS-OTH PUBLIC AMT-(FAC+DR) 09";
label variable OPTOSR09 "ALL OPD VST-OTH UNCLS SRC AMT(FAC+DR) 09";
label variable OPFTCH09 "OPD PROVIDER VISIT CHARGES - FAC 09";
label variable OPFEXP09 "TOTAL OUTPATIENT FACILITY EXP 09";
label variable OPFSLF09 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 09";
label variable OPFMCR09 "ALL OPD VISITS-MEDICARE AMT-FAC 09";
label variable OPFMCD09 "ALL OPD VISITS-MEDICAID AMT-FAC 09";
label variable OPFPRV09 "ALL OPD VISITS-PRIV INS AMT-FAC 09";
label variable OPFVA09 "ALL OPD VISITS-VA/CHAMPVA AMT-FAC 09";
label variable OPFTRI09 "ALL OPD VISITS-TRICARE AMT-FAC 09";
label variable OPFOFD09 "ALL OPD VISITS-OTHER FED AMT-FAC 09";
label variable OPFSTL09 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 09";
label variable OPFWCP09 "ALL OPD VISITS-WORKERS COMP AMT-FAC 09";
label variable OPFOPR09 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 09";
label variable OPFOPU09 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 09";
label variable OPFOSR09 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 09";
label variable OPDEXP09 "TOTAL OUTPATIENT PROVIDER EXP 09";
label variable OPDTCH09 "OPD PROVIDER VISIT CHARGES - DR 09";
label variable OPDSLF09 "ALL OPD VISITS-SELF/FAMILY AMT-DR 09";
label variable OPDMCR09 "ALL OPD VISITS-MEDICARE AMT-DR 09";
label variable OPDMCD09 "ALL OPD VISITS-MEDICAID AMT-DR 09";
label variable OPDPRV09 "ALL OPD VISITS-PRIV INS AMT-DR 09";
label variable OPDVA09 "ALL OPD VISITS-VA/CHAMPVA AMT-DR 09";
label variable OPDTRI09 "ALL OPD VISITS-TRICARE AMT-DR 09";
label variable OPDOFD09 "ALL OPD VISITS-OTHER FED AMT-DR 09";
label variable OPDSTL09 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 09";
label variable OPDWCP09 "ALL OPD VISITS-WORKERS COMP AMT-DR 09";
label variable OPDOPR09 "ALL OPD VISITS - OTH PRIVATE AMT-DR 09";
label variable OPDOPU09 "ALL OPD VISITS-OTH PUBLIC AMT-DR 09";
label variable OPDOSR09 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 09";
label variable OPDRV09 "# OUTPATIENT DEPT PHYSICIAN VISITS 09";
label variable OPVTCH09 "OPD PHYSICIAN VISIT CHARGES - FAC 09";
label variable OPVEXP09 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 09";
label variable OPVSLF09 "OPD DR VISITS-SELF/FAMILY AMT-FAC 09";
label variable OPVMCR09 "OPD DR VISITS-MEDICARE AMT-FAC 09";
label variable OPVMCD09 "OPD DR VISITS-MEDICAID AMT-FAC 09";
label variable OPVPRV09 "OPD DR VISITS-PRIV INS AMT-FAC 09";
label variable OPVVA09 "OPD DR VISITS-VA/CHAMPVA AMT-FAC 09";
label variable OPVTRI09 "OPD DR VISITS-TRICARE AMT-FAC 09";
label variable OPVOFD09 "OPD DR VISITS-OTHER FED AMT-FAC 09";
label variable OPVSTL09 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 09";
label variable OPVWCP09 "OPD DR VISITS-WORKERS COMP AMT-FAC 09";
label variable OPVOPR09 "OPD DR VISITS - OTH PRIVATE AMT-FAC 09";
label variable OPVOPU09 "OPD DR VISITS-OTH PUBLIC AMT-FAC 09";
label variable OPVOSR09 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 09";
label variable OPSEXP09 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 09";
label variable OPSTCH09 "OPD PHYSICIAN VISIT CHARGES - DR 09";
label variable OPSSLF09 "OPD DR VISITS-SELF/FAMILY AMT-DR 09";
label variable OPSMCR09 "OPD DR VISITS-MEDICARE AMT-DR 09";
label variable OPSMCD09 "OPD DR VISITS-MEDICAID AMT-DR 09";
label variable OPSPRV09 "OPD DR VISITS-PRIV INS AMT-DR 09";
label variable OPSVA09 "OPD DR VISITS-VA/CHAMPVA AMT-DR 09";
label variable OPSTRI09 "OPD DR VISITS-TRICARE AMT-DR 09";
label variable OPSOFD09 "OPD DR VISITS-OTHER FED AMT-DR 09";
label variable OPSSTL09 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 09";
label variable OPSWCP09 "OPD DR VISITS-WORKERS COMP AMT-DR 09";
label variable OPSOPR09 "OPD DR VISITS - OTH PRIVATE AMT-DR 09";
label variable OPSOPU09 "OPD DR VISITS-OTH PUBLIC AMT-DR 09";
label variable OPSOSR09 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 09";
label variable OPOTHV09 "# OUTPATIENT DEPT NON-DR VISITS 09";
label variable OPOTCH09 "OPD NON-PHYS VISIT CHARGES - FAC 09";
label variable OPOEXP09 "TOTAL OUTPATIENT NON-DR - FAC EXP 09";
label variable OPOSLF09 "OPD NON-DR VISITS-SELF/FAM AMT-FAC 09";
label variable OPOMCR09 "OPD NON-DR VISITS-MEDICARE AMT-FAC 09";
label variable OPOMCD09 "OPD NON-DR VISITS-MEDICAID AMT-FAC 09";
label variable OPOPRV09 "OPD NON-DR VISITS-PRIV INS AMT-FAC 09";
label variable OPOVA09 "OPD NON-DR VISITS-VA/CHAMPVA AMT-FAC 09";
label variable OPOTRI09 "OPD NON-DR VISITS-TRICARE AMT-FAC 09";
label variable OPOOFD09 "OPD NON-DR VISITS-OTHER FED AMT-FAC 09";
label variable OPOSTL09 "OPD NON-DR VISITS-OTH ST/LOC AMT-FAC 09";
label variable OPOWCP09 "OPD NON-DR VISITS-WRKRS COMP AMT-FAC 09";
label variable OPOOPR09 "OPD NON-DR VISITS-OTH PRIVATE AMT-FAC 09";
label variable OPOOPU09 "OPD NON-DR VISITS-OTH PUBLIC AMT-FAC 09";
label variable OPOOSR09 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-FAC 09";
label variable OPPEXP09 "TOTAL OUTPATIENT NON-DR - DR EXP 09";
label variable OPPTCH09 "OPD NON-PHYS VISIT CHARGES - DR 09";
label variable OPPSLF09 "OPD NON-DR VISITS-SELF/FAM AMT-DR 09";
label variable OPPMCR09 "OPD NON-DR VISITS-MEDICARE AMT-DR 09";
label variable OPPMCD09 "OPD NON-DR VISITS-MEDICAID AMT-DR 09";
label variable OPPPRV09 "OPD NON-DR VISITS-PRIV INS AMT-DR 09";
label variable OPPVA09 "OPD NON-DR VISITS-VA/CHAMPVA AMT-DR 09";
label variable OPPTRI09 "OPD NON-DR VISITS-TRICARE AMT-DR 09";
label variable OPPOFD09 "OPD NON-DR VISITS-OTHER FED AMT-DR 09";
label variable OPPSTL09 "OPD NON-DR VISITS-OTH ST/LOC AMT-DR 09";
label variable OPPWCP09 "OPD NON-DR VISITS-WRKRS COMP AMT-DR 09";
label variable OPPOPR09 "OPD NON-DR VISITS-OTH PRIVATE AMT-DR 09";
label variable OPPOPU09 "OPD NON-DR VISITS-OTH PUBLIC AMT-DR 09";
label variable OPPOSR09 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-DR 09";
label variable AMCHIR09 "# CHIROPRACTR VSTS (OFF+OUTPAT), 2009";
label variable AMCTCH09 "CHIRO AMBULATORY VISIT CHARGES 09";
label variable AMCEXP09 "TOTL AMBULTRY (OB+OP) CHIRO EXP 09";
label variable AMCSLF09 "CHIRO AMB VISITS - SELF/FAMILY AMT 09";
label variable AMCMCR09 "CHIRO AMB VISITS - MEDICARE AMT 09";
label variable AMCMCD09 "CHIRO AMB VISITS - MEDICAID AMT 09";
label variable AMCPRV09 "CHIRO AMB VISITS - PRIVATE INS AMT 09";
label variable AMCVA09 "CHIRO AMB VISITS - VA/CHAMPVA AMT 09";
label variable AMCTRI09 "CHIRO AMB VISITS-TRICARE AMT 09";
label variable AMCOFD09 "CHIRO AMB VISITS - OTHER FEDERAL AMT 09";
label variable AMCSTL09 "CHIRO AMB VISITS - OTH ST/LOCAL AMT 09";
label variable AMCWCP09 "CHIRO AMB VISITS-WORKERS COMP AMT 09";
label variable AMCOPR09 "CHIRO AMB VISITS - OTH PRIVATE AMT 09";
label variable AMCOPU09 "CHIRO AMB VISITS - OTH PUBLIC AMT 09";
label variable AMCOSR09 "CHIR AMB VSTS - OTH UNCLASS SRCE AMT 09";
label variable AMNURS09 "# AMB NURSE/PRCTITIONR VSTS(OB+OP) 09";
label variable AMNTCH09 "NRS/PRAC AMBULATORY VISIT CHARGES 09";
label variable AMNEXP09 "TOTL AMBULTRY (OB+OP) NURSE/PRAC EXP 09";
label variable AMNSLF09 "NRS/PRAC AMB VSTS - SELF/FAMILY AMT 09";
label variable AMNMCR09 "NRS/PRAC AMB VSTS - MEDICARE AMT 09";
label variable AMNMCD09 "NRS/PRAC AMB VSTS - MEDICAID AMT 09";
label variable AMNPRV09 "NRS/PRAC AMB VSTS - PRIV INS AMT 09";
label variable AMNVA09 "NRS/PRAC AMB VSTS-VA/CHAMPVA AMT 09";
label variable AMNTRI09 "NRS/PRAC AMB VSTS-TRICARE AMT 09";
label variable AMNOFD09 "NRS/PRAC AMB VSTS-OTHER FEDERAL AMT 09";
label variable AMNSTL09 "NRS/PRAC AMB VSTS-OTH ST/LOCAL AMT 09";
label variable AMNWCP09 "NRS/PRAC AMB VSTS-WORKERS COMP AMT 09";
label variable AMNOPR09 "NRS/PRAC AMB VSTS - OTH PRIVATE AMT 09";
label variable AMNOPU09 "NRS/PRAC AMB VSTS - OTH PUBLIC AMT 09";
label variable AMNOSR09 "NRS/PR AMB VSTS - OTH UNCLAS SRCE AMT 09";
label variable AMOPTO09 "# AMB OPTOMETRIST VSTS (OB+OP) 09";
label variable AMETCH09 "OPTOMETRIST AMBULATORY VISIT CHARGES 09";
label variable AMEEXP09 "TOTL AMBULTRY (OB+OP) OPTOMETRIST EXP 09";
label variable AMESLF09 "OPTMTRIST AMB VSTS - SELF/FAMILY AMT 09";
label variable AMEMCR09 "OPTMTRIST AMB VSTS - MEDICARE AMT 09";
label variable AMEMCD09 "OPTMTRIST AMB VSTS - MEDICAID AMT 09";
label variable AMEPRV09 "OPTMTRIST AMB VSTS - PRIVATE INS AMT 09";
label variable AMEVA09 "OPTMTRIST AMB VSTS-VA/CHAMPVA AMT 09";
label variable AMETRI09 "OPTMTRIST AMB VSTS-TRICARE AMT 09";
label variable AMEOFD09 "OPTMTRIST AMB VSTS-OTHER FED AMT 09";
label variable AMESTL09 "OPTMTRIST AMB VSTS-OTH ST/LOCAL AMT 09";
label variable AMEWCP09 "OPTMTRIST AMB VSTS-WORKERS COMP AMT 09";
label variable AMEOPR09 "OPTMTRIST AMB VSTS - OTH PRIVATE AMT 09";
label variable AMEOPU09 "OPTMTRIST AMB VSTS - OTH PUBLIC AMT 09";
label variable AMEOSR09 "OPTOM AMB VSTS - OTH UNCLAS SRCE AMT 09";
label variable AMASST09 "# PHYSICIAN ASS T VSTS (OFF+OUPAT), 2009";
label variable AMATCH09 "PHYS ASS T AMBULATORY VISIT CHARGES 09";
label variable AMAEXP09 "TOTL AMBULTRY (OB+OP) PHYS ASS T EXP 09";
label variable AMASLF09 "PHYS ASS T AMB VSTS-SELF/FAMILY AMT 09";
label variable AMAMCR09 "PHYS ASS T AMB VSTS-MEDICARE AMT 09";
label variable AMAMCD09 "PHYS ASS T AMB VSTS-MEDICAID AMT 09";
label variable AMAPRV09 "PHYS ASS T AMB VSTS-PRIVATE INS AMT 09";
label variable AMAVA09 "PHYS ASS T AMB VSTS-VA/CHAMPVA AMT 09";
label variable AMATRI09 "PHYS ASS T AMB VSTS-TRICARE AMT 09";
label variable AMAOFD09 "PHYS ASS T AMB VSTS - OTHER FED AMT 09";
label variable AMASTL09 "PHYS ASS T AMB VSTS-OTH ST/LOCL AMT 09";
label variable AMAWCP09 "PHYS ASS T AMB VSTS-WRKERS COMP AMT 09";
label variable AMAOPR09 "PHYS ASS T AMB VSTS - OTH PRIVATE AMT 09";
label variable AMAOPU09 "PHYS ASS T AMB VSTS - OTH PUBLIC AMT 09";
label variable AMAOSR09 "P A AMB VSTS - OTH UNCLASS SRCE AMT 09";
label variable AMTHER09 "# AMB PT/OT THRPY VISITS (OB+OP) 09";
label variable AMTTCH09 "PT/OC AMBULATORY VISIT CHARGES 09";
label variable AMTEXP09 "TOTL AMBULTRY (OB+OP) PT/OT EXP 09";
label variable AMTSLF09 "PT/OT AMB VISITS-SELF/FAMILY AMT 09";
label variable AMTMCR09 "PT/OT AMB VISITS-MEDICARE AMT 09";
label variable AMTMCD09 "PT/OT AMB VISITS-MEDICAID AMT 09";
label variable AMTPRV09 "PT/OT AMB VISITS-PRIVATE INS AMT 09";
label variable AMTVA09 "PT/OT AMB VISITS-VA/CHAMPVA AMT 09";
label variable AMTTRI09 "PT/OT AMB VISITS-TRICARE AMT 09";
label variable AMTOFD09 "PT/OT AMB VISITS - OTHER FED AMT 09";
label variable AMTSTL09 "PT/OT AMB VISITS-OTH ST/LOCL AMT 09";
label variable AMTWCP09 "PT/OT AMB VISITS-WORKERS COMP AMT 09";
label variable AMTOPR09 "PT/OT AMB VISITS - OTH PRIVATE AMT 09";
label variable AMTOPU09 "PT/OT AMB VISITS-OTH PUBLIC AMT 09";
label variable AMTOSR09 "PT/OT AMB VSTS-OTH UNCLAS SRCE AMT 09";
label variable AMTOTC09 "# CALLS W/OFFICE & OUPAT DEPTS, 2009";
label variable AMDRC09 "# CALLS W/OFF & OUTPAT PHYSICIANS, 2009";
label variable ERTOT09 "# EMERGENCY ROOM VISITS 09";
label variable ERTTCH09 "ER FACILITY + DR VISIT CHARGES 09";
label variable ERTEXP09 "TOTAL ER FACILITY + DR EXP 09";
label variable ERTSLF09 "ER-SELF/FAMILY AMT-(FAC+DR) 09";
label variable ERTMCR09 "ER-MEDICARE AMT-(FAC+DR) 09";
label variable ERTMCD09 "ER-MEDICAID AMT-(FAC+DR) 09";
label variable ERTPRV09 "ER-PRIV INS AMT-(FAC+DR) 09";
label variable ERTVA09 "ER-VA/CHAMPVA AMT-(FAC+DR) 09";
label variable ERTTRI09 "ER-TRICARE AMT-(FAC+DR) 09";
label variable ERTOFD09 "ER-OTHER FED AMT-(FAC+DR) 09";
label variable ERTSTL09 "ER-OTH ST/LOCAL AMT-(FAC+DR) 09";
label variable ERTWCP09 "ER-WORKERS COMP AMT-(FAC+DR) 09";
label variable ERTOPR09 "ER-OTH PRIVATE AMT-(FAC+DR) 09";
label variable ERTOPU09 "ER-OTH PUBLIC AMT-(FAC+DR) 09";
label variable ERTOSR09 "ER-OTH UNCLASS SRCE AMT-(FAC+DR) 09";
label variable ERFTCH09 "ER FACILITY VISIT CHARGES 09";
label variable ERFEXP09 "TOTAL ER FACILITY EXP 09";
label variable ERFSLF09 "ER-SELF/FAMILY AMT - FAC 09";
label variable ERFMCR09 "ER-MEDICARE AMT - FAC 09";
label variable ERFMCD09 "ER-MEDICAID AMT - FAC 09";
label variable ERFPRV09 "ER-PRIVATE INS AMT - FAC 09";
label variable ERFVA09 "ER-VA/CHAMPVA AMT - FAC 09";
label variable ERFTRI09 "ER-TRICARE AMT - FAC 09";
label variable ERFOFD09 "ER-OTHER FEDERAL AMT - FAC 09";
label variable ERFSTL09 "ER-OTH ST/LOCAL AMT - FAC 09";
label variable ERFWCP09 "ER-WORKERS COMP AMT - FAC 09";
label variable ERFOPR09 "ER-OTHER PRIVATE AMT - FAC 09";
label variable ERFOPU09 "ER-OTHER PUBLIC AMT - FAC 09";
label variable ERFOSR09 "ER-OTH UNCLASS SRCE AMT - FAC 09";
label variable ERDEXP09 "TOTAL EMERGENCY ROOM DR EXP 09";
label variable ERDTCH09 "ER DOCTOR VISIT CHARGES 09";
label variable ERDSLF09 "ER-SELF/FAMILY AMT - DR 09";
label variable ERDMCR09 "ER-MEDICARE AMT - DR 09";
label variable ERDMCD09 "ER-MEDICAID AMT - DR 09";
label variable ERDPRV09 "ER-PRIVATE INS AMT - DR 09";
label variable ERDVA09 "ER-VA/CHAMPVA AMT - DR 09";
label variable ERDTRI09 "ER-TRICARE AMT - DR 09";
label variable ERDOFD09 "ER-OTHER FED AMT - DR 09";
label variable ERDSTL09 "ER-OTH ST/LOCAL AMT - DR 09";
label variable ERDWCP09 "ER-WORKERS COMP AMT - DR 09";
label variable ERDOPR09 "ER - OTHER PRIVATE AMT - DR 09";
label variable ERDOPU09 "ER - OTHER PUBLIC AMT - DR 09";
label variable ERDOSR09 "ER-OTH UNCLASS SRCE AMT - DR 09";
label variable IPZERO09 "# ZERO-NIGHT HOSPITAL STAYS 09";
label variable ZIFTCH09 "ZERO-NITE IP STAY CHARGES - FAC 09";
label variable ZIFEXP09 "TOTAL ZERO-NITE STAYS FAC EXP 09";
label variable ZIFSLF09 "ZERO-NITE IP STAZ-SELF/FAM AMT-FAC 09";
label variable ZIFMCR09 "ZERO-NITE IP STAZ-MEDICARE AMT-FAC 09";
label variable ZIFMCD09 "ZERO-NITE IP STAZ-MEDICAID AMT-FAC 09";
label variable ZIFPRV09 "ZERO-NITE IP STAZ-PRIV INS AMT-FAC 09";
label variable ZIFVA09 "ZERO-NITE IP STAZ-VA/CHAMPVA AMT-FAC 09";
label variable ZIFTRI09 "ZERO-NITE IP STAZ-TRICARE AMT-FAC 09";
label variable ZIFOFD09 "ZERO-NITE IP STAZ-OTHER FED AMT-FAC 09";
label variable ZIFSTL09 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-FAC 09";
label variable ZIFWCP09 "ZERO-NITE IP STAZ-WRKERS COMP AMT-FAC 09";
label variable ZIFOPR09 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-FAC 09";
label variable ZIFOPU09 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-FAC 09";
label variable ZIFOSR09 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-FAC 09";
label variable ZIDEXP09 "TOTAL ZERO-NITE STAZ DR 09";
label variable ZIDTCH09 "ZERO-NITE IP STAY CHARGES - DR 09";
label variable ZIDSLF09 "ZERO-NITE IP STAZ-SELF/FAM AMT-DR 09";
label variable ZIDMCR09 "ZERO-NITE IP STAZ-MEDICARE AMT-DR 09";
label variable ZIDMCD09 "ZERO-NITE IP STAZ-MEDICAID AMT-DR 09";
label variable ZIDPRV09 "ZERO-NITE IP STAZ-PRIV INS AMT-DR 09";
label variable ZIDVA09 "ZERO-NITE IP STAZ-VA/CHAMPVA AMT-DR 09";
label variable ZIDTRI09 "ZERO-NITE IP STAZ-TRICARE AMT-DR 09";
label variable ZIDOFD09 "ZERO-NITE IP STAZ-OTHER FED AMT-DR 09";
label variable ZIDSTL09 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-DR 09";
label variable ZIDWCP09 "ZERO-NITE IP STAZ-WRKERS COMP AMT-DR 09";
label variable ZIDOPR09 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-DR 09";
label variable ZIDOPU09 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-DR 09";
label variable ZIDOSR09 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-DR 09";
label variable IPDIS09 "# HOSPITAL DISCHARGES, 2009";
label variable IPTEXP09 "TOT HOSP IP FACILITY + DR EXP 09";
label variable IPTTCH09 "IP HOSP STAY CHARGES (FAC+DR) 09";
label variable IPTSLF09 "IP HOSP STAZ-SELF/FAMILY AMT-(FAC+DR) 09";
label variable IPTMCR09 "IP HOSP STAZ-MEDICARE AMT-(FAC+DR) 09";
label variable IPTMCD09 "IP HOSP STAZ-MEDICAID AMT-(FAC+DR) 09";
label variable IPTPRV09 "IP HOSP STAZ-PRIV INS AMT-(FAC+DR) 09";
label variable IPTVA09 "IP HOSP STAZ-VA/CHAMPVA AMT-(FAC+DR) 09";
label variable IPTTRI09 "IP HOSP STAZ-TRICARE AMT-(FAC+DR) 09";
label variable IPTOFD09 "IP HOSP STAZ-OTHER FED AMT-(FAC+DR) 09";
label variable IPTSTL09 "IP HSP STAZ-OTH ST/LOCAL AMT-(FAC+DR) 09";
label variable IPTWCP09 "IP HOSP STAZ-WRKRS COMP AMT-(FAC+DR) 09";
label variable IPTOPR09 "IP HOSP STAZ-OTH PRIVATE AMT-(FAC+DR) 09";
label variable IPTOPU09 "IP HOSP STAZ-OTH PUBLIC AMT-(FAC+DR) 09";
label variable IPTOSR09 "IP HSP STAZ-OTH UNCLS SRC AMT(FAC+DR) 09";
label variable IPFEXP09 "TOT HOSP IP FACILITY EXP-INC 0 NITES 09";
label variable IPFTCH09 "IP HOSP STAY CHARGES - FAC 09";
label variable IPFSLF09 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 09";
label variable IPFMCR09 "IP HOSP STAZ-MEDICARE AMT-FAC 09";
label variable IPFMCD09 "IP HOSP STAZ-MEDICAID AMT-FAC 09";
label variable IPFPRV09 "IP HOSP STAZ-PRIV INS AMT-FAC 09";
label variable IPFVA09 "IP HOSP STAZ-VA/CHAMPVA AMT-FAC 09";
label variable IPFTRI09 "IP HOSP STAZ-TRICARE AMT-FAC 09";
label variable IPFOFD09 "IP HOSP STAZ-OTHER FED AMT-FAC 09";
label variable IPFSTL09 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 09";
label variable IPFWCP09 "IP HOSP STAZ-WORKERS COMP AMT-FAC 09";
label variable IPFOPR09 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 09";
label variable IPFOPU09 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 09";
label variable IPFOSR09 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 09";
label variable IPDEXP09 "TOTL HOSP STAZ DR EXP 09";
label variable IPDTCH09 "IP HOSP STAY CHARGES - DR 09";
label variable IPDSLF09 "IP HOSP STAZ-SELF/FAMILY AMT-DR 09";
label variable IPDMCR09 "IP HOSP STAZ-MEDICARE AMT- DR 09";
label variable IPDMCD09 "IP HOSP STAZ-MEDICAID AMT-DR 09";
label variable IPDPRV09 "IP HOSP STAZ-PRIV INS AMT-DR 09";
label variable IPDVA09 "IP HOSP STAZ-VA/CHAMPVA AMT-DR 09";
label variable IPDTRI09 "IP HOSP STAZ-TRICARE AMT-DR 09";
label variable IPDOFD09 "IP HOSP STAZ-OTHER FED AMT-DR 09";
label variable IPDSTL09 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 09";
label variable IPDWCP09 "IP HOSP STAZ-WORKERS COMP AMT-DR 09";
label variable IPDOPR09 "IP HOSP STAZ - OTH PRIVATE AMT-DR 09";
label variable IPDOPU09 "IP HOSP STAZ - OTH PUBLIC AMT-DR 09";
label variable IPDOSR09 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 09";
label variable IPNGTD09 "# NIGHTS IN HOSP FOR DISCHARGES, 2009";
label variable DVTOT09 "# DENTAL CARE VISITS 09";
label variable DVTTCH09 "TOTAL DENTAL CARE VISIT CHARGES 09";
label variable DVTEXP09 "TOTAL DENTAL CARE EXP 09";
label variable DVTSLF09 "ALL DENTAL CARE - SELF/FAMILY AMT 09";
label variable DVTMCR09 "ALL DENTAL CARE - MEDICARE AMT 09";
label variable DVTMCD09 "ALL DENTAL CARE - MEDICAID AMT 09";
label variable DVTPRV09 "ALL DENTAL CARE - PRIVATE INS AMT 09";
label variable DVTVA09 "ALL DENTAL CARE - VA/CHAMPVA AMT 09";
label variable DVTTRI09 "ALL DENTAL CARE - TRICARE AMT 09";
label variable DVTOFD09 "ALL DENTAL CARE - OTHER FEDRL AMT 09";
label variable DVTSTL09 "ALL DENTAL CARE - OTH ST/LOCAL AMT 09";
label variable DVTWCP09 "ALL DENTAL CARE - WORKERS COMP AMT 09";
label variable DVTOPR09 "ALL DENTAL CARE - OTH PRIVATE AMT 09";
label variable DVTOPU09 "ALL DENTAL CARE - OTH PUBLIC AMT 09";
label variable DVTOSR09 "ALL DENT CARE-OT UNCLASS SRCE AMT 09";
label variable DVGEN09 "# GENERAL DENTIST VISITS 09";
label variable DVGTCH09 "GENERAL DENTAL CARE VISIT CHARGES 09";
label variable DVGEXP09 "TOTAL GENERAL DENTIST EXP 09";
label variable DVGSLF09 "GNRL DENTAL VISITS - SELF/FAM AMT 09";
label variable DVGMCR09 "GNRL DENTAL VISITS - MEDICARE AMT 09";
label variable DVGMCD09 "GNRL DENTAL VISITS - MEDICAID AMT 09";
label variable DVGPRV09 "GNRL DENTAL VISITS - PRIVATE INS AMT 09";
label variable DVGVA09 "GNRL DENTAL VISITS - VA/CHAMPVA AMT 09";
label variable DVGTRI09 "GNRL DENTAL VISITS-TRICARE AMT 09";
label variable DVGOFD09 "GNRL DENTAL VISITS - OTHER FED AMT 09";
label variable DVGSTL09 "GNRL DENTAL VISITS - OTH ST/LOCAL AMT 09";
label variable DVGWCP09 "GNRL DENTAL VISITS - WORKERS COMP AMT 09";
label variable DVGOPR09 "GNRL DENTAL VISITS - OTH PRIVATE AMT 09";
label variable DVGOPU09 "GNRL DENTAL VISITS - OTH PUBLIC AMT 09";
label variable DVGOSR09 "GNRL DENT VSTS - OT UNCLASS SRCE AMT 09";
label variable DVORTH09 "# ORTHODONTIST VISITS 09";
label variable DVOTCH09 "ORTHODONTIST VISIT CHARGES 09";
label variable DVOEXP09 "TOTAL ORTHODONTIST EXP 09";
label variable DVOSLF09 "ORTHODONTIST VISITS - SELF/FAMILY AMT 09";
label variable DVOMCR09 "ORTHODONTIST VISITS - MEDICARE AMT 09";
label variable DVOMCD09 "ORTHODONTIST VISITS - MEDICAID AMT 09";
label variable DVOPRV09 "ORTHODONTIST VISITS - PRIVATE INS AMT 09";
label variable DVOVA09 "ORTHODONTIST VISITS-VA/CHAMPVA AMT 09";
label variable DVOTRI09 "ORTHODONTIST VISITS-TRICARE AMT 09";
label variable DVOOFD09 "ORTHODONTIST VISITS-OTHR FED AMT 09";
label variable DVOSTL09 "ORTHODONTIST VISITS-OTHR ST/LOCAL AMT 09";
label variable DVOWCP09 "ORTHODONTIST VISITS-WORKERS COMP AMT 09";
label variable DVOOPR09 "ORTHODONTIST VISITS-OTHR PRIVATE AMT 09";
label variable DVOOPU09 "ORTHODONTIST VISITS-OTHR PUBLIC AMT 09";
label variable DVOOSR09 "ORTHODONT VSTS - OT UNCLASS SRCE AMT 09";
label variable HHTOTD09 "# HOME HEALTH PROVIDER DAYS, 2009";
label variable HHAGD09 "# AGENCY HOME HEALTH PROVIDER DAYS 09";
label variable HHATCH09 "HOME HEALTH AGENCY VISIT CHARGES 09";
label variable HHAEXP09 "TOTAL HOME HEALTH AGENCY EXP 09";
label variable HHASLF09 "HOME HLTH AGENCY - SELF/FAMILY AMT 09";
label variable HHAMCR09 "HOME HLTH AGENCY - MEDICARE AMT 09";
label variable HHAMCD09 "HOME HLTH AGENCY - MEDICAID AMT 09";
label variable HHAPRV09 "HOME HLTH AGENCY - PRIVATE INS AMT 09";
label variable HHAVA09 "HOME HLTH AGENCY-VA/CHAMPVA AMT 09";
label variable HHATRI09 "HOME HLTH AGENCY-TRICARE AMT 09";
label variable HHAOFD09 "HOME HLTH AGENCY - OTHER FED AMT 09";
label variable HHASTL09 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 09";
label variable HHAWCP09 "HOME HLTH AGENCY - WORKERS COMP AMT 09";
label variable HHAOPR09 "HOME HLTH AGENCY - OTH PRIVATE AMT 09";
label variable HHAOPU09 "HOME HLTH AGENCY - OTH PUBLIC AMT 09";
label variable HHAOSR09 "H HLTH AGENCY - OT UNCLASS SRCE AMT 09";
label variable HHINDD09 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 09";
label variable HHNTCH09 "HOME HEALTH NON-AGENCY VISIT CHARGES 09";
label variable HHNEXP09 "TOTAL HOME HEALTH NON-AGNCY EXP 09";
label variable HHNSLF09 "HOME HLTH NON-AGNCY - SELF/FAM AMT 09";
label variable HHNMCD09 "HOME HLTH NON-AGNCY - MEDICAID AMT 09";
label variable HHNMCR09 "HOME HLTH NON-AGNCY - MEDICARE AMT 09";
label variable HHNPRV09 "HOME HLTH NON-AGNCY - PRIV INS AMT 09";
label variable HHNVA09 "HOME HLTH NON-AGNCY-VA/CHAMPVA AMT 09";
label variable HHNTRI09 "HOME HLTH NON-AGNCY-TRICARE AMT 09";
label variable HHNOFD09 "HOME HLTH NON-AGNCY-OTHR FED AMT 09";
label variable HHNSTL09 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 09";
label variable HHNWCP09 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 09";
label variable HHNOPR09 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 09";
label variable HHNOPU09 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 09";
label variable HHNOSR09 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 09";
label variable HHINFD09 "# INFORMAL HOME HEALTH PROVIDER DAYS 09";
label variable VISEXP09 "TOTAL GLASSES/CONTACT LENS EXP 09";
label variable VISTCH09 "GLASSES/CONTACT LENSES CHARGES 09";
label variable VISSLF09 "GLASSES/CNTCT LENSES -SELF/FAM AMT 09";
label variable VISMCR09 "GLASSES/CNTCT LENSES-MEDICARE AMT 09";
label variable VISMCD09 "GLASSES/CNTCT LENSES-MEDICAID AMT 09";
label variable VISPRV09 "GLASSES/CNTCT LENSES-PRIV INS AMT 09";
label variable VISVA09 "GLASSES/CNTCT LENSES-VA/CHAMPVA AMT 09";
label variable VISTRI09 "GLASSES/LENSES-TRICARE AMT 09";
label variable VISOFD09 "GLASSES/CNTCT LENSES-OTHR FED AMT 09";
label variable VISSTL09 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 09";
label variable VISWCP09 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 09";
label variable VISOPR09 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 09";
label variable VISOPU09 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 09";
label variable VISOSR09 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 09";
label variable OTHTCH09 "OTHER EQUP/SUPPLIES CHARGES 09";
label variable OTHEXP09 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 09";
label variable OTHSLF09 "OTHER EQUP/SUPPLIES-SELF/FAM AMT 09";
label variable OTHMCR09 "OTHER EQUP/SUPPLIES-MEDICARE AMT 09";
label variable OTHMCD09 "OTHER EQUP/SUPPLIES-MEDICAID AMT 09";
label variable OTHPRV09 "OTHER EQUP/SUPPLIES-PRIV INS AMT 09";
label variable OTHVA09 "OTHER EQUP/SUPPLY-VA/CHAMPVA AMT 09";
label variable OTHTRI09 "OTHER EQUP/SUPPLY-TRICARE AMT 09";
label variable OTHOFD09 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 09";
label variable OTHSTL09 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 09";
label variable OTHWCP09 "OTHER EQUP/SUPPLY - WORKERS COMP AMT 09";
label variable OTHOPR09 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 09";
label variable OTHOPU09 "OTHER EQUP/SUPPLY - OTH PUBLIC AMT 09";
label variable OTHOSR09 "OTH EQUP/SUPLY - OT UNCLASS SRCE AMT 09";
label variable RXTOT09 "# PRESC MEDS INCL REFILLS 09";
label variable RXEXP09 "TOTAL RX-EXP 09";
label variable RXSLF09 "TOTAL RX-SELF/FAMILY AMT 09";
label variable RXMCR09 "TOTAL RX-MEDICARE AMT 09";
label variable RXMCD09 "TOTAL RX-MEDICAID AMT 09";
label variable RXPRV09 "TOTAL RX-PRIVATE INS AMT 09";
label variable RXVA09 "TOTAL RX-VA/CHAMPVA AMT 09";
label variable RXTRI09 "TOTAL RX-TRICARE AMT 09";
label variable RXOFD09 "TOTAL RX-OTHER FED AMT 09";
label variable RXSTL09 "TOTAL RX-OTHER ST/LOCAL AMT 09";
label variable RXWCP09 "TOTAL RX-WORKERS COMP AMT 09";
label variable RXOPR09 "TOTAL RX-OTH PRIVATE AMT 09";
label variable RXOPU09 "TOTAL RX-OTH PUBLIC AMT 09";
label variable RXOSR09 "TOT RX-OTH UNCLASS SRCE AMT 09";
label variable TOTPTR09 "TOTAL AMT PAID BY PRV & TRI 09";
label variable TOTOTH09 "TOTAL AMT PAID BY OTH COMBINED 09";
label variable OBVPTR09 "ALL OFFICE VISITS - PRV & TRI AMT 09";
label variable OBVOTH09 "ALL OFFICE VISITS - OTH COMBINED AMT 09";
label variable OBDPTR09 "DR OFFICE VISITS - PRV & TRI AMT 09";
label variable OBDOTH09 "DR OFFICE VISITS - OTH COMBINED AMT 09";
label variable OBOPTR09 "NON-DR OFF VISTS - PRV & TRI AMT 09";
label variable OBOOTH09 "NON-DR OFF VISTS - OTH COMBINED AMT 09";
label variable OBCPTR09 "CHIRO OFF VISITS - PRV & TRI AMT 09";
label variable OBCOTH09 "CHIRO OFF VISITS -OTH COMBINED AMT 09";
label variable OBNPTR09 "NURSE/PRAC OFF VSTS - PRV & TRI AMT 09";
label variable OBNOTH09 "NURSE/PRAC OFF VSTS-OTH COMBINED AMT 09";
label variable OBEPTR09 "OPTOMETRIST OFF VSTS - PRV & TRI AMT 09";
label variable OBEOTH09 "OPTOMETRIST OFF VSTS-OTH COMBINED AMT 09";
label variable OBAPTR09 "PHYS ASST OFF VSTS - PRV & TRI AMT 09";
label variable OBAOTH09 "PHYS ASST OFF VSTS - OTH COMBINED AMT 09";
label variable OBTPTR09 "PT/OT OFF VISITS - PRV & TRI AMT 09";
label variable OBTOTH09 "PT/OT OFF VISITS - OTH COMBINED AMT 09";
label variable OPTPTR09 "ALL OPD VISITS-PRV & TRI AMT (FAC+DR) 09";
label variable OPTOTH09 "ALL OPD VSTS-OTH COMBINED AMT(FAC+DR) 09";
label variable OPFPTR09 "ALL OPD VISITS - PRV & TRI AMT-FAC 09";
label variable OPFOTH09 "ALL OPD VISITS - OTH COMBINED AMT-FAC 09";
label variable OPDPTR09 "ALL OPD VISITS-PRV & TRI AMT -DR 09";
label variable OPDOTH09 "ALL OPD VISITS-OTH COMBINED AMT-DR 09";
label variable OPVPTR09 "OPD DR VISITS - PRV & TRI AMT-FAC 09";
label variable OPVOTH09 "OPD DR VISITS - OTH COMBINED AMT-FAC 09";
label variable OPSPTR09 "OPD DR VISITS - PRV & TRI AMT-DR 09";
label variable OPSOTH09 "OPD DR VISITS -OTH COMBINED AMT-DR 09";
label variable OPOPTR09 "OPD NON-DR VISITS - PRV & TRI AMT-FAC 09";
label variable OPOOTH09 "OPD NON-DR VISITS-OTH COMBINED AM-FAC 09";
label variable OPPPTR09 "OPD NON-DR VISITS - PRV & TRI AMT-DR 09";
label variable OPPOTH09 "OPD NON-DR VISITS-OTH COMBINED AMT-DR 09";
label variable AMCPTR09 "CHIRO AMB VISITS -PRV & TRI AMT 09";
label variable AMCOTH09 "CHIRO AMB VISITS - OTH COMBINED AMT 09";
label variable AMNPTR09 "NRS/PRAC AMB VSTS - PRV & TRI AMT 09";
label variable AMNOTH09 "NRS/PRAC AMB VSTS - OTH COMBINED AMT 09";
label variable AMEPTR09 "OPTMTRIST AMB VSTS - PRV & TRI AMT 09";
label variable AMEOTH09 "OPTMTRIST AMB VSTS - OTH COMBINED AMT 09";
label variable AMAPTR09 "PHYS ASS T AMB VSTS - PRV & TRI AMT 09";
label variable AMAOTH09 "PHYS ASS T AMB VSTS-OTH COMBINED AMT 09";
label variable AMTPTR09 "PT/OT AMB VISITS -PRV & TRI AMT 09";
label variable AMTOTH09 "PT/OT AMB VISITS - OTH COMBINED AMT 09";
label variable ERTPTR09 "ER-PRV & TRI AMT (FAC+DR) 09";
label variable ERTOTH09 "ER -OTH COMBINED AMT (FAC+DR) 09";
label variable ERFPTR09 "ER-PRV & TRI AMT - FAC 09";
label variable ERFOTH09 "ER-OTH COMBINED AMT - FAC 09";
label variable ERDPTR09 "ER-PRV & TRI AMT - DR 09";
label variable ERDOTH09 "ER-OTH COMBINED AMT - DR 09";
label variable ZIFPTR09 "ZERO-NITE IP STAZ-PRV & TRI AMT-FAC 09";
label variable ZIFOTH09 "ZERO-NITE IP STAZ-OTH COMBINE AMT-FAC 09";
label variable ZIDPTR09 "ZERO-NITE IP STAZ-PRV & TRI AMT-DR 09";
label variable ZIDOTH09 "ZERO-NITE IP STAZ-OTH COMBINED AMT-DR 09";
label variable IPTPTR09 "IP HOSP STAZ-PRV & TRI AMT-(FAC+DR) 09";
label variable IPTOTH09 "IP HOSP STAZ-OTH COMBINED AMT(FAC+DR) 09";
label variable IPFPTR09 "IP HOSP STAZ-PRV & TRI AMT-FAC 09";
label variable IPFOTH09 "IP HOSP STAZ-OTH COMBINED AMT-FAC 09";
label variable IPDPTR09 "IP HOSP STAZ-PRV & TRI AMT-DR 09";
label variable IPDOTH09 "IP HOSP STAZ-OTH COMBINED AMT-DR 09";
label variable DVTPTR09 "ALL DENTAL CARE - PRV & TRI AMT 09";
label variable DVTOTH09 "ALL DENTAL CARE - OTH COMBINED AMT 09";
label variable DVGPTR09 "GNRL DENTAL VISITS - PRV & TRI AMT 09";
label variable DVGOTH09 "GNRL DENTAL VISITS - OTH COMBINED AMT 09";
label variable DVOPTR09 "ORTHODONTIST VISITS - PRV & TRI AMT 09";
label variable DVOOTH09 "ORTHODONTIST VISITS-OTH COMBINED AMT 08";
label variable HHAPTR09 "HOME HLTH AGENCY - PRV & TRI AMT 09";
label variable HHAOTH09 "HOME HLTH AGENCY - OTH COMBINED AMT 09";
label variable HHNPTR09 "HOME HLTH NON-AGNCY - PRV & TRI AMT 09";
label variable HHNOTH09 "HOME HLTH NON-AGNCY-OTH COMBINED AMT 09";
label variable VISPTR09 "GLASSES/CNTCT LENSES-PRV & TRI AMT 09";
label variable VISOTH09 "GLASSES/CNTCT LENSES-OTH COMBINED AMT 09";
label variable OTHPTR09 "OTHER EQUP/SUPPLY - PRV & TRI AMT 09";
label variable OTHOTH09 "OTHER EQUP/SUPPLY - OTH COMBINED AMT 09";
label variable RXPTR09 "TOTAL RX-PRV & TRI AMT 09";
label variable RXOTH09 "TOTAL RX-OTH COMBINED AMT 09";
label variable PERWT09F "FINAL PERSON WEIGHT, 2009";
label variable FAMWT09F "FINAL FAMILY WEIGHT, 2009";
label variable FAMWT09C "POV ADJ FAMILY WGT-CPS FAM ON 12/31/09";
label variable SAQWT09F "FINAL SAQ PERSON WEIGHT, 2009";
label variable DIABW09F "FINAL DIABETES CARE SUPPLEMENT WEIGHT";
label variable VARSTR "VARIANCE ESTIMATION STRATUM - 2009";
label variable VARPSU "VARIANCE ESTIMATION PSU - 2009";


*DEFINE VALUE LABELS FOR REPORTS;
label define H1290001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H1290002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1290003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1290004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1290005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H1290008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1290009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H1290010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H1290014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1290015X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H1290016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1290018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1290019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1290020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1290021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H1290024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1290025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1290027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1290028X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1290029X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H1290030X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290031X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290033X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH VERSION SAQ WAS ADMINISTERED"
         2 "2 SPANISH VERSION SAQ WAS ADMINISTERED" ;

label define H1290034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1290038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1290039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1290040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290041X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1290042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1290043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 HAD NO VISITS IN THE LAST 12 MONTHS" ;

label define H1290044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1290045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT AT ALL"
         2 "2 A LITTLE BIT"
         3 "3 MODERATELY"
         4 "4 QUITE A BIT"
         5 "5 EXTREMELY" ;

label define H1290046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1290047X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1290048X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF-ADMINISTERED"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         100 "100 INTERVIEWER ADMINISTERED"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP - /HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 PARTNER'S DAUGHTER"
         33 "33 PARTNER'S SON"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP - /HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 PARENT"
         48 "48 GRANDPARENT"
         49 "49 NOT PERSON ON SAQ LABEL,RELATIONSHIP UNK"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1290049X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1290050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1290051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1290052X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1290053X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290054X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1290055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1290056X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290057X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1290058X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290059X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1290060X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1290061X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1290062X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AFDC"
         2 "2 NOT AFDC" ;

label define H1290063X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1290064X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290065X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290066X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1290067X
         0 "0.00"
         190 "$1 - $190" ;

label define H1290068X
         0 "0.00"
         39 "$1 - $39" ;

label define H1290069X
         0 "0.00"
         1194 "$1 - $1,194" ;

label define H1290070X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290071X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290072X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290073X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 NO VISITS IN LAST 12 MONTHS" ;

label define H1290074X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 NO VISITS IN LAST 12 MONTHS" ;

label define H1290075X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290076X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290077X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290078X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290079X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 RHEUMATOID ARTHRITIS"
         2 "2 OSTEOARTHRITIS"
         3 "3 NOT SPECIFIED" ;

label define H1290080X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290081X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290082X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290083X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290084X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290085X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290086X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290087X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290088X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290089X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290090X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290091X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290092X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290093X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290094X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST 2 YEARS"
         2 "2 WITHIN PAST 3 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H1290095X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9  NOT ASCERTAINED"
         1 "1 WITHIN PAST 2 YEARS"
         2 "2 WITHIN PAST 3 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H1290096X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN LAST 7 DAYS"
         2 "2 MORE THAN 7, BUT WITHIN LAST 30 DAYS"
         3 "3 MORE THAN 30 DAYS AGO" ;

label define H1290097X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290098X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290099X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290100X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1290101X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1290102X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1290103X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2008 "2008 YEAR"
         2009 "2009 YEAR" ;

label define H1290104X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2009 "2009 YEAR" ;

label define H1290105X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2009 "2009 YEAR"
         2010 "2010 YEAR" ;

label define H1290106X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1290107X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1290108X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290109X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290110X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290111X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290112X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290113X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290114X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290115X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290116X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1290117X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290118X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290119X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290120X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290121X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290122X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1290123X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290124X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1290125X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1290126X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1290127X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1290128X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1290129X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1290130X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290131X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290132X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290133X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290134X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290135X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290136X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290137X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290138X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290139X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290140X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290141X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290142X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290143X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290144X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290145X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290146X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290148X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290149X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290150X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290151X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290152X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290154X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290155X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290158X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290159X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290161X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H1290162X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290164X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1290169X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1290171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1290172X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1290173X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H1290174X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H1290175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H1290176X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290177X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1290178X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290179X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290180X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290181X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1290182X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1290183X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290184X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290185X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290186X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290187X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290188X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1290189X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290190X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290191X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290192X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290193X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1290194X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1290195X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290196X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1290197X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290198X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290199X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290200X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290201X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290202X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290203X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290204X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290205X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290206X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H1290207X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1290208X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1290209X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H1290210X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H1290211X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290212X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290213X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290214X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290215X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNKNOWN" ;

label define H1290216X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1290217X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290218X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290219X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1290220X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290222X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290223X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290224X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290225X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290226X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290227X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290228X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290229X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290230X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1290231X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ITEMIZED DEDUCTIONS"
         2 "2 STANDARD DEDUCTIONS" ;

label define H1290232X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290233X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 TWICE A YEAR OR MORE"
         2 "2 ONCE A YEAR"
         3 "3 LESS THAN ONCE A YEAR"
         4 "4 NEVER GO TO DENTIST" ;

label define H1290234X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290235X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290236X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290237X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H1290238X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1290239X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290240X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290241X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290242X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H1290243X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H1290244X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H1290245X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1290246X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1290247X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1290248X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1290249X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290250X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290251X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1290252X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1290253X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290254X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290255X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290256X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1290257X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1290258X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1290259X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290260X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290261X
         -1 "-1 INAPPLICABLE"
         1 "1 DEPS IN RU"
         2 "2 DEPS IN AND OUT OF RU"
         3 "3 DEPS OUT OF RU" ;

label define H1290262X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO DEPENDENTS OUTSIDE RU"
         1 "1 ONE DEPENDENT OUTSIDE RU"
         2 "2 TWO DEPENDENTS OUTSIDE RU"
         3 "3 THREE DEPENDENTS OUTSIDE RU" ;

label define H1290263X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE"
         96 "96 DID NOT HAVE BLOOD TEST" ;

label define H1290264X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290265X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290266X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290267X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290268X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290269X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290270X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290271X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290272X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT CONFIDENT AT ALL"
         2 "2 SOMEWHAT CONFIDENT"
         3 "3 CONFIDENT"
         4 "4 VERY CONFIDENT" ;

label define H1290273X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290274X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290275X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290276X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290277X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290278X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290279X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290280X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290281X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290282X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290283X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290285X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8  DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290286X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290287X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290288X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290289X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290290X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290291X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290292X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290293X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290294X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290295X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290296X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290297X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290298X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290299X
         0 "0.00"
         188 "$1 - $188" ;

label define H1290300X
         0 "0.00"
         307 "$1 - $307" ;

label define H1290301X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290302X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290303X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO SCHOOL/KINDERGARTEN ONLY"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H1290304X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H1290305X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1290306X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1290307X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1290308X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1290309X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290310X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290311X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H1290312X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H1290313X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H1290314X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290315X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290316X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290317X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290318X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1290319X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1290320X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1290321X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1290322X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2009 "2009 YEAR" ;

label define H1290323X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2009 "2009 YEAR" ;

label define H1290324X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2009 "2009 YEAR" ;

label define H1290325X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2009 "2009 YEAR"
         2010 "2010 YEAR" ;

label define H1290326X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290327X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290328X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290329X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290330X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290331X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290332X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290333X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290334X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290335X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H1290336X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1290337X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1290338X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1290339X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H1290340X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290341X
         -1 "-1 INAPPLICABLE"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H1290342X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H1290343X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1290344X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H1290345X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1290346X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1290347X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290348X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290349X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0.00" ;

label define H1290350X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1290351X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1290352X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1290353X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1290354X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 DO NOT HAVE PERSONAL DOCTOR OR NURSE" ;

label define H1290355X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 DO NOT HAVE PERSONAL DOCTOR OR NURSE" ;

label define H1290356X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H1290357X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DRIVE"
         2 "2 IS DRIVEN"
         3 "3 TAXI, BUS, TRAIN, OTHER PUBLIC TRANSPO"
         4 "4 WALKS"
         5 "5 SOME OTHER WAY" ;

label define H1290358X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290359X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1290360X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290361X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290362X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290363X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SLIGHT IMPAIRMENT"
         3 "3 MODERATE IMPAIRMENT"
         4 "4 MAJOR IMPAIRMENT"
         5 "5 DEAF" ;

label define H1290364X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290365X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290366X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290367X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290368X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290369X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290370X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290371X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290372X
         0 "0.00"
         4306 "$1 - $4,306" ;

label define H1290373X
         0 "0.00"
         38960 "$1 - $38,960" ;

label define H1290374X
         0 "0.00"
         623 "$1 - $623" ;

label define H1290375X
         0 "0.00"
         140 "$1 - $140" ;

label define H1290376X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290377X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290378X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290379X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16-INAPPLICABLE" ;

label define H1290380X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H1290381X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PUERTO RICAN"
         2 "2 CUBAN/CUBAN AMERICAN"
         3 "3 DOMINICAN"
         4 "4 MEXICAN/MEXICAN AMERICAN"
         5 "5 CENTRAL OR SOUTH AMERICAN"
         6 "6 NON-HISPANIC"
         91 "91 OTHER LATIN AMERICAN"
         92 "92 OTHER HISPANIC/LATINO" ;

label define H1290382X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1290383X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1290384X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1290385X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1290386X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1290387X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290388X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290389X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290390X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290391X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290392X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290393X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290394X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290395X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290396X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290397X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290398X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290399X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290400X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290401X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290402X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290403X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290404X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290405X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290406X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290407X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290408X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290409X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290410X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290411X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290412X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290413X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290414X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290415X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290416X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290417X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290418X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290419X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290420X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290421X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290422X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290423X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290424X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290425X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290426X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290427X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290428X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290429X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290430X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290431X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290432X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290433X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290434X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290435X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290436X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290437X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290438X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290439X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290440X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290441X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290442X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290443X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290444X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290445X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290446X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290447X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290448X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290449X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290450X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290451X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290452X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290453X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290454X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290455X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290456X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290457X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290458X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290459X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290460X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290461X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290462X
         -1 "-1 INAPPLICABLE"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1290463X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1290464X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1290465X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $74.52"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290466X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $74.52"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290467X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $74.52"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290468X
         0 "0 NO"
         1 "1 YES" ;

label define H1290469X
         0 "0 NO"
         1 "1 YES" ;

label define H1290470X
         0 "0 NO"
         1 "1 YES" ;

label define H1290471X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290472X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290473X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290474X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290475X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290476X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290477X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290478X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290479X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290480X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290481X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1290482X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1290483X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1290484X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290485X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290486X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290487X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290488X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290489X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290490X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290491X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290492X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290493X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290494X
         1 "1 IN-SCOPE ON 12/31/2009"
         2 "2 NOT IN-SCOPE ON 12/31/2009" ;

label define H1290495X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/09"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1290496X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/09"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1290497X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/09"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1290498X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/09"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1290499X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 2009"
         2 "2 OUT-OF-SCOPE FOR ALL OF 2009" ;

label define H1290500X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H1290501X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290502X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290503X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290504X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290505X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290506X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290507X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290508X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290509X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290510X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290511X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290512X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290513X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290514X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1290515X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ENGLISH & SPANISH"
         91 "91 OTHER" ;

label define H1290516X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290517X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290518X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1290519X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290520X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1290521X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1290522X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1290523X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290524X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290525X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290526X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290527X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290528X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H1290529X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290530X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290531X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1290532X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290533X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ANOTHER LANGUAGE" ;

label define H1290534X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290535X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290536X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290537X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290538X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1290539X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1290540X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290541X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290542X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290543X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290544X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 OFFICE"
         2 "2 HOSPITAL, NOT ER"
         3 "3 HOSPITAL, ER" ;

label define H1290545X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290546X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290547X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1290548X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290549X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290550X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290551X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290552X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290553X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1290554X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H1290555X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1290556X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1290557X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1290558X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290559X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290560X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290561X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290562X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290563X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290564X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290565X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290566X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290567X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290568X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290569X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290570X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290571X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290572X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290573X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290574X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290575X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290576X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290577X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290578X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290579X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290580X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290581X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290582X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290583X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290584X
         1 "1 YES"
         2 "2 NO" ;

label define H1290585X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290586X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290587X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1290588X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1290589X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1290590X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290591X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290592X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290593X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290594X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290595X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290596X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290597X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290598X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1290599X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1290600X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1290601X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290602X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290603X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290604X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290605X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290606X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290607X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290608X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290609X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290610X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290611X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290612X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290613X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290614X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290615X
         1 "1 YES"
         2 "2 NO" ;

label define H1290616X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290617X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290618X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290619X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290620X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290621X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290622X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290623X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290624X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290625X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290626X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290627X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290628X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290629X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290630X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290631X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290632X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1290633X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1290634X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1290635X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1290636X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1290637X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1290638X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1290639X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1290640X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1290641X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1290642X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1290643X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1290644X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290645X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290646X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290647X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290648X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1290649X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1290650X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290651X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1290652X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1290653X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290654X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290655X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H1290656X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290657X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H1290658X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290659X
         -1 "-1 INAPPLICALBE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290660X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290661X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1290662X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1290663X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290664X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1290665X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1290666X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1290667X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1290668X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290669X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290670X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290671X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290672X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1290673X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1290674X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1290675X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290676X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290677X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1290678X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1290679X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1290680X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1290681X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290682X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290683X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290684X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290685X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1290686X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1290687X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290688X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290689X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$74.52"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290690X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$74.52"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290691X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$74.52"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290692X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290693X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290694X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290695X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290696X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290697X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290698X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WEEKS"
         2 "2 MONTHS" ;

label define H1290699X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290700X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290701X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290702X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290703X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290704X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290705X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1290706X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1290707X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1290708X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290709X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290710X
         0 "0.00"
         190 "$1 - $190" ;

label define H1290711X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290712X
         0 "0.00"
         39 "$1 - $39" ;

label define H1290713X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290714X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290715X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290716X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290717X
         0 "0.00"
         1194 "$1 - $1,194" ;

label define H1290718X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290719X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1996"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1290720X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1996"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1290721X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1996"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1290722X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290723X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290724X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290725X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290726X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290727X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290728X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290729X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290730X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290731X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290732X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290733X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290734X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290735X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290736X
         1 "1 YES"
         2 "2 NO" ;

label define H1290737X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290738X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290739X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290740X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290741X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290742X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290743X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290744X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290745X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290746X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290747X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290748X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290749X
         1 "1 YES"
         2 "2 NO" ;

label define H1290750X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290751X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290752X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290753X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290754X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290755X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290756X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290757X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290758X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290759X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290760X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290761X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290762X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290763X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290764X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290765X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1290766X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290767X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290768X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290769X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290770X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290771X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290772X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290773X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290774X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290775X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290776X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290777X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290778X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290779X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290780X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290781X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290782X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290783X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290784X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290785X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290786X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290787X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290788X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290789X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290790X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290791X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290792X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290793X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290794X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290795X
         13 "13 PANEL 13"
         14 "14 PANEL 14" ;

label define H1290796X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1290797X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290798X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290799X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290800X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290801X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290802X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290803X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1290804X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1290805X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1290806X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1290807X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1290808X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1290809X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290810X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290811X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290812X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290813X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290814X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290815X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290816X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290817X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290818X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290819X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290820X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290821X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290822X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290823X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290824X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290825X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290826X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290827X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290828X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290829X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290830X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290831X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290832X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290833X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290834X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1290835X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290836X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H1290837X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H1290838X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H1290839X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1290840X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290841X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT APPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290842X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290843X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOSPITAL CLINIC/OUTPATIENT DEPT"
         2 "2 HOSPITAL EMERGENCY ROOM"
         3 "3 NON-HOSPITAL PLACE" ;

label define H1290844X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290845X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290846X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290847X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1290848X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1290849X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290850X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290851X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290852X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290853X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290854X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1290855X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1290856X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1290857X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1290858X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290859X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290860X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290861X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H1290862X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H1290863X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H1290864X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290865X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1290866X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1290867X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290868X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290869X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290870X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290871X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290872X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290873X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290874X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290875X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290876X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290877X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290878X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290879X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290880X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290881X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290882X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290883X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290884X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290885X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290886X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290887X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290888X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290889X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290890X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290891X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290892X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290893X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290894X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290895X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290896X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290897X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290898X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290899X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290900X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290901X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290902X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290903X
         1 "1 POOR/NEGATIVE"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H1290904X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290905X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290906X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST-NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H1290907X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H1290908X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H1290909X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290910X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290911X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290912X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290913X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290914X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290915X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290916X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290917X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290918X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290919X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290920X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290921X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290922X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290923X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290924X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290925X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290926X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290927X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290928X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290929X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290930X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290931X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290932X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290933X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290934X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290935X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290936X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290937X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290938X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290939X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290940X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290941X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290942X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290943X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290944X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290945X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290946X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290947X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290948X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290949X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290950X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290951X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290952X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290953X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290954X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290955X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290956X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290957X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290958X
         -1 "-1 INAPPLICABLE"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROVIDER" ;

label define H1290959X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1290960X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1290961X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1290962X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1290963X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290964X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290965X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290966X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290967X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290968X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290969X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290970X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290971X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290972X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290973X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290974X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290975X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1290976X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1290977X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1290978X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1290979X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1290980X
         1 "1 YES"
         2 "2 NO" ;

label define H1290981X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1290982X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1290983X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1290984X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1290985X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1290986X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1290987X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1290988X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1290989X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1290990X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1290991X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290992X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290993X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290994X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290995X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290996X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290997X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290998X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1290999X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291000X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291002X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291003X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1291004X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291005X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291006X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291007X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291008X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291009X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291010X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291011X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291012X
         -1 "-1 INAPPLICABLE"
         1 "1 ASIAN - NO OTHER RACE REPORTED"
         2 "2 ASIAN - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1291013X
         -1 "-1 INAPPLICABLE"
         1 "1 BLACK - NO OTHER RACE REPORTED"
         2 "2 BLACK - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1291014X
         1 "1 PERSON IS HISPANIC"
         2 "2 PERSON IS BLACK-NO OTH RACE/NOT HISPANIC"
         3 "3 PERSON IS ASIAN-NO OTH RACE/NOT HISPANIC"
         4 "4 OTHER RACE/NOT HISPANIC" ;

label define H1291015X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 WHITE - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1291016X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE - NO OTH RAC"
         4 "4 ASIAN - NO OTHER RACE REPORTED"
         5 "5 NATIVE HAWAIIAN/PACIFIC ISLANDER-NO OTHR"
         6 "6 MULTIPLE RACES REPORTED" ;

label define H1291017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1291018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1291019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1291022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291024X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1291025X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1291026X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1291027X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1291028X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1291029X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1291030X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1291031X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1291032X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1291033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1291034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291035X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291036X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 FOSTER SISTER"
         48 "48 FOSTER BROTHER"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1291038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 FOSTER SISTER"
         48 "48 FOSTER BROTHER"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1291039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 FOSTER SISTER"
         48 "48 FOSTER BROTHER"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1291040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 FOSTER SISTER"
         48 "48 FOSTER BROTHER"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1291041X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H1291042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1291043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1291044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1291045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1291046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1291047X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1291048X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1291049X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1291050X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1291051X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1291052X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1291053X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1291054X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1291055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291056X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1291057X
         0 "0 NOT ELIGIBLE"
         1 "1 ELIGIBLE FOR SAQ - HAS SAQ DATA"
         2 "2 ELIGIBLE FOR SAQ - NO SAQ DATA" ;

label define H1291058X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1291059X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291060X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291061X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1291062X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1291063X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1291064X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1291065X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALWAYS"
         2 "2 NEARLY ALWAYS"
         3 "3 SOMETIMES"
         4 "4 SELDOM"
         5 "5 NEVER"
         6 "6 NEVER DRIVES/RIDES IN A CAR" ;

label define H1291066X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291067X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291068X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291069X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291070X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291071X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H1291072X
         -1 "-1 INAPPLICABLE"
         0 "0 NO"
         1 "1 YES" ;

label define H1291073X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1291074X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1291075X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1291076X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1291077X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291078X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291079X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291080X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1291081X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291082X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1291083X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291084X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291085X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291086X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1291087X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1291088X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1291089X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1291090X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1291091X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1291092X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1291093X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1291094X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1291095X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1291096X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISABILITY"
         2 "2 SOME OTHER REASON" ;

label define H1291097X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1291098X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1291099X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1291100X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1291101X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291102X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291103X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291104X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291105X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291106X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291107X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291108X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291109X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291110X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291111X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291112X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291113X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291114X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291115X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291116X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291117X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1291118X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1291119X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1291120X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1291121X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1291122X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1291123X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1291124X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1291125X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1291126X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1291127X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1291128X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1291129X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291130X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291131X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H1291132X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H1291133X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291134X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291135X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291136X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291137X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1291138X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291139X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG FORM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORM 1040EZ"
         91 "91 OTHER" ;

label define H1291140X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1291141X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1291142X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1291143X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1291144X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291145X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1291146X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291148X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 15 MINUTES"
         2 "2 15 TO 30 MINUTES"
         3 "3 31 TO 60 MINUTES (1 HOUR)"
         4 "4 61 TO 90 MINUTES"
         5 "5 91 MINUTES TO 120 MINUTES (2 HOURS)"
         6 "6 MORE THAN 120 MINUTES (2 HOURS)" ;

label define H1291149X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0.00" ;

label define H1291150X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291151X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1291152X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291153X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291154X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291155X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291156X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291157X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291158X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291159X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1291160X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1291161X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1291162X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291163X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291164X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291165X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291166X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291167X
         1 "1 YES"
         2 "2 NO" ;

label define H1291168X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1291169X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1291170X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1291171X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291172X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291173X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291174X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291175X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1291176X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1291177X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1291178X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291179X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291180X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291181X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291182X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1291183X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1291184X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1291185X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1291186X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV  BY TRICARE/CHAMPVA" ;

label define H1291187X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1291188X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1291189X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1291190X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1291191X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291192X
         -1 "-1 INAPPLICABLE"
         1 "1 MD - GENERAL/FAMILY PRACTICE"
         10 "10 PHYSICIAN'S ASSISTANT"
         11 "11 OTHER NON-MD PROVIDER"
         12 "12 UNKNOWN"
         13 "13 MD - CARDIOLOGIST"
         14 "14 DOCTOR OF OSTEOPATHY"
         15 "15 MD - ENDOCRINOLOGIST"
         16 "16 MD - GASTROENTEROLOGIST"
         17 "17 MD - GERIATRICIAN"
         18 "18 MD - NEPHROLOGIST"
         19 "19 MD - ONCOLOGIST"
         2 "2 MD - INTERNAL MEDICINE"
         20 "20 MD - PULMONOLOGIST"
         21 "21 MD - RHEUMATOLOGIST"
         22 "22 PSYCHIATRIST/PSYCHOLOGIST"
         23 "23 MD - NEUROLOGIST"
         24 "24 ALTERNATIVE CARE PROVIDER"
         3 "3 MD - PEDIATRICS"
         4 "4 MD - OB/GYN"
         5 "5 MD - SURGERY"
         6 "6 MD - OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE"
         9 "9 NURSE PRACTITIONER" ;

label define H1291193X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291194X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291195X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1291196X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1291197X
         1 "1 YES"
         2 "2 NO" ;

label define H1291198X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291199X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291200X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291201X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291202X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291203X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1291204X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1291205X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291206X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1291207X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 IMPAIRED NEAR, BUT NOT FAR"
         4 "4 IMPAIRED BOTH NEAR AND FAR"
         5 "5 BLIND" ;

label define H1291208X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1291209X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291210X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291211X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291212X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291213X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291214X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291215X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291216X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291217X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291218X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291219X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291220X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291222X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291223X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1291224X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291225X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1291226X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1291227X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1291228X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1291229X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1291230X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1291231X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1291232X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1291233X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1291234X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1291235X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1291236X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291237X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1291238X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1291239X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1291240X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291241X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291242X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1291243X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1291244X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291245X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291246X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291247X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1291248X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291249X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1291250X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H1291251X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H1291252X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEM"
         91 "91 SOME OTHER REASON" ;

label define H1291253X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEM"
         91 "91 SOME OTHER REASON" ;

label define H1291254X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEMS"
         91 "91 SOME OTHER REASON" ;

label define H1291255X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELDOM OR NEVER SICK"
         10 "10 NO HEALTH INSURANCE"
         11 "11 JOB-RELATED REASONS"
         12 "12 LOOKING FOR A NEW DOCTOR/NO DOCTOR YET"
         13 "13 USC DOCTOR IS SOMEWHERE ELSE"
         14 "14 DON'T LIKE/DON'T TRUST DOCTORS"
         15 "15 HEALTH-RELATED REASONS"
         16 "16 NEWBORN - NO DOCTOR YET"
         17 "17 SELF, RELATIVE, OR FRIEND IS A DOCTOR"
         19 "19 CARE AVAILABLE ON JOB"
         2 "2 RECENTLY MOVED TO AREA"
         20 "20 WILL NOT GO TO THE DOCTOR"
         21 "21 PROBLEMS WITH TIME AND TRANSPORTATION"
         22 "22 GOES TO HOSPITAL/EMERGENCY ROOM/CLINIC"
         23 "23 USES ALTERNATIVE CARE"
         24 "24 INSURANCE-RELATED REASONS"
         3 "3 DON'T KNOW WHERE TO GO"
         4 "4 USC IN AREA NOT AVAILABLE"
         5 "5 CAN'T FIND PROVIDER WHO SPEAKS LANGUAGE"
         6 "6 GOES DIFFERENT PLACES FOR DIFF NEEDS"
         7 "7 JUST CHANGED INSURANCE PLANS"
         8 "8 DON'T USE DOCS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

label define H1291256X
         0 "0.00"
         1205 "$1 - $1,205" ;

label define H1291257X
         0 "0.00"
         86 "$1 - $86" ;

label define H1291258X
         0 "0.00"
         746 "$1 - $746" ;

label define H1291259X
         0 "0.00"
         1662 "$1 - $1,662" ;

label define H1291260X
         0 "0.00"
         1210 "$1 - $1,210" ;

label define H1291261X
         0 "0.00"
         652 "$1 - $652" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELI42 H1290001X;
label value ACTDTY31 H1290002X;
label value ACTDTY42 H1290003X;
label value ACTDTY53 H1290004X;
label value ACTLIM31 H1290005X;
label value ACTLIM53 H1290006X;
label value ADAPPT42 H1290007X;
label value ADCAPE42 H1290008X;
label value ADCLIM42 H1290009X;
label value ADCMPD42 H1290010X;
label value ADCMPM42 H1290011X;
label value ADCMPY42 H1290012X;
label value ADDAYA42 H1290013X;
label value ADDOWN42 H1290014X;
label value ADDPRS42 H1290015X;
label value ADDRBP42 H1290016X;
label value ADEFRT42 H1290017X;
label value ADEGMC42 H1290018X;
label value ADEXPL42 H1290019X;
label value ADGENH42 H1290020X;
label value ADHDADDX H1290021X;
label value ADHDAGED H1290022X;
label value ADHECR42 H1290023X;
label value ADHOPE42 H1290024X;
label value ADILCR42 H1290025X;
label value ADILWW42 H1290026X;
label value ADINSA42 H1290027X;
label value ADINSB42 H1290028X;
label value ADINTR42 H1290029X;
label value ADL3MO31 H1290030X;
label value ADL3MO42 H1290031X;
label value ADL3MO53 H1290032X;
label value ADLANG42 H1290033X;
label value ADLHLP31 H1290034X;
label value ADLHLP42 H1290035X;
label value ADLHLP53 H1290036X;
label value ADLIST42 H1290037X;
label value ADMALS42 H1290038X;
label value ADMWLM42 H1290039X;
label value ADNDCR42 H1290040X;
label value ADNERV42 H1290041X;
label value ADNRGY42 H1290042X;
label value ADNSMK42 H1290043X;
label value ADOVER42 H1290044X;
label value ADPAIN42 H1290045X;
label value ADPALS42 H1290046X;
label value ADPRTM42 H1290047X;
label value ADPRX42 H1290048X;
label value ADPWLM42 H1290049X;
label value ADRESP42 H1290050X;
label value ADREST42 H1290051X;
label value ADRISK42 H1290052X;
label value ADRTCR42 H1290053X;
label value ADRTWW42 H1290054X;
label value ADSAD42 H1290055X;
label value ADSMOK42 H1290056X;
label value ADSOCA42 H1290057X;
label value ADSPEC42 H1290058X;
label value ADSPRF42 H1290059X;
label value ADUPRO42 H1290060X;
label value ADWRTH42 H1290061X;
label value AFDC09 H1290062X;
label value AFTHOU42 H1290063X;
label value AIDHLP31 H1290064X;
label value AIDHLP53 H1290065X;
label value ALIIMP09 H1290066X;
label value AMCOPU09 H1290067X;
label value AMEOPU09 H1290068X;
label value AMTOFD09 H1290069X;
label value ANGIAGED H1290070X;
label value ANGIDX H1290071X;
label value ANYLIM09 H1290072X;
label value APRDLM42 H1290073X;
label value APRDLT42 H1290074X;
label value APRTRM42 H1290075X;
label value APRTRT42 H1290076X;
label value ARTHAGED H1290077X;
label value ARTHDX H1290078X;
label value ARTHTYPE H1290079X;
label value ASACUT53 H1290080X;
label value ASATAK31 H1290081X;
label value ASATAK53 H1290082X;
label value ASDALY53 H1290083X;
label value ASEVFL53 H1290084X;
label value ASIANP42 H1290085X;
label value ASMRCN53 H1290086X;
label value ASPKFL53 H1290087X;
label value ASPREV53 H1290088X;
label value ASPRIN53 H1290089X;
label value ASSTIL31 H1290090X;
label value ASSTIL53 H1290091X;
label value ASTHAGED H1290092X;
label value ASTHDX H1290093X;
label value ASTHEP31 H1290094X;
label value ASTHEP53 H1290095X;
label value ASWNFL53 H1290096X;
label value BEGRFD31 H1290097X;
label value BEGRFD42 H1290098X;
label value BEGRFD53 H1290099X;
label value BEGRFM31 H1290100X;
label value BEGRFM42 H1290101X;
label value BEGRFM53 H1290102X;
label value BEGRFY31 H1290103X;
label value BEGRFY42 H1290104X;
label value BEGRFY53 H1290105X;
label value BENDIF31 H1290106X;
label value BENDIF53 H1290107X;
label value BLCKPR42 H1290108X;
label value BLDRAGED H1290109X;
label value BLDRREMS H1290110X;
label value BLIND42 H1290111X;
label value BMINDX53 H1290112X;
label value BONEAGED H1290113X;
label value BONEREMS H1290114X;
label value BOOST42 H1290115X;
label value BPCHEK53 H1290116X;
label value BPMLDX H1290117X;
label value BPMONT53 H1290118X;
label value BRAIAGED H1290119X;
label value BRAIREMS H1290120X;
label value BRSTAGED H1290121X;
label value BRSTEX53 H1290122X;
label value BRSTREMS H1290123X;
label value BSNTY31 H1290124X;
label value BSNTY42 H1290125X;
label value BSNTY53 H1290126X;
label value BSTSRE53 H1290127X;
label value BSTST53 H1290128X;
label value BUSIMP09 H1290129X;
label value CABLADDR H1290130X;
label value CABONE H1290131X;
label value CABRAIN H1290132X;
label value CABREAST H1290133X;
label value CACERVIX H1290134X;
label value CACOLON H1290135X;
label value CAKIDNEY H1290136X;
label value CALARYNX H1290137X;
label value CALEUKEM H1290138X;
label value CALIVER H1290139X;
label value CALUNG H1290140X;
label value CALYMPH H1290141X;
label value CAMELANO H1290142X;
label value CAMOUTH H1290143X;
label value CAMUSCLE H1290144X;
label value CANCERDX H1290145X;
label value CAOTHER H1290146X;
label value CAOVARY H1290147X;
label value CAPANCRS H1290148X;
label value CAPROSTA H1290149X;
label value CARECO42 H1290150X;
label value CARECTUM H1290151X;
label value CASKINDK H1290152X;
label value CASKINNM H1290153X;
label value CASTOMCH H1290154X;
label value CATESTIS H1290155X;
label value CATHROAT H1290156X;
label value CATHYROD H1290157X;
label value CAUTERUS H1290158X;
label value CERVAGED H1290159X;
label value CERVREMS H1290160X;
label value CHAPPT42 H1290161X;
label value CHBMIX42 H1290162X;
label value CHBRON31 H1290163X;
label value CHBRON53 H1290164X;
label value CHCOUN42 H1290165X;
label value CHDAGED H1290166X;
label value CHDDX H1290167X;
label value CHECK53 H1290168X;
label value CHEMPB42 H1290169X;
label value CHENEC42 H1290170X;
label value CHEXPL42 H1290171X;
label value CHEYRE42 H1290172X;
label value CHGJ3142 H1290173X;
label value CHGJ4253 H1290174X;
label value CHHECR42 H1290175X;
label value CHILCR42 H1290176X;
label value CHILWW42 H1290177X;
label value CHLICO42 H1290178X;
label value CHLIHB42 H1290179X;
label value CHLIMI42 H1290180X;
label value CHLIMP09 H1290181X;
label value CHLIST42 H1290182X;
label value CHNDCR42 H1290183X;
label value CHOIC31 H1290184X;
label value CHOIC42 H1290185X;
label value CHOIC53 H1290186X;
label value CHOLAGED H1290187X;
label value CHOLCK53 H1290188X;
label value CHOLDX H1290189X;
label value CHPMCN42 H1290190X;
label value CHPMED42 H1290191X;
label value CHPMHB42 H1290192X;
label value CHPRTM42 H1290193X;
label value CHRESP42 H1290194X;
label value CHRTCR42 H1290195X;
label value CHRTWW42 H1290196X;
label value CHSERV42 H1290197X;
label value CHSPEC42 H1290198X;
label value CHSRCN42 H1290199X;
label value CHSRHB42 H1290200X;
label value CHTHCO42 H1290201X;
label value CHTHER42 H1290202X;
label value CHTHHB42 H1290203X;
label value CLINIC42 H1290204X;
label value CLMDEP09 H1290205X;
label value CLMHIP09 H1290206X;
label value CLNTRE53 H1290207X;
label value CLNTST53 H1290208X;
label value COGLIM31 H1290209X;
label value COGLIM53 H1290210X;
label value COLOAGED H1290211X;
label value COLOREMS H1290212X;
label value COVRMM H1290213X;
label value COVRYY H1290214X;
label value CSHCN42 H1290215X;
label value CSHIMP09 H1290216X;
label value CSTSVM42 H1290217X;
label value CSTSVT42 H1290218X;
label value DADPRO42 H1290219X;
label value DDBDYS31 H1290220X;
label value DDBDYS42 H1290221X;
label value DDBDYS53 H1290222X;
label value DDNSCL31 H1290223X;
label value DDNSCL42 H1290224X;
label value DDNSCL53 H1290225X;
label value DDNWRK31 H1290226X;
label value DDNWRK42 H1290227X;
label value DDNWRK53 H1290228X;
label value DEAF42 H1290229X;
label value DECIDE42 H1290230X;
label value DEDUCT09 H1290231X;
label value DENTAL42 H1290232X;
label value DENTCK53 H1290233X;
label value DENTIN31 H1290234X;
label value DENTIN42 H1290235X;
label value DENTIN53 H1290236X;
label value DEPDNT09 H1290237X;
label value DFTOUS42 H1290238X;
label value DIABAGED H1290239X;
label value DIABDX H1290240X;
label value DIFFPL42 H1290241X;
label value DIFFWG31 H1290242X;
label value DIFFWG42 H1290243X;
label value DIFFWG53 H1290244X;
label value DISVW31X H1290245X;
label value DISVW42X H1290246X;
label value DISVW53X H1290247X;
label value DIVIMP09 H1290248X;
label value DKWHRU42 H1290249X;
label value DNDLAY42 H1290250X;
label value DNDLPR42 H1290251X;
label value DNDLRS42 H1290252X;
label value DNTINS09 H1290253X;
label value DNTINS31 H1290254X;
label value DNUNAB42 H1290255X;
label value DNUNPR42 H1290256X;
label value DNUNRS42 H1290257X;
label value DOBMM H1290258X;
label value DOBYY H1290259X;
label value DOCELS42 H1290260X;
label value DPINRU09 H1290261X;
label value DPOTSD09 H1290262X;
label value DSA1C53 H1290263X;
label value DSCB0853 H1290264X;
label value DSCGRP53 H1290265X;
label value DSCH0853 H1290266X;
label value DSCH0953 H1290267X;
label value DSCH1053 H1290268X;
label value DSCHNV53 H1290269X;
label value DSCINT53 H1290270X;
label value DSCNPC53 H1290271X;
label value DSCONF53 H1290272X;
label value DSCPCP53 H1290273X;
label value DSCPHN53 H1290274X;
label value DSDIA53 H1290275X;
label value DSDIET53 H1290276X;
label value DSEB0853 H1290277X;
label value DSEY0853 H1290278X;
label value DSEY0953 H1290279X;
label value DSEY1053 H1290280X;
label value DSEYNV53 H1290281X;
label value DSEYPR53 H1290282X;
label value DSFB0853 H1290283X;
label value DSFL0853 H1290284X;
label value DSFL0953 H1290285X;
label value DSFL1053 H1290286X;
label value DSFLNV53 H1290287X;
label value DSFT0853 H1290288X;
label value DSFT0953 H1290289X;
label value DSFT1053 H1290290X;
label value DSFTNV53 H1290291X;
label value DSINSU53 H1290292X;
label value DSKIDN53 H1290293X;
label value DSMED53 H1290294X;
label value DSPRX53 H1290295X;
label value DSVB0853 H1290296X;
label value DVGEN09 H1290297X;
label value DVORTH09 H1290298X;
label value DVOVA09 H1290299X;
label value DVOWCP09 H1290300X;
label value DVTOT09 H1290301X;
label value EATHLT42 H1290302X;
label value EDUCYR H1290303X;
label value EICRDT09 H1290304X;
label value ELGRND09 H1290305X;
label value ELGRND31 H1290306X;
label value ELGRND42 H1290307X;
label value ELGRND53 H1290308X;
label value EMPHAGED H1290309X;
label value EMPHDX H1290310X;
label value EMPST31 H1290311X;
label value EMPST42 H1290312X;
label value EMPST53 H1290313X;
label value ENDRFD09 H1290314X;
label value ENDRFD31 H1290315X;
label value ENDRFD42 H1290316X;
label value ENDRFD53 H1290317X;
label value ENDRFM09 H1290318X;
label value ENDRFM31 H1290319X;
label value ENDRFM42 H1290320X;
label value ENDRFM53 H1290321X;
label value ENDRFY09 H1290322X;
label value ENDRFY31 H1290323X;
label value ENDRFY42 H1290324X;
label value ENDRFY53 H1290325X;
label value ENGCMF42 H1290326X;
label value ENGSPK42 H1290327X;
label value ERTOT09 H1290328X;
label value EVRETIRE H1290329X;
label value EVRUNAT H1290330X;
label value EVRUNINS H1290331X;
label value EVRWRK H1290332X;
label value EXPLOP42 H1290333X;
label value EXRCIS53 H1290334X;
label value FAMRFPYR H1290335X;
label value FAMSZE31 H1290336X;
label value FAMSZE42 H1290337X;
label value FAMSZE53 H1290338X;
label value FCRP1231 H1290339X;
label value FILEDR09 H1290340X;
label value FILER09 H1290341X;
label value FLSTAT09 H1290342X;
label value FLUSHT53 H1290343X;
label value FMRS1231 H1290344X;
label value FNGRDF31 H1290345X;
label value FNGRDF53 H1290346X;
label value FOODMN09 H1290347X;
label value FOODST09 H1290348X;
label value FOODVL09 H1290349X;
label value FTSTU09X H1290350X;
label value FTSTU31X H1290351X;
label value FTSTU42X H1290352X;
label value FTSTU53X H1290353X;
label value GDCPBM42 H1290354X;
label value GDCPBT42 H1290355X;
label value GENDRP42 H1290356X;
label value GOTOUS42 H1290357X;
label value HAVEUS42 H1290358X;
label value HAVFUN42 H1290359X;
label value HEARAD42 H1290360X;
label value HEARDI42 H1290361X;
label value HEARMO42 H1290362X;
label value HEARNG42 H1290363X;
label value HEARSM42 H1290364X;
label value HELD31X H1290365X;
label value HELD42X H1290366X;
label value HELD53X H1290367X;
label value HELMET42 H1290368X;
label value HHAGD09 H1290369X;
label value HHINDD09 H1290370X;
label value HHINFD09 H1290371X;
label value HHNOFD09 H1290372X;
label value HHNOPR09 H1290373X;
label value HHNOPU09 H1290374X;
label value HHNTRI09 H1290375X;
label value HHTOTD09 H1290376X;
label value HIBPAGED H1290377X;
label value HIBPDX H1290378X;
label value HIDEG H1290379X;
label value HISPANX H1290380X;
label value HISPCAT H1290381X;
label value HLTHLF42 H1290382X;
label value HOMEBH42 H1290383X;
label value HONRDC31 H1290384X;
label value HONRDC42 H1290385X;
label value HONRDC53 H1290386X;
label value HOUR31 H1290387X;
label value HOUR42 H1290388X;
label value HOUR53 H1290389X;
label value HPDAP09 H1290390X;
label value HPDAU09 H1290391X;
label value HPDDE09 H1290392X;
label value HPDFE09 H1290393X;
label value HPDJA09 H1290394X;
label value HPDJL09 H1290395X;
label value HPDJU09 H1290396X;
label value HPDMA09 H1290397X;
label value HPDMY09 H1290398X;
label value HPDNO09 H1290399X;
label value HPDOC09 H1290400X;
label value HPDSE09 H1290401X;
label value HPEAP09 H1290402X;
label value HPEAU09 H1290403X;
label value HPEDE09 H1290404X;
label value HPEFE09 H1290405X;
label value HPEJA09 H1290406X;
label value HPEJL09 H1290407X;
label value HPEJU09 H1290408X;
label value HPEMA09 H1290409X;
label value HPEMY09 H1290410X;
label value HPENO09 H1290411X;
label value HPEOC09 H1290412X;
label value HPESE09 H1290413X;
label value HPNAP09 H1290414X;
label value HPNAU09 H1290415X;
label value HPNDE09 H1290416X;
label value HPNFE09 H1290417X;
label value HPNJA09 H1290418X;
label value HPNJL09 H1290419X;
label value HPNJU09 H1290420X;
label value HPNMA09 H1290421X;
label value HPNMY09 H1290422X;
label value HPNNO09 H1290423X;
label value HPNOC09 H1290424X;
label value HPNSE09 H1290425X;
label value HPOAP09 H1290426X;
label value HPOAU09 H1290427X;
label value HPODE09 H1290428X;
label value HPOFE09 H1290429X;
label value HPOJA09 H1290430X;
label value HPOJL09 H1290431X;
label value HPOJU09 H1290432X;
label value HPOMA09 H1290433X;
label value HPOMY09 H1290434X;
label value HPONO09 H1290435X;
label value HPOOC09 H1290436X;
label value HPOSE09 H1290437X;
label value HPRAP09 H1290438X;
label value HPRAU09 H1290439X;
label value HPRDE09 H1290440X;
label value HPRFE09 H1290441X;
label value HPRJA09 H1290442X;
label value HPRJL09 H1290443X;
label value HPRJU09 H1290444X;
label value HPRMA09 H1290445X;
label value HPRMY09 H1290446X;
label value HPRNO09 H1290447X;
label value HPROC09 H1290448X;
label value HPRSE09 H1290449X;
label value HPSAP09 H1290450X;
label value HPSAU09 H1290451X;
label value HPSDE09 H1290452X;
label value HPSFE09 H1290453X;
label value HPSJA09 H1290454X;
label value HPSJL09 H1290455X;
label value HPSJU09 H1290456X;
label value HPSMA09 H1290457X;
label value HPSMY09 H1290458X;
label value HPSNO09 H1290459X;
label value HPSOC09 H1290460X;
label value HPSSE09 H1290461X;
label value HRHOW31 H1290462X;
label value HRHOW42 H1290463X;
label value HRHOW53 H1290464X;
label value HRWG31X H1290465X;
label value HRWG42X H1290466X;
label value HRWG53X H1290467X;
label value HRWGIM31 H1290468X;
label value HRWGIM42 H1290469X;
label value HRWGIM53 H1290470X;
label value HSELIM31 H1290471X;
label value HSELIM53 H1290472X;
label value HSPLAP42 H1290473X;
label value HYSTER53 H1290474X;
label value IADL3M31 H1290475X;
label value IADL3M42 H1290476X;
label value IADL3M53 H1290477X;
label value IADLHP31 H1290478X;
label value IADLHP42 H1290479X;
label value IADLHP53 H1290480X;
label value INDCAT31 H1290481X;
label value INDCAT42 H1290482X;
label value INDCAT53 H1290483X;
label value INS09X H1290484X;
label value INS31X H1290485X;
label value INS42X H1290486X;
label value INS53X H1290487X;
label value INSAP09X H1290488X;
label value INSAT09X H1290489X;
label value INSAT31X H1290490X;
label value INSAT42X H1290491X;
label value INSAT53X H1290492X;
label value INSAU09X H1290493X;
label value INSC1231 H1290494X;
label value INSCOP09 H1290495X;
label value INSCOP31 H1290496X;
label value INSCOP42 H1290497X;
label value INSCOP53 H1290498X;
label value INSCOPE H1290499X;
label value INSCOV09 H1290500X;
label value INSDE09X H1290501X;
label value INSENDMM H1290502X;
label value INSENDYY H1290503X;
label value INSFE09X H1290504X;
label value INSJA09X H1290505X;
label value INSJL09X H1290506X;
label value INSJU09X H1290507X;
label value INSMA09X H1290508X;
label value INSMY09X H1290509X;
label value INSNO09X H1290510X;
label value INSOC09X H1290511X;
label value INSRPL42 H1290512X;
label value INSSE09X H1290513X;
label value INTIMP09 H1290514X;
label value INTVLANG H1290515X;
label value IPDIS09 H1290516X;
label value IPZERO09 H1290517X;
label value IRAIMP09 H1290518X;
label value JNTPID09 H1290519X;
label value JOBORG31 H1290520X;
label value JOBORG42 H1290521X;
label value JOBORG53 H1290522X;
label value JOBRSN42 H1290523X;
label value JTINRU09 H1290524X;
label value JTPAIN31 H1290525X;
label value JTPAIN53 H1290526X;
label value K6SUM42 H1290527X;
label value KEYNESS H1290528X;
label value KIDNAGED H1290529X;
label value KIDNREMS H1290530X;
label value KIDPRO42 H1290531X;
label value KNOWDR42 H1290532X;
label value LANGHM42 H1290533X;
label value LANGPR42 H1290534X;
label value LAPBLT42 H1290535X;
label value LEUKAGED H1290536X;
label value LEUKREMS H1290537X;
label value LFTDIF31 H1290538X;
label value LFTDIF53 H1290539X;
label value LIVRAGED H1290540X;
label value LIVRREMS H1290541X;
label value LKINFM42 H1290542X;
label value LKINFT42 H1290543X;
label value LOCATN42 H1290544X;
label value LRNXAGED H1290545X;
label value LRNXREMS H1290546X;
label value LSHLTH42 H1290547X;
label value LSTETH53 H1290548X;
label value LUNGAGED H1290549X;
label value LUNGREMS H1290550X;
label value LYMPAGED H1290551X;
label value LYMPREMS H1290552X;
label value MAMOGR53 H1290553X;
label value MARRY09X H1290554X;
label value MARRY31X H1290555X;
label value MARRY42X H1290556X;
label value MARRY53X H1290557X;
label value MCAID09 H1290558X;
label value MCAID09X H1290559X;
label value MCAID31 H1290560X;
label value MCAID31X H1290561X;
label value MCAID42 H1290562X;
label value MCAID42X H1290563X;
label value MCAID53 H1290564X;
label value MCAID53X H1290565X;
label value MCARE09 H1290566X;
label value MCARE09X H1290567X;
label value MCARE31 H1290568X;
label value MCARE31X H1290569X;
label value MCARE42 H1290570X;
label value MCARE42X H1290571X;
label value MCARE53 H1290572X;
label value MCARE53X H1290573X;
label value MCDAP09 H1290574X;
label value MCDAP09X H1290575X;
label value MCDAT09X H1290576X;
label value MCDAT31X H1290577X;
label value MCDAT42X H1290578X;
label value MCDAT53X H1290579X;
label value MCDAU09 H1290580X;
label value MCDAU09X H1290581X;
label value MCDDE09 H1290582X;
label value MCDDE09X H1290583X;
label value MCDEV09 H1290584X;
label value MCDFE09 H1290585X;
label value MCDFE09X H1290586X;
label value MCDHMO09 H1290587X;
label value MCDHMO31 H1290588X;
label value MCDHMO42 H1290589X;
label value MCDJA09 H1290590X;
label value MCDJA09X H1290591X;
label value MCDJL09 H1290592X;
label value MCDJL09X H1290593X;
label value MCDJU09 H1290594X;
label value MCDJU09X H1290595X;
label value MCDMA09 H1290596X;
label value MCDMA09X H1290597X;
label value MCDMC09 H1290598X;
label value MCDMC31 H1290599X;
label value MCDMC42 H1290600X;
label value MCDMY09 H1290601X;
label value MCDMY09X H1290602X;
label value MCDNO09 H1290603X;
label value MCDNO09X H1290604X;
label value MCDOC09 H1290605X;
label value MCDOC09X H1290606X;
label value MCDSE09 H1290607X;
label value MCDSE09X H1290608X;
label value MCRAP09 H1290609X;
label value MCRAP09X H1290610X;
label value MCRAU09 H1290611X;
label value MCRAU09X H1290612X;
label value MCRDE09 H1290613X;
label value MCRDE09X H1290614X;
label value MCREV09 H1290615X;
label value MCRFE09 H1290616X;
label value MCRFE09X H1290617X;
label value MCRJA09 H1290618X;
label value MCRJA09X H1290619X;
label value MCRJL09 H1290620X;
label value MCRJL09X H1290621X;
label value MCRJU09 H1290622X;
label value MCRJU09X H1290623X;
label value MCRMA09 H1290624X;
label value MCRMA09X H1290625X;
label value MCRMY09 H1290626X;
label value MCRMY09X H1290627X;
label value MCRNO09 H1290628X;
label value MCRNO09X H1290629X;
label value MCROC09 H1290630X;
label value MCROC09X H1290631X;
label value MCRPB09 H1290632X;
label value MCRPB31 H1290633X;
label value MCRPB42 H1290634X;
label value MCRPD09 H1290635X;
label value MCRPD09X H1290636X;
label value MCRPD31 H1290637X;
label value MCRPD31X H1290638X;
label value MCRPD42 H1290639X;
label value MCRPD42X H1290640X;
label value MCRPHO09 H1290641X;
label value MCRPHO31 H1290642X;
label value MCRPHO42 H1290643X;
label value MCRSE09 H1290644X;
label value MCRSE09X H1290645X;
label value MCS42 H1290646X;
label value MDDLAY42 H1290647X;
label value MDDLPR42 H1290648X;
label value MDDLRS42 H1290649X;
label value MDUNAB42 H1290650X;
label value MDUNPR42 H1290651X;
label value MDUNRS42 H1290652X;
label value MELAAGED H1290653X;
label value MELAREMS H1290654X;
label value MESBPR42 H1290655X;
label value MESHGT42 H1290656X;
label value MESVIS42 H1290657X;
label value MESWGT42 H1290658X;
label value MIAGED H1290659X;
label value MIDX H1290660X;
label value MILDIF31 H1290661X;
label value MILDIF53 H1290662X;
label value MINORP42 H1290663X;
label value MNHLTH31 H1290664X;
label value MNHLTH42 H1290665X;
label value MNHLTH53 H1290666X;
label value MOMPRO42 H1290667X;
label value MORE31 H1290668X;
label value MORE42 H1290669X;
label value MORE53 H1290670X;
label value MORECOVR H1290671X;
label value MORJOB31 H1290672X;
label value MORJOB42 H1290673X;
label value MORJOB53 H1290674X;
label value MOUTAGED H1290675X;
label value MOUTREMS H1290676X;
label value MSA09 H1290677X;
label value MSA31 H1290678X;
label value MSA42 H1290679X;
label value MSA53 H1290680X;
label value MUSCAGED H1290681X;
label value MUSCREMS H1290682X;
label value MYSELF42 H1290683X;
label value NATAMP42 H1290684X;
label value NERVAF42 H1290685X;
label value NEVILL42 H1290686X;
label value NEWARE42 H1290687X;
label value NEWDOC42 H1290688X;
label value NHRWG31 H1290689X;
label value NHRWG42 H1290690X;
label value NHRWG53 H1290691X;
label value NOASPR53 H1290692X;
label value NOFAT53 H1290693X;
label value NOGODR42 H1290694X;
label value NOHINS42 H1290695X;
label value NOINSBEF H1290696X;
label value NOINSTM H1290697X;
label value NOINUNIT H1290698X;
label value NOLIKE42 H1290699X;
label value NOREAS42 H1290700X;
label value NOSMOK42 H1290701X;
label value NUMEMP31 H1290702X;
label value NUMEMP42 H1290703X;
label value NUMEMP53 H1290704X;
label value NWK31 H1290705X;
label value NWK42 H1290706X;
label value NWK53 H1290707X;
label value OBASST09 H1290708X;
label value OBCHIR09 H1290709X;
label value OBCOPU09 H1290710X;
label value OBDRV09 H1290711X;
label value OBEOPU09 H1290712X;
label value OBNURS09 H1290713X;
label value OBOPTO09 H1290714X;
label value OBOTHV09 H1290715X;
label value OBTHER09 H1290716X;
label value OBTOFD09 H1290717X;
label value OBTOTV09 H1290718X;
label value OCCCAT31 H1290719X;
label value OCCCAT42 H1290720X;
label value OCCCAT53 H1290721X;
label value OFFER31X H1290722X;
label value OFFER42X H1290723X;
label value OFFER53X H1290724X;
label value OFFHOU42 H1290725X;
label value OFREMP31 H1290726X;
label value OFREMP42 H1290727X;
label value OFREMP53 H1290728X;
label value OHRTAGED H1290729X;
label value OHRTDX H1290730X;
label value ONGONG42 H1290731X;
label value ONJOB42 H1290732X;
label value OPAAP09 H1290733X;
label value OPAAU09 H1290734X;
label value OPADE09 H1290735X;
label value OPAEV09 H1290736X;
label value OPAFE09 H1290737X;
label value OPAJA09 H1290738X;
label value OPAJL09 H1290739X;
label value OPAJU09 H1290740X;
label value OPAMA09 H1290741X;
label value OPAMY09 H1290742X;
label value OPANO09 H1290743X;
label value OPAOC09 H1290744X;
label value OPASE09 H1290745X;
label value OPBAP09 H1290746X;
label value OPBAU09 H1290747X;
label value OPBDE09 H1290748X;
label value OPBEV09 H1290749X;
label value OPBFE09 H1290750X;
label value OPBJA09 H1290751X;
label value OPBJL09 H1290752X;
label value OPBJU09 H1290753X;
label value OPBMA09 H1290754X;
label value OPBMY09 H1290755X;
label value OPBNO09 H1290756X;
label value OPBOC09 H1290757X;
label value OPBSE09 H1290758X;
label value OPDRV09 H1290759X;
label value OPOTHV09 H1290760X;
label value OPTOTV09 H1290761X;
label value OTHDYS31 H1290762X;
label value OTHDYS42 H1290763X;
label value OTHDYS53 H1290764X;
label value OTHIMP09 H1290765X;
label value OTHINS42 H1290766X;
label value OTHNDD31 H1290767X;
label value OTHNDD42 H1290768X;
label value OTHNDD53 H1290769X;
label value OTHRAGED H1290770X;
label value OTHRCP42 H1290771X;
label value OTHREA42 H1290772X;
label value OTHRREMS H1290773X;
label value OTPAAT09 H1290774X;
label value OTPAAT31 H1290775X;
label value OTPAAT42 H1290776X;
label value OTPAAT53 H1290777X;
label value OTPBAT09 H1290778X;
label value OTPBAT31 H1290779X;
label value OTPBAT42 H1290780X;
label value OTPBAT53 H1290781X;
label value OTPUBA09 H1290782X;
label value OTPUBA31 H1290783X;
label value OTPUBA42 H1290784X;
label value OTPUBA53 H1290785X;
label value OTPUBB09 H1290786X;
label value OTPUBB31 H1290787X;
label value OTPUBB42 H1290788X;
label value OTPUBB53 H1290789X;
label value OVRYAGED H1290790X;
label value OVRYREMS H1290791X;
label value PACISP42 H1290792X;
label value PANCAGED H1290793X;
label value PANCREMS H1290794X;
label value PANEL H1290795X;
label value PAPSMR53 H1290796X;
label value PAYDR31 H1290797X;
label value PAYDR42 H1290798X;
label value PAYDR53 H1290799X;
label value PAYVAC31 H1290800X;
label value PAYVAC42 H1290801X;
label value PAYVAC53 H1290802X;
label value PBINFM42 H1290803X;
label value PBINFT42 H1290804X;
label value PBPWKM42 H1290805X;
label value PBPWKT42 H1290806X;
label value PBSVCM42 H1290807X;
label value PBSVCT42 H1290808X;
label value PCS42 H1290809X;
label value PDKAP09 H1290810X;
label value PDKAU09 H1290811X;
label value PDKDE09 H1290812X;
label value PDKFE09 H1290813X;
label value PDKJA09 H1290814X;
label value PDKJL09 H1290815X;
label value PDKJU09 H1290816X;
label value PDKMA09 H1290817X;
label value PDKMY09 H1290818X;
label value PDKNO09 H1290819X;
label value PDKOC09 H1290820X;
label value PDKSE09 H1290821X;
label value PEGAP09 H1290822X;
label value PEGAU09 H1290823X;
label value PEGDE09 H1290824X;
label value PEGFE09 H1290825X;
label value PEGJA09 H1290826X;
label value PEGJL09 H1290827X;
label value PEGJU09 H1290828X;
label value PEGMA09 H1290829X;
label value PEGMY09 H1290830X;
label value PEGNO09 H1290831X;
label value PEGOC09 H1290832X;
label value PEGSE09 H1290833X;
label value PENIMP09 H1290834X;
label value PERSLA42 H1290835X;
label value PHMONP09 H1290836X;
label value PHMONP31 H1290837X;
label value PHMONP42 H1290838X;
label value PHNREG42 H1290839X;
label value PHQ242 H1290840X;
label value PHYACT53 H1290841X;
label value PHYSCL42 H1290842X;
label value PLCTYP42 H1290843X;
label value PMDINS09 H1290844X;
label value PMDINS31 H1290845X;
label value PMDLAY42 H1290846X;
label value PMDLPR42 H1290847X;
label value PMDLRS42 H1290848X;
label value PMEDIN31 H1290849X;
label value PMEDIN42 H1290850X;
label value PMEDIN53 H1290851X;
label value PMEDPP31 H1290852X;
label value PMEDPP42 H1290853X;
label value PMEDPP53 H1290854X;
label value PMEDPY31 H1290855X;
label value PMEDPY42 H1290856X;
label value PMEDPY53 H1290857X;
label value PMEDUP31 H1290858X;
label value PMEDUP42 H1290859X;
label value PMEDUP53 H1290860X;
label value PMNCNP09 H1290861X;
label value PMNCNP31 H1290862X;
label value PMNCNP42 H1290863X;
label value PMUNAB42 H1290864X;
label value PMUNPR42 H1290865X;
label value PMUNRS42 H1290866X;
label value PNGAP09 H1290867X;
label value PNGAU09 H1290868X;
label value PNGDE09 H1290869X;
label value PNGFE09 H1290870X;
label value PNGJA09 H1290871X;
label value PNGJL09 H1290872X;
label value PNGJU09 H1290873X;
label value PNGMA09 H1290874X;
label value PNGMY09 H1290875X;
label value PNGNO09 H1290876X;
label value PNGOC09 H1290877X;
label value PNGSE09 H1290878X;
label value POGAP09 H1290879X;
label value POGAU09 H1290880X;
label value POGDE09 H1290881X;
label value POGFE09 H1290882X;
label value POGJA09 H1290883X;
label value POGJL09 H1290884X;
label value POGJU09 H1290885X;
label value POGMA09 H1290886X;
label value POGMY09 H1290887X;
label value POGNO09 H1290888X;
label value POGOC09 H1290889X;
label value POGSE09 H1290890X;
label value POUAP09 H1290891X;
label value POUAU09 H1290892X;
label value POUDE09 H1290893X;
label value POUFE09 H1290894X;
label value POUJA09 H1290895X;
label value POUJL09 H1290896X;
label value POUJU09 H1290897X;
label value POUMA09 H1290898X;
label value POUMY09 H1290899X;
label value POUNO09 H1290900X;
label value POUOC09 H1290901X;
label value POUSE09 H1290902X;
label value POVCAT09 H1290903X;
label value PPRWKM42 H1290904X;
label value PPRWKT42 H1290905X;
label value PRDRNP09 H1290906X;
label value PRDRNP31 H1290907X;
label value PRDRNP42 H1290908X;
label value PREGNT31 H1290909X;
label value PREGNT42 H1290910X;
label value PREGNT53 H1290911X;
label value PREVCOVR H1290912X;
label value PREVEN42 H1290913X;
label value PRIAP09 H1290914X;
label value PRIAU09 H1290915X;
label value PRIDE09 H1290916X;
label value PRIDK09 H1290917X;
label value PRIDK31 H1290918X;
label value PRIDK42 H1290919X;
label value PRIDK53 H1290920X;
label value PRIEU09 H1290921X;
label value PRIEU31 H1290922X;
label value PRIEU42 H1290923X;
label value PRIEU53 H1290924X;
label value PRIFE09 H1290925X;
label value PRIJA09 H1290926X;
label value PRIJL09 H1290927X;
label value PRIJU09 H1290928X;
label value PRIMA09 H1290929X;
label value PRIMY09 H1290930X;
label value PRING09 H1290931X;
label value PRING31 H1290932X;
label value PRING42 H1290933X;
label value PRING53 H1290934X;
label value PRINO09 H1290935X;
label value PRIOC09 H1290936X;
label value PRIOG09 H1290937X;
label value PRIOG31 H1290938X;
label value PRIOG42 H1290939X;
label value PRIOG53 H1290940X;
label value PRIS09 H1290941X;
label value PRIS31 H1290942X;
label value PRIS42 H1290943X;
label value PRIS53 H1290944X;
label value PRISE09 H1290945X;
label value PRIV09 H1290946X;
label value PRIV31 H1290947X;
label value PRIV42 H1290948X;
label value PRIV53 H1290949X;
label value PRIVAT09 H1290950X;
label value PRIVAT31 H1290951X;
label value PRIVAT42 H1290952X;
label value PRIVAT53 H1290953X;
label value PROUT09 H1290954X;
label value PROUT31 H1290955X;
label value PROUT42 H1290956X;
label value PROUT53 H1290957X;
label value PROVTY42 H1290958X;
label value PROXY09 H1290959X;
label value PROXY31 H1290960X;
label value PROXY42 H1290961X;
label value PROXY53 H1290962X;
label value PRSAP09 H1290963X;
label value PRSAU09 H1290964X;
label value PRSDE09 H1290965X;
label value PRSFE09 H1290966X;
label value PRSJA09 H1290967X;
label value PRSJL09 H1290968X;
label value PRSJU09 H1290969X;
label value PRSMA09 H1290970X;
label value PRSMY09 H1290971X;
label value PRSNO09 H1290972X;
label value PRSOC09 H1290973X;
label value PRSSE09 H1290974X;
label value PRSTAGED H1290975X;
label value PRSTREMS H1290976X;
label value PRVDRL09 H1290977X;
label value PRVDRL31 H1290978X;
label value PRVDRL42 H1290979X;
label value PRVEV09 H1290980X;
label value PRVHMO09 H1290981X;
label value PRVHMO31 H1290982X;
label value PRVHMO42 H1290983X;
label value PRVMNC09 H1290984X;
label value PRVMNC31 H1290985X;
label value PRVMNC42 H1290986X;
label value PSA53 H1290987X;
label value PSTATS31 H1290988X;
label value PSTATS42 H1290989X;
label value PSTATS53 H1290990X;
label value PUB09X H1290991X;
label value PUB31X H1290992X;
label value PUB42X H1290993X;
label value PUB53X H1290994X;
label value PUBAP09X H1290995X;
label value PUBAT09X H1290996X;
label value PUBAT31X H1290997X;
label value PUBAT42X H1290998X;
label value PUBAT53X H1290999X;
label value PUBAU09X H1291000X;
label value PUBDE09X H1291001X;
label value PUBFE09X H1291002X;
label value PUBIMP09 H1291003X;
label value PUBJA09X H1291004X;
label value PUBJL09X H1291005X;
label value PUBJU09X H1291006X;
label value PUBMA09X H1291007X;
label value PUBMY09X H1291008X;
label value PUBNO09X H1291009X;
label value PUBOC09X H1291010X;
label value PUBSE09X H1291011X;
label value RACEAX H1291012X;
label value RACEBX H1291013X;
label value RACETHNX H1291014X;
label value RACEWX H1291015X;
label value RACEX H1291016X;
label value RCHDIF31 H1291017X;
label value RCHDIF53 H1291018X;
label value READNW42 H1291019X;
label value RECPEP42 H1291020X;
label value RECTAGED H1291021X;
label value RECTREMS H1291022X;
label value REFFRL42 H1291023X;
label value REFIMP09 H1291024X;
label value REGION09 H1291025X;
label value REGION31 H1291026X;
label value REGION42 H1291027X;
label value REGION53 H1291028X;
label value RESP09 H1291029X;
label value RESP31 H1291030X;
label value RESP42 H1291031X;
label value RESP53 H1291032X;
label value RESPCT42 H1291033X;
label value RETPLN31 H1291034X;
label value RETPLN42 H1291035X;
label value RETPLN53 H1291036X;
label value RFREL09X H1291037X;
label value RFREL31X H1291038X;
label value RFREL42X H1291039X;
label value RFREL53X H1291040X;
label value RNDFLG31 H1291041X;
label value RTHLTH31 H1291042X;
label value RTHLTH42 H1291043X;
label value RTHLTH53 H1291044X;
label value RTPLNM42 H1291045X;
label value RTPLNT42 H1291046X;
label value RUCLAS09 H1291047X;
label value RUCLAS31 H1291048X;
label value RUCLAS42 H1291049X;
label value RUCLAS53 H1291050X;
label value RUSIZE09 H1291051X;
label value RUSIZE31 H1291052X;
label value RUSIZE42 H1291053X;
label value RUSIZE53 H1291054X;
label value SAFEST42 H1291055X;
label value SALIMP09 H1291056X;
label value SAQELIG H1291057X;
label value SCHLBH42 H1291058X;
label value SCHLIM31 H1291059X;
label value SCHLIM53 H1291060X;
label value SCHPRO42 H1291061X;
label value SCLNBD31 H1291062X;
label value SCLNBD42 H1291063X;
label value SCLNBD53 H1291064X;
label value SEATBE53 H1291065X;
label value SEEDIF42 H1291066X;
label value SELDSI42 H1291067X;
label value SELFCM31 H1291068X;
label value SELFCM42 H1291069X;
label value SELFCM53 H1291070X;
label value SEX H1291071X;
label value SFFLAG42 H1291072X;
label value SGMTRE53 H1291073X;
label value SGMTST53 H1291074X;
label value SIBPRO42 H1291075X;
label value SICEAS42 H1291076X;
label value SICPAY31 H1291077X;
label value SICPAY42 H1291078X;
label value SICPAY53 H1291079X;
label value SKDKAGED H1291080X;
label value SKDKREMS H1291081X;
label value SKNMAGED H1291082X;
label value SKNMREMS H1291083X;
label value SOCLIM31 H1291084X;
label value SOCLIM53 H1291085X;
label value SPOUID09 H1291086X;
label value SPOUID31 H1291087X;
label value SPOUID42 H1291088X;
label value SPOUID53 H1291089X;
label value SPOUIN09 H1291090X;
label value SPOUIN31 H1291091X;
label value SPOUIN42 H1291092X;
label value SPOUIN53 H1291093X;
label value SPRPRO42 H1291094X;
label value SSCIMP09 H1291095X;
label value SSIDIS09 H1291096X;
label value SSIIMP09 H1291097X;
label value SSNLJB31 H1291098X;
label value SSNLJB42 H1291099X;
label value SSNLJB53 H1291100X;
label value STAAP09 H1291101X;
label value STAAU09 H1291102X;
label value STADE09 H1291103X;
label value STAFE09 H1291104X;
label value STAJA09 H1291105X;
label value STAJL09 H1291106X;
label value STAJU09 H1291107X;
label value STAMA09 H1291108X;
label value STAMY09 H1291109X;
label value STANO09 H1291110X;
label value STAOC09 H1291111X;
label value STAPR09 H1291112X;
label value STAPR31 H1291113X;
label value STAPR42 H1291114X;
label value STAPR53 H1291115X;
label value STASE09 H1291116X;
label value STJBDD31 H1291117X;
label value STJBDD42 H1291118X;
label value STJBDD53 H1291119X;
label value STJBMM31 H1291120X;
label value STJBMM42 H1291121X;
label value STJBMM53 H1291122X;
label value STJBYY31 H1291123X;
label value STJBYY42 H1291124X;
label value STJBYY53 H1291125X;
label value STNDIF31 H1291126X;
label value STNDIF53 H1291127X;
label value STOMAGED H1291128X;
label value STOMCH53 H1291129X;
label value STOMREMS H1291130X;
label value STPDIF31 H1291131X;
label value STPDIF53 H1291132X;
label value STPRAT09 H1291133X;
label value STPRAT31 H1291134X;
label value STPRAT42 H1291135X;
label value STPRAT53 H1291136X;
label value STRKAGED H1291137X;
label value STRKDX H1291138X;
label value TAXFRM09 H1291139X;
label value TEMPJB31 H1291140X;
label value TEMPJB42 H1291141X;
label value TEMPJB53 H1291142X;
label value THRTAGED H1291143X;
label value THRTREMS H1291144X;
label value THYRAGED H1291145X;
label value THYRREMS H1291146X;
label value TIMALN42 H1291147X;
label value TMTKUS42 H1291148X;
label value TOTDED09 H1291149X;
label value TRANS42 H1291150X;
label value TRBLE42 H1291151X;
label value TREATM42 H1291152X;
label value TRIAP09X H1291153X;
label value TRIAT09X H1291154X;
label value TRIAT31X H1291155X;
label value TRIAT42X H1291156X;
label value TRIAT53X H1291157X;
label value TRIAU09X H1291158X;
label value TRICH09X H1291159X;
label value TRICH31X H1291160X;
label value TRICH42X H1291161X;
label value TRICR09X H1291162X;
label value TRICR31X H1291163X;
label value TRICR42X H1291164X;
label value TRICR53X H1291165X;
label value TRIDE09X H1291166X;
label value TRIEV09 H1291167X;
label value TRIEX09X H1291168X;
label value TRIEX31X H1291169X;
label value TRIEX42X H1291170X;
label value TRIFE09X H1291171X;
label value TRIJA09X H1291172X;
label value TRIJL09X H1291173X;
label value TRIJU09X H1291174X;
label value TRILI09X H1291175X;
label value TRILI31X H1291176X;
label value TRILI42X H1291177X;
label value TRIMA09X H1291178X;
label value TRIMY09X H1291179X;
label value TRINO09X H1291180X;
label value TRIOC09X H1291181X;
label value TRIPR09X H1291182X;
label value TRIPR31X H1291183X;
label value TRIPR42X H1291184X;
label value TRISE09X H1291185X;
label value TRIST09X H1291186X;
label value TRIST31X H1291187X;
label value TRIST42X H1291188X;
label value TRTIMP09 H1291189X;
label value TSTSAGED H1291190X;
label value TSTSREMS H1291191X;
label value TYPEPE42 H1291192X;
label value UNABLE31 H1291193X;
label value UNABLE53 H1291194X;
label value UNEIMP09 H1291195X;
label value UNHAP42 H1291196X;
label value UNINS09 H1291197X;
label value UNION31 H1291198X;
label value UNION42 H1291199X;
label value UNION53 H1291200X;
label value USBORN42 H1291201X;
label value USCNOT42 H1291202X;
label value USLIVE42 H1291203X;
label value UTERAGED H1291204X;
label value UTERREMS H1291205X;
label value VETIMP09 H1291206X;
label value VISION42 H1291207X;
label value WAGIMP09 H1291208X;
label value WASAFDC H1291209X;
label value WASCHAMP H1291210X;
label value WASESTB H1291211X;
label value WASMCAID H1291212X;
label value WASMCARE H1291213X;
label value WASOTGOV H1291214X;
label value WASOTHER H1291215X;
label value WASPRIV H1291216X;
label value WASSSI H1291217X;
label value WASSTAT1 H1291218X;
label value WASSTAT2 H1291219X;
label value WASSTAT3 H1291220X;
label value WASSTAT4 H1291221X;
label value WASVA H1291222X;
label value WCPIMP09 H1291223X;
label value WHITPR42 H1291224X;
label value WHNBPR42 H1291225X;
label value WHNBST42 H1291226X;
label value WHNDEN42 H1291227X;
label value WHNEAT42 H1291228X;
label value WHNHEL42 H1291229X;
label value WHNHGT42 H1291230X;
label value WHNLAP42 H1291231X;
label value WHNPHY42 H1291232X;
label value WHNSAF42 H1291233X;
label value WHNSMK42 H1291234X;
label value WHNWGT42 H1291235X;
label value WILFIL09 H1291236X;
label value WKINBD31 H1291237X;
label value WKINBD42 H1291238X;
label value WKINBD53 H1291239X;
label value WLK3MO31 H1291240X;
label value WLK3MO53 H1291241X;
label value WLKDIF31 H1291242X;
label value WLKDIF53 H1291243X;
label value WLKLIM31 H1291244X;
label value WLKLIM53 H1291245X;
label value WRGLAS42 H1291246X;
label value WRHLTH42 H1291247X;
label value WRKLIM31 H1291248X;
label value WRKLIM53 H1291249X;
label value YCHJ3142 H1291250X;
label value YCHJ4253 H1291251X;
label value YNOINS31 H1291252X;
label value YNOINS42 H1291253X;
label value YNOINS53 H1291254X;
label value YNOUSC42 H1291255X;
label value ZIDOFD09 H1291256X;
label value ZIDOPU09 H1291257X;
label value ZIDSTL09 H1291258X;
label value ZIFOFD09 H1291259X;
label value ZIFOSR09 H1291260X;
label value ZIFWCP09 H1291261X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;


#delimit cr

/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H129.LOG and a data file named H129.DTA.  If these files (H129.DTA and H129.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

